/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MessageBox
extends Dialog {
    String message = "";

    public MessageBox(Shell shell) {
        this(shell, 65570);
    }

    public MessageBox(Shell shell, int n2) {
        super(shell, MessageBox.checkStyle(n2));
        this.checkSubclass();
    }

    static int checkStyle(int n2) {
        int n3;
        int n4;
        if ((n2 & 0x38000) == 0) {
            n2 |= 0x10000;
        }
        if ((n4 = n2 & (n3 = 4064)) == 32 || n4 == 256 || n4 == 288) {
            return n2;
        }
        if (n4 == 64 || n4 == 128 || n4 == 192 || n4 == 448) {
            return n2;
        }
        if (n4 == 1280 || n4 == 3584) {
            return n2;
        }
        n2 = n2 & ~n3 | 0x20;
        return n2;
    }

    public String getMessage() {
        return this.message;
    }

    public int open() {
        int n2 = 0;
        if ((this.style & 0x20) == 32) {
            n2 = 0;
        }
        if ((this.style & 0x120) == 288) {
            n2 = 1;
        }
        if ((this.style & 0xC0) == 192) {
            n2 = 4;
        }
        if ((this.style & 0x1C0) == 448) {
            n2 = 3;
        }
        if ((this.style & 0x500) == 1280) {
            n2 = 5;
        }
        if ((this.style & 0xE00) == 3584) {
            n2 = 2;
        }
        if (n2 == 0) {
            n2 = 0;
        }
        int n3 = 0;
        if ((this.style & 1) != 0) {
            n3 = 16;
        }
        if ((this.style & 2) != 0) {
            n3 = 64;
        }
        if ((this.style & 4) != 0) {
            n3 = 32;
        }
        if ((this.style & 8) != 0) {
            n3 = 48;
        }
        if ((this.style & 0x10) != 0) {
            n3 = 64;
        }
        int n4 = 0;
        if (OS.IsWinCE) {
            if ((this.style & 0x38000) != 0) {
                n4 = 0;
            }
        } else {
            if ((this.style & 0x8000) != 0) {
                n4 = 0;
            }
            if ((this.style & 0x10000) != 0) {
                n4 = 8192;
            }
            if ((this.style & 0x20000) != 0) {
                n4 = 4096;
            }
        }
        int n5 = n2 | n3 | n4;
        if ((this.style & 0x4000000) != 0) {
            n5 |= 0x100000;
        }
        if ((this.style & 0x6000000) == 0 && this.parent != null && (this.parent.style & 0x8000000) != 0) {
            n5 |= 0x100000;
        }
        if ((n5 & 0x1000) != 0) {
            n5 |= 0x2000;
            n5 &= 0xFFFFEFFF;
            n5 |= 0x40000;
        }
        int n6 = this.parent != null ? this.parent.handle : 0;
        Shell shell = null;
        Display display = null;
        if ((n5 & 0x2000) != 0) {
            display = this.parent.getDisplay();
            shell = display.getModalDialogShell();
            display.setModalDialogShell(this.parent);
        }
        TCHAR tCHAR = new TCHAR(0, this.message, true);
        TCHAR tCHAR2 = new TCHAR(0, this.title, true);
        int n7 = OS.MessageBox(n6, tCHAR, tCHAR2, n5);
        if ((n5 & 0x2000) != 0) {
            display.setModalDialogShell(shell);
        }
        if (n7 != 0) {
            int n8 = n5 & 0xF;
            if (n8 == 0) {
                return 32;
            }
            if (n8 == 1) {
                return n7 == 1 ? 32 : 256;
            }
            if (n8 == 4) {
                return n7 == 6 ? 64 : 128;
            }
            if (n8 == 3) {
                if (n7 == 6) {
                    return 64;
                }
                if (n7 == 7) {
                    return 128;
                }
                return 256;
            }
            if (n8 == 5) {
                return n7 == 4 ? 1024 : 256;
            }
            if (n8 == 2) {
                if (n7 == 4) {
                    return 1024;
                }
                if (n7 == 3) {
                    return 512;
                }
                return 2048;
            }
        }
        return 256;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

