/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Scale
extends Control {
    boolean ignoreResize;
    static final int TrackBarProc;
    static final TCHAR TrackBarClass;

    static {
        TrackBarClass = new TCHAR(0, "msctls_trackbar32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, TrackBarClass, wNDCLASS);
        TrackBarProc = wNDCLASS.lpfnWndProc;
        int n2 = OS.GetModuleHandle(null);
        int n3 = OS.GetProcessHeap();
        wNDCLASS.hInstance = n2;
        wNDCLASS.style &= 0xFFFFBFFF;
        wNDCLASS.style |= 8;
        int n4 = TrackBarClass.length() * TCHAR.sizeof;
        int n5 = OS.HeapAlloc(n3, 8, n4);
        OS.MoveMemory(n5, TrackBarClass, n4);
        wNDCLASS.lpszClassName = n5;
        OS.RegisterClass(wNDCLASS);
        OS.HeapFree(n3, 0, n5);
    }

    public Scale(Composite composite, int n2) {
        super(composite, Scale.checkStyle(n2));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(TrackBarProc, n2, n3, n4, n5);
    }

    static int checkStyle(int n2) {
        return Scale.checkBits(n2, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        this.checkWidget();
        int n4 = this.getBorderWidth();
        int n5 = n4 * 2;
        int n6 = n4 * 2;
        RECT rECT = new RECT();
        OS.SendMessage(this.handle, 1049, 0, rECT);
        if ((this.style & 0x100) != 0) {
            n5 += OS.GetSystemMetrics(21) * 10;
            int n7 = OS.GetSystemMetrics(3);
            n6 += rECT.top * 2 + n7 + n7 / 3;
        } else {
            int n8 = OS.GetSystemMetrics(2);
            n5 += rECT.left * 2 + n8 + n8 / 3;
            n6 += OS.GetSystemMetrics(20) * 10;
        }
        if (n2 != -1) {
            n5 = n2 + n4 * 2;
        }
        if (n3 != -1) {
            n6 = n3 + n4 * 2;
        }
        return new Point(n5, n6);
    }

    void createHandle() {
        super.createHandle();
        this.state |= 0x300;
        OS.SendMessage(this.handle, 1032, 0, 100);
        OS.SendMessage(this.handle, 1045, 0, 10);
        OS.SendMessage(this.handle, 1044, 10, 0);
    }

    int defaultForeground() {
        return OS.GetSysColor(OS.COLOR_BTNFACE);
    }

    public int getIncrement() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1048, 0, 0);
    }

    public int getMaximum() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1026, 0, 0);
    }

    public int getMinimum() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1025, 0, 0);
    }

    public int getPageIncrement() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1046, 0, 0);
    }

    public int getSelection() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1024, 0, 0);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void setBackgroundImage(int n2) {
        super.setBackgroundImage(n2);
        this.ignoreResize = true;
        OS.SendMessage(this.handle, 5, 0, 0);
        this.ignoreResize = false;
    }

    void setBackgroundPixel(int n2) {
        super.setBackgroundPixel(n2);
        this.ignoreResize = true;
        OS.SendMessage(this.handle, 5, 0, 0);
        this.ignoreResize = false;
    }

    public void setIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        int n3 = OS.SendMessage(this.handle, 1025, 0, 0);
        int n4 = OS.SendMessage(this.handle, 1026, 0, 0);
        if (n2 > n4 - n3) {
            return;
        }
        OS.SendMessage(this.handle, 1047, 0, n2);
    }

    public void setMaximum(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 1025, 0, 0);
        if (n3 >= 0 && n3 < n2) {
            OS.SendMessage(this.handle, 1032, 1, n2);
        }
    }

    public void setMinimum(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 1026, 0, 0);
        if (n2 >= 0 && n2 < n3) {
            OS.SendMessage(this.handle, 1031, 1, n2);
        }
    }

    public void setPageIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        int n3 = OS.SendMessage(this.handle, 1025, 0, 0);
        int n4 = OS.SendMessage(this.handle, 1026, 0, 0);
        if (n2 > n4 - n3) {
            return;
        }
        OS.SendMessage(this.handle, 1045, 0, n2);
        OS.SendMessage(this.handle, 1044, n2, 0);
    }

    public void setSelection(int n2) {
        this.checkWidget();
        OS.SendMessage(this.handle, 1029, 1, n2);
    }

    int widgetStyle() {
        int n2 = super.widgetStyle() | 0x10000 | 8 | 1;
        if ((this.style & 0x100) != 0) {
            return n2 | 0x400;
        }
        return n2 | 2;
    }

    TCHAR windowClass() {
        return TrackBarClass;
    }

    int windowProc() {
        return TrackBarProc;
    }

    LRESULT WM_PAINT(int n2, int n3) {
        boolean bl2;
        boolean bl3 = bl2 = this.findBackgroundControl() != null;
        if (!bl2 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            Control control = this.findThemeControl();
            boolean bl4 = bl2 = control != null;
        }
        if (bl2) {
            boolean bl5;
            boolean bl6 = bl5 = this.drawCount == 0 && OS.IsWindowVisible(this.handle);
            if (bl5) {
                OS.SendMessage(this.handle, 11, 0, 0);
            }
            this.ignoreResize = true;
            OS.SendMessage(this.handle, 5, 0, 0);
            this.ignoreResize = false;
            if (bl5) {
                OS.SendMessage(this.handle, 11, 1, 0);
                OS.InvalidateRect(this.handle, null, false);
            }
        }
        return super.WM_PAINT(n2, n3);
    }

    LRESULT WM_SIZE(int n2, int n3) {
        if (this.ignoreResize) {
            return null;
        }
        return super.WM_SIZE(n2, n3);
    }

    LRESULT wmScrollChild(int n2, int n3) {
        int n4 = n2 & 0xFFFF;
        switch (n4) {
            case 4: 
            case 8: {
                return null;
            }
        }
        Event event = new Event();
        this.sendEvent(13, event);
        return null;
    }
}

