!include nsDialogs.nsh
!include LogicLib.nsh

Name nsiskin
OutFile nsiskin.exe

XPStyle on

Var Dialog
Var Label
Var Text
Var BGImage
Var NextImg
Var Progress
Var MsgBox
Var Percent

!AddPluginDir .\

Page custom nsDialogsPage nsDialogsPageLeave
Page instfiles


!define __NSD_Edit_CLASS EDIT
!define __NSD_Edit_STYLE ${DEFAULT_STYLES}|${WS_TABSTOP}|${ES_AUTOHSCROLL}|${ES_MULTILINE}
!define __NSD_Edit_EXSTYLE ${WS_EX_WINDOWEDGE}|${WS_EX_CLIENTEDGE}
!insertmacro __NSD_DefineControl Edit

Function .onInit
    InitPluginsDir
    File `/ONAME=$PLUGINSDIR\bg.bmp` `image\bg.bmp`
    File `/ONAME=$PLUGINSDIR\close.bmp` `image\close.bmp`
    File `/ONAME=$PLUGINSDIR\next.bmp` `image\next.bmp`
    File `/ONAME=$PLUGINSDIR\checkbox.bmp` `image\checkbox.bmp`
    File `/ONAME=$PLUGINSDIR\edit.bmp` `image\edit.bmp`
     File `/ONAME=$PLUGINSDIR\loading1.bmp` `image\loading1.bmp`
    File `/ONAME=$PLUGINSDIR\loading2.bmp` `image\loading2.bmp`
    File `/ONAME=$PLUGINSDIR\quit.bmp` `image\quit.bmp`
    File `/ONAME=$PLUGINSDIR\cancel.bmp` `image\cancel.bmp`
    File `/ONAME=$PLUGINSDIR\msgboxbg.bmp` `image\msgboxbg.bmp`
FunctionEnd


Function .onGUIInit
	;参数分别是窗体的长，宽，标题栏的高度
  ;在标题栏高度范围内鼠标左键按住不放，可以拖动窗口
	nsiskin::Init 513 354 30
FunctionEnd


Function onClickNext
	GetFunctionAddress $0 NSD_TimerFun
  nsDialogs::KillTimer $0
  Abort
  MessageBox MB_OK "下一步"
  ${NSD_SetText} $Label "next step"
	SendMessage $Progress ${PBM_SETPOS} 50 0
  Abort
FunctionEnd


Function onClickQuit
  ;参数分别是父窗口句柄，长，宽，标题，背景图片
  ;返回值是新建窗口句柄
  nsiskin::CreateWindow $HWNDPARENT 349 184 "msgbox" "$PLUGINSDIR\msgboxbg.bmp"
  pop $MsgBox
  SendMessage $HWNDPARENT ${WM_GETFONT} 0 0 $R7

  System::Call 'User32::CreateWindowEx(i0,t"Button", t"", i0x5000000b,i325,i8,i15,i15,i$MsgBox,i2,i0,i0)i.R1'
  ;参数分别是控件句柄，背景图片
  ;背景图片从上到下的状态分别是normal,down,highlight,disable,focus
  nsiskin::Attach $R1 "$PLUGINSDIR\close.bmp"

  System::Call 'User32::CreateWindowEx(i${WS_EX_TRANSPARENT},t"STATIC", t"quit confirm?", i${WS_CHILD}|${WS_VISIBLE}|${WS_CLIPSIBLINGS},i120,i60,i100,i17,i$MsgBox,i1130,i0,i0)i.R1'
  SendMessage $R1 ${WM_SETFONT} $R7 TRUE
  System::Call 'User32::CreateWindowEx(i0,t"Button", t"quit", i0x5000000b,i100,i120,i88,i25,i$MsgBox,i1,i0,i0)i.R1'
  SendMessage $R1 ${WM_SETFONT} $R7 TRUE
  nsiskin::Attach $R1 "$PLUGINSDIR\quit.bmp"

  System::Call 'User32::CreateWindowEx(i0,t"Button", t"cancel", i0x5000000b,i200,i120,i88,i25,i$MsgBox,i2,i0,i0)i.R1'
  SendMessage $R1 ${WM_SETFONT} $R7 TRUE
  nsiskin::Attach $R1 "$PLUGINSDIR\cancel.bmp"

  EnableWindow $HWNDPARENT 0
  ShowWindow $MsgBox ${SW_SHOW}
  Abort
FunctionEnd


Function onClickCheck
	Pop $R0
	${NSD_GetState} $R0 $R9
	${If} $R9 == ${BST_CHECKED}
		MessageBox MB_OK "checked"
	${EndIf}
  Abort

	${If} $R0 == $0
		IntOp $9 $9 !
  		MessageBox MB_OK $9
  	${EndIf}
  Abort
FunctionEnd


Function NSD_TimerFun
    ${If} $Percent != 100
          IntOp $Percent $Percent + 10
          SendMessage $Progress ${PBM_SETPOS} $Percent 0
    ${Else}
    	strcpy $Percent 0
    ${EndIf}
FunctionEnd


Function nsDialogsPage

	nsDialogs::Create 1018
	Pop $Dialog

	${If} $Dialog == error
		Abort
	${EndIf}

	${NSD_CreateLabel} 100 50 100% 12u "Hello, welcome to nsiskin v2!"
	Pop $Label

	${NSD_CreateButton} 100 100 88 25 "停止进度条"
	Pop $0
	nsiskin::Attach $0 "$PLUGINSDIR\next.bmp"
	GetFunctionAddress $3 onClickNext
	nsDialogs::OnClick $0 $3

	${NSD_CreateButton} 200 100 88 25 "show win"
	Pop $0
	nsiskin::Attach $0 "$PLUGINSDIR\quit.bmp"
	GetFunctionAddress $3 onClickQuit
	nsDialogs::OnClick $0 $3

	${NSD_CreateCheckBox} 100 150 88 15 "Checkbox"
	Pop $0
  ;前面两个参数同上，第三个参数为默认是否选中
	nsiskin::Attach $0 "$PLUGINSDIR\checkbox.bmp" true
	GetFunctionAddress $3 onClickCheck
	nsDialogs::OnClick $0 $3

	${NSD_CreateEdit} 100 200 80 26 "Type something here..."
	Pop $Text
  ;背景图片从上到下是 normal，获得输入焦点
	nsiskin::Attach $Text "$PLUGINSDIR\edit.bmp"

	${NSD_CreateProgressBar} 20 260 474 5 ""
	Pop $Progress
  ;参数分别是控件句柄，背景图，前景图
  ;背景图如果宽度为1，则直接平铺，其他宽度为奇数，则中间的1像素平铺，两边拷贝贴图
  ;前景图宽度为1或偶数，则直接平铺，其他情况参考背景图
	nsiskin::Attach $Progress "$PLUGINSDIR\loading1.bmp" "$PLUGINSDIR\loading2.bmp"
  ;参数意义是对话框句柄，对话框背景图
	nsiskin::Attach $Dialog "$PLUGINSDIR\bg.bmp"

	strcpy $Percent 0
    GetFunctionAddress $0 NSD_TimerFun
    nsDialogs::CreateTimer $0 500

	nsDialogs::Show

FunctionEnd

Function nsDialogsPageLeave

	${NSD_GetText} $Text $0
	MessageBox MB_OK "You typed:$\n$\n$0"

FunctionEnd

Section

	DetailPrint "hello world"

SectionEnd
;其他疑问，请在qq群37586365提问，群主一定热心回答