---------------------------------------------------------------------------------------------
----
----    Level03.Bikers.lua
----    Scenary file
----
----    Revision history: 
----
----------------------------------------------------------------------------------------------

AI.DoFile( "scripts:Levels\\Common.lua", false );

--------------------------------------------------------
-- Name: OnSave()
-- Desc:
--------------------------------------------------------
function Level.OnSave()

    Stream.WriteInt(0); -- version

	Stream.WriteBool( Level.PizzaPoisoned );
	Stream.WriteInt( Level.CagePower );
	Stream.WriteBool( Level.GuitarAmpOff );
	Stream.WriteBool( Level.GuitarAmpDeadly );
	Stream.WriteBool( Level.DeadlyAmpReady );
	Stream.WriteBool( Level.UseSoporific );
	Stream.WriteBool( Level.VargasSoporific );
	Stream.WriteBool( Level.VargasOnBed	);
	Stream.WriteBool( Level.VargasTalk );
	Stream.WriteBool( Level.BarmanTalk );
	Stream.WriteInt( Level.CourierDrink );
	Stream.WriteBool( Level.PoisonUsed );
	Stream.WriteBool( Level.ViagraUsed );
	Stream.WriteInt( Level.VarGuardDrink );
	Stream.WriteBool( Level.GuitarMusic );
	Stream.WriteBool( Level.PianoMusic );
	Stream.WriteBool( Level.LetsPlayTogether );
	Stream.WriteBool( Level.TualetOutOfOrder );
	Stream.WriteBool( Level.VargasViagra );
	Stream.WriteBool( Level.CutscenePhoto );
	Stream.WriteBool( Level.CutsceneVargas );
	Stream.WriteBool( Level.CutsceneBarman );

	Stream.WriteBool( Level.BikersTalk1 );
	Stream.WriteBool( Level.GuitarTalk );
	
	Stream.WriteString( "LEVL" );    
    Level.OnSave_Common();
end

--------------------------------------------------------
-- Name: OnLoad()
-- Desc:
--------------------------------------------------------
function Level.OnLoad()

	local version = Stream.ReadInt();
	if (version > 0) then
		print("ERROR: Bad stored scenary chunk version " .. tostring(version));
		return;
	end

	Level.PizzaPoisoned   = Stream.ReadBool();
	Level.CagePower       = Stream.ReadInt();	
	Level.GuitarAmpOff    = Stream.ReadBool();
	Level.GuitarAmpDeadly = Stream.ReadBool();
	Level.DeadlyAmpReady  = Stream.ReadBool();
	Level.UseSoporific    = Stream.ReadBool();
	Level.VargasSoporific = Stream.ReadBool();
	Level.VargasOnBed	  = Stream.ReadBool();
	Level.VargasTalk	  = Stream.ReadBool();
	Level.BarmanTalk      = Stream.ReadBool();
	Level.CourierDrink    = Stream.ReadInt();
	Level.PoisonUsed	  = Stream.ReadBool();
	Level.ViagraUsed	  = Stream.ReadBool();
	Level.VarGuardDrink   = Stream.ReadInt();
	Level.GuitarMusic     = Stream.ReadBool();
	Level.PianoMusic	  = Stream.ReadBool();
	Level.LetsPlayTogether = Stream.ReadBool();
	Level.TualetOutOfOrder = Stream.ReadBool();
	Level.VargasViagra     = Stream.ReadBool();
	Level.CutscenePhoto    = Stream.ReadBool();
	Level.CutsceneVargas   = Stream.ReadBool();
	Level.CutsceneBarman   = Stream.ReadBool();

	Level.BikersTalk1      = Stream.ReadBool();
	Level.GuitarTalk       = Stream.ReadBool();
	
	local magic            = Stream.ReadString();
    if (magic != "LEVL") then
		print("ERROR: Bad stored scenary chunk format");
		return
    end
	
	Level.OnLoad_Common();
	Level.OnFinishLoad();

end

--------------------------------------------------------
-- Name: OnFinishLoad()
-- Desc:
--------------------------------------------------------
function Level.OnFinishLoad()

    Level.SetDoorKey( 'DR02' , 'KEY1' ); -- Office with amplifier
	Level.SetDoorKey( 'DR14' , 'KEY2' ); -- Where reporter held

	Level.DRINK_STATE_DEFAULT   = 0;
	Level.DRINK_STATE_POISON    = 1;
	Level.DRINK_STATE_VIAGRA    = 2;
	Level.DRINK_STATE_SOPORIFIC = 3;

	Level.SetLevelStats( "NumStunTargets" , 1 );
	Level.SetLevelStats( "NumMissionTargets" , 1 );

	Level.SetLevelStats( "ScoreRankFactor", 2.0 );

	Level.OnFinishLoad_Common();
	
	Level.AddMusic( Level.MUSIC_MOOD_DEFAULT, "#0.2#Sounds\\Music\\level03.ogg" );
	Level.AddMusic( Level.MUSIC_MOOD_ACTION, "#1.0#Sounds\\Music\\Alarm.ogg" );	

	if ( Level.GuitarMusic == true ) then
		Level.PlayGuitarMusic(true);
		Level.StopSound( Level.FindSound('radio_bar') );
	end;

	if ( Level.PianoMusic == true ) then
		Level.PlayPianoMusic(true);
		Level.StopSound( Level.FindSound('radio_bar') );
	end;

	Level.EnableEffect( 'EHIT', false );
	Level.EnableLight( 'CVG1', false );

	System:SetVar("r_terrainlod", 800000.0 );
	
	if ( Level.CutscenePhoto == false ) then
		Level.InitCutscene_Photo();
	else
		Level.SetWorldObjectAnimFrame( Level.FindWorldObject('C16P'), 614 );
	end;

	if ( Level.CutsceneVargas == false ) then
		Level.InitCutscene_Vargas();
	end;

	if ( Level.CutsceneBarman == false ) then
		Level.InitCutscene_Barman();
	else
		Level.SetWorldObjectAnimFrame( Level.FindWorldObject('CBC5'), 1000 );
	end;
end

----------------------------------------------------------------------------------------------
-- Name: OnInitialize()
-- Desc:
----------------------------------------------------------------------------------------------
function Level.OnInitialize()

	Level.OnInitialize_Common();
    
	Level.TurnOffList       = { 'LT01', 'LT04', 'LN01', 'LT05', 'LT06' };

    Level.ItemInHands[ 'POIS' ] = 0;
	Level.ItemInHands[ 'SOPO' ] = 0;
	Level.ItemInHands[ 'VIGR' ] = 0;

	Level.PizzaPoisoned   = false;
	Level.CagePower       = 2;
	Level.GuitarAmpOff    = false;
	Level.GuitarAmpDeadly = false;
	Level.DeadlyAmpReady  = false;
	Level.UseSoporific    = false;
	Level.VargasSoporific = false;
	Level.VargasViagra    = false;
	Level.VargasOnBed	  = false;
	Level.VargasTalk	  = false;
	Level.BarmanTalk      = false;
	Level.CourierDrink    = 0;
	Level.PoisonUsed	  = false;
	Level.ViagraUsed	  = false;
	Level.VarGuardDrink   = 0;	
	Level.GuitarMusic     = false;	
	Level.PianoMusic	  = false;
	Level.LetsPlayTogether = false;
	Level.TualetOutOfOrder = false;

	Level.CutscenePhoto     = false;
	Level.CutsceneVargas    = false;
	Level.CutsceneBarman    = false;

	Level.BikersTalk1       = false;
	Level.GuitarTalk		= false;
		
    local player     = Level.FindActor('STRG');
    if ( player != nil ) then

		local n = Level.ApplyBriefingEquippedItems( player );
		if ( n < 0 ) then

			local pistol     = Level.CreateItem("PM", "Weapon");    
			Actor.PutWeapon( player, Actor.WEAPON_SLOT_PISTOL, pistol );
		
			local garrote    = Level.CreateItem("Garrote", "Weapon" );
    		Actor.PutWeapon( player, Actor.WEAPON_SLOT_FIBERWIRE, garrote );
        
			local chlor      = Level.CreateItem("Chloroform", "Weapon" );
			Actor.PutWeapon( player, Actor.WEAPON_SLOT_CHLOROFORM, chlor );

		end;        
        
    end;

	local courActor = Level.FindActor('COUR');
	local package = Level.CreateItem( "User:Lev3Money" , "Equipment" );
	if ( package != nil ) then
		Entity.SetUniqueID( package, 'PCKG' );
		Entity.SetSkin( package, 0 );
        Level.SetCustomItemName( package, 'PCKG' );
		Level.SetItemHighPriority( package, true );
        Actor.PutInventory( courActor, package, false, false );
	end;

	-- Tips
	
	AI.RegisterEventHandler("EssSwitchLight"    , "OnSwitchLight_Common");
	AI.RegisterEventHandler("EssSeeCustomObject", "OnSeeCustomObject_Common");
	
	AI.SetPlayerForm(AI.FindPlayer('STRG'), "Civilian");    
	
	--AI.SetPlayerForm(AI.FindPlayer('STRG'), "Biker");    
	--AI.SetPlayerForm(AI.FindPlayer('STRG'), "Mechanic");    
	--AI.SetPlayerForm(AI.FindPlayer('STRG'), "Courier");    
	
	AI.PlayerEnterZone(AI.FindPlayer('STRG'), "global:know", 'GLKP');
	AI.PlayerEnterZone(AI.FindPlayer('STRG'), "global", 'GLBL');

	AI.EnableZone( "guitar_amp", false );
	AI.EnableZone( "vargas_courier", false );
	AI.SetJob( AI.FindNPC('COUR'), 'wait');
			
	AI.SetOutdoorVisionCoeff(-0.5, 1.0, 1.0);

	Level.AddActionHandler( Level.AH_ACTOR_KILLED, 'VARG' , "OnKillVargas");

	Level.AddActionHandler( Level.AH_ACTOR_HITTED, 'KABR' , "PlayGuitarMusic(false)");

	Level.AddActionHandler( Level.AH_ACTOR_KILLED, 'ART2' , "PlayPianoMusic(false)");
	Level.AddActionHandler( Level.AH_ACTOR_HITTED, 'ART2' , "PlayPianoMusic(false)");
	
	local vargas = Level.FindActor('VARG');
	Actor.EnableBodyHide( vargas, false );
	Actor.CanStunOnly( vargas, true );

	Level.OnAddMissionTask( 'FREE' );
	Level.OnAddMissionTask( 'VARG' );
	Level.OnAddMissionTask( 'KABR' );

	Level.PutDoorKey( Level.FindActor('GR04'), 'KEY2' , 'KEY2' );	
	Level.PutDoorKey( Level.FindActor('VGRD'), 'KEY1' , 'KEY1' );	

	Level.OnFinishLoad();

end;

--------------------------------------------------------
-- Name: OnAddMissionTask()
-- Desc: 
--------------------------------------------------------
function Level.OnAddMissionTask(taskId)

	if ( taskId == 'KABR' ) then

		Level.AddMissionTask( 'TSK3', taskId, true, false );

		Level.AddActionHandler( Level.AH_ACTOR_KILLED, 'KABR' , "OnKillKabrera");
		Actor.MarkAsTarget( Level.FindActor('KABR'), true );

		if ( Level.GetDifficulty() < Level.LD_HARD ) then

			Level.EnableWorldObjectFlash( Level.FindWorldObject('CAG1'), true, 200, 0, 0 );

			if ( Level.PlayerHasPoison() == true ) then
				Level.EnableWorldObjectFlash( Level.FindWorldObject('PIZA'), true, 200, 0, 0 );
			end;

			Level.EnableEntityFlash( Level.FindItem('EAMP'), true );

		end;

	elseif ( taskId == 'VARG' ) then

		Level.AddMissionTask( 'TSK2', taskId, true, false );
		Actor.MarkAsTarget( Level.FindActor('VARG'), true );
		--Level.AddActionHandler( Level.AH_ACTOR_HITTED, 'VARG' , "OnHitVargas");
		Level.EnableEntityFlash( Level.FindItem('SOPO'), true );
	elseif ( taskId == 'FREE' ) then

		Level.AddMissionTask( 'TSK1', taskId, true, false );

	elseif ( taskId == 'LEAV' ) then

		Level.AddMissionTask( 'TSK4', taskId );

	end;

	
end

--------------------------------------------------------
-- Name: OnCompleteMissionTask()
-- Desc: 
--------------------------------------------------------
function Level.OnCompleteMissionTask(taskId)
	
	local checkMissionComplete = false;
		
	if ( taskId == 'LEAV' ) then	
	    checkMissionComplete = true;	
	elseif ( taskId == 'KABR' ) then
		Level.EnableWorldObjectFlash( Level.FindWorldObject('PIZA'), false );
		Level.EnableEntityFlash( Level.FindItem('EAMP'), false );
	elseif ( taskId == 'VARG' ) then
		Level.EnableWorldObjectFlash( Level.FindWorldObject('TRNK'), false );
	end;
	
	Level.CompleteMissionTask( taskId, checkMissionComplete );

	if ( Level.IsMissionTaskCompleted('FREE') == true and
	     Level.IsMissionTaskCompleted('KABR') == true and
	     Level.IsMissionTaskCompleted('VARG') == true and		 
	     Level.HasMissionTask('LEAV') == false ) then
	    		
	     Level.OnAddMissionTask('LEAV');
	end		
			
end

--------------------------------------------------------
-- Name: Level.GetPlayerPoisonItemID()
-- Desc: 
--------------------------------------------------------
function Level.GetPlayerPoisonItemID()

  local player = Level.GetPlayer();

  if ( Actor.HasItem( player, 'POIS' ) == true ) then
	  return 'POIS';
  end;

  return nil;

end

----------------------------------------------------------------------------------------------
-- Name: PlayerHasPoison()
-- Desc:
----------------------------------------------------------------------------------------------
function Level.PlayerHasPoison()
	return Level.GetPlayerPoisonItemID() != nil and Level.PoisonUsed == false;	
end

----------------------------------------------------------------------------------------------
-- Name: PlayerHasSoporific()
-- Desc:
----------------------------------------------------------------------------------------------
function Level.PlayerHasSoporific()
	return Level.UseSoporific == false and Actor.HasItem( Level.GetPlayer(), 'SOPO' ) == true;
end

----------------------------------------------------------------------------------------------
-- Name: PlayerHasViagra()
-- Desc:
----------------------------------------------------------------------------------------------
function Level.PlayerHasViagra()
	return Level.ViagraUsed == false and Actor.HasItem( Level.GetPlayer(), 'VIGR' ) == true;
end

----------------------------------------------------------------------------------------------
-- Name: PlayerHasVargasPackage()
-- Desc:
----------------------------------------------------------------------------------------------
function Level.PlayerHasVargasPackage()
	return Actor.HasItem( Level.GetPlayer(), 'PCKG' ) == true;
end

----------------------------------------------------------------------------------------------
-- Name: OnHitVargas()
-- Desc:
----------------------------------------------------------------------------------------------
function Level.OnHitVargas()
	Level.EnableWorldObjectAnim( Level.FindWorldObject( 'BSAF' ), false );
end

----------------------------------------------------------------------------------------------
-- Name: OnKillVargas()
-- Desc:
----------------------------------------------------------------------------------------------
function Level.OnKillVargas()	
	Level.FailedMission( Level.GetMissionText('VARF' ) );
	Level.EnableWorldObjectAnim( Level.FindWorldObject( 'BSAF' ), false );
end

----------------------------------------------------------------------------------------------
-- Name: OnKillKabrera()
-- Desc:
----------------------------------------------------------------------------------------------
function Level.OnKillKabrera()
	Level.OnCompleteMissionTask('KABR');
	Level.PlayGuitarMusic(false);
end

----------------------------------------------------------------------------------------------
-- Name: OnDropCage()
-- Desc:
----------------------------------------------------------------------------------------------
function Level.OnDropCage()

	local box = { x1 = -575.34, y1 = 105.0 , z1 = 285.25,
	              x2 = -554.93, y2 = 123.42, z2 = 314.70 };
		
	AI.AddScriptDynamicObstacle( 'STAT', box.x1, box.y1, box.z1,
	                                     box.x2, box.y2, box.z2 );

	local kbox = { x1 = -576.42, y1 = 115.0 , z1 = 267.94,
				   x2 = -560.08, y2 = 142.12, z2 = 284.29 };
	
	local actors = AI.GetActors();
	
	for i in actors do
		local a = actors[i];		
		local pos = AI.GetPosition(a);
				
		if pos.x > kbox.x1 and pos.y > kbox.y1 and pos.z > kbox.z1 and
		   pos.x < kbox.x2 and pos.y < kbox.y2 and pos.z < kbox.z2 then
		   
		   local uid = AI.GetUID(a);

		   if ( uid == 'KABR' ) then
			  Actor.RecieveDamage( Level.FindActor('KABR') , 2.0 );
		   else		   
			  AI.KillNPC(a, 0.0);
		   end;
		   
		end
	end
		
	local pos = { x = (kbox.x1 + kbox.x2) / 2,
	              y = (kbox.y1 + kbox.y2) / 2,
	              z = (kbox.z1 + kbox.z2) / 2 };

	AI.AddSound("boom", 100.0, pos);

end

----------------------------------------------------------------------------------------------
-- Name: DropCage()
-- Desc: Release cage
----------------------------------------------------------------------------------------------
function Level.DropCage()

	Level.EnableWorldObjectPhysics( Level.FindWorldObject('KLT1'), true );
	AI.Invoke( "Level.AddWorldObjectPhysicsForce( Level.FindWorldObject('KLT1'), 0.0, 0.0, 30.0 )", 0.6 );
	AI.Invoke( "Level.OnDropCage()", 0.3 );

	Level.EnableWorldObjectFlash( Level.FindWorldObject('CAG1'), false );

	Level.SetWorldObjectPos( Level.FindWorldObject('CAG1'), -476.0, 60.0, 225.0 );
	Level.SetWorldObjectPos( Level.FindWorldObject('CAG2'), -476.0, 60.0, 225.0 );

	Level.CagePower = 0;

end


----------------------------------------------------------------------------------------------
-- Name: OnEnter_SimpleTrigger10()
-- Desc:
----------------------------------------------------------------------------------------------
function Level.OnEnter_SimpleTrigger10()
	local npc = AI.FindNPC('VARG');
	if ( npc != nil and AI.IsUsingAnchor( npc, AI.FindAnchor('AN13' ) ) == true ) then
		Actor.CanbeKilledSilent( Level.FindActor('VARG'), false );
	end;
end

----------------------------------------------------------------------------------------------
-- Name: OnLeave_SimpleTrigger10()
-- Desc:
----------------------------------------------------------------------------------------------
function Level.OnLeave_SimpleTrigger10()
	Actor.CanbeKilledSilent( Level.FindActor('VARG'), true );
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_AIAnchor10()
-- Desc: Call when Vargas is start smoking to let guard go drink water..
----------------------------------------------------------------------------------------------
function Level.OnAction_AIAnchor10()
	-- Enable this based on difficulty

	--local npc = AI.FindNPC('VGRD');
	--if ( npc == nil ) then
		--return;
	--end;

	--if ( AI.GetJob( npc ) != 'default' ) then
		--return;
	--end;

	--Level.RunAnchorJob( npc, 'AN29' );
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_AIAnchor32()
-- Desc: Vargas guard poison death
----------------------------------------------------------------------------------------------
function Level.OnAction_AIAnchor32()
	AI.Invoke( "Actor.RecieveDamage( Level.FindActor('VGRD') , 2.0 )" , 7.5 );
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_AIAnchor31()
-- Desc: Vargas guard wake up
----------------------------------------------------------------------------------------------
function Level.OnAction_AIAnchor31()
	AI.SetJob( AI.FindNPC('VGRD'), 'default' );
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_AIAnchor26()
-- Desc: Vargas guard drink
----------------------------------------------------------------------------------------------
function Level.OnAction_AIAnchor29()
	if ( Level.VarGuardDrink == Level.DRINK_STATE_SOPORIFIC ) then
		AI.SetJob( AI.FindNPC('VGRD'), 'sleep' );
		Level.VarGuardDrink = Level.DRINK_STATE_DEFAULT;
	elseif ( Level.VarGuardDrink == Level.DRINK_STATE_POISON ) then
		AI.SetJob( AI.FindNPC('VGRD'), 'poison' );
	end;

end

----------------------------------------------------------------------------------------------
-- Name: OnAction_AIAnchor26()
-- Desc: Courier death from poison
----------------------------------------------------------------------------------------------
function Level.OnAction_AIAnchor26()
	AI.Invoke( "Actor.RecieveDamage( Level.FindActor('COUR') , 2.0 )" , 7.5 );
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_AIAnchor79()
-- Desc: Callback after courier checked girl
----------------------------------------------------------------------------------------------
function Level.OnAction_AIAnchor79()	
	AI.Invoke( "AI.SetJob( AI.FindNPC('COUR'), 'default' )", 0.5 );
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_AIAnchor22()
-- Desc: Callback after courier drinking
----------------------------------------------------------------------------------------------
function Level.OnAction_AIAnchor21()

	if ( Level.CourierDrink == Level.DRINK_STATE_POISON ) then
		AI.SetJob( AI.FindNPC('COUR'), 'poison' );
	elseif ( Level.CourierDrink == Level.DRINK_STATE_VIAGRA ) then
		AI.SetJob( AI.FindNPC('COUR'), 'woman' );
		Level.CourierDrink = Level.DRINK_STATE_DEFAULT;		
	elseif ( Level.CourierDrink == Level.DRINK_STATE_SOPORIFIC ) then
		Level.CourierDrink = Level.DRINK_STATE_DEFAULT;		
		AI.SetJob( AI.FindNPC('COUR'), 'sleep' );
	end;

end

----------------------------------------------------------------------------------------------
-- Name: OnAnchor_AIAnchor122()
-- Desc: Courier sleeping
----------------------------------------------------------------------------------------------
function Level.OnAnchor_AIAnchor122()
	AI.SetJob( AI.FindNPC('COUR'), 'default' );
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_AIAnchor22()
-- Desc: Callback for barman to pour drink into courier glass
----------------------------------------------------------------------------------------------
function Level.OnAction_AIAnchor22()
	
	local npc = AI.FindNPC('BARM');
	if ( npc == nil or AI.IsDefault(npc) == false ) then
		return;
	end;

	if ( AI.IsUsingAnchor( npc, AI.FindAnchor('AN17') ) == false ) then
		return;
	end;

	Level.RunAnchorJob( npc, 'AN23', true );	

end

----------------------------------------------------------------------------------------------
-- Name: OnAction_AIAnchor13()
-- Desc:
----------------------------------------------------------------------------------------------
function Level.OnAction_AIAnchor13()
	Actor.CanbeKilledSilent( Level.FindActor('VARG'), false );
	AI.Invoke( "Level.VargasOnBed = true", 7.0 );

	if ( Level.GetDifficulty() < Level.LD_HARD ) then
		Level.EnableWorldObjectFlash( Level.FindWorldObject('SBT2'), true );
	end;
end

----------------------------------------------------------------------------------------------
-- Name: OnSoundPoison()
-- Desc: 
----------------------------------------------------------------------------------------------
function Level.OnSoundPoison()
	local p = { x = -682.16632, y = 107.89819, z = 216.00456 };	
	AI.AddSound('whistle', 50.0, p );
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_AIAnchor06()
-- Desc:
----------------------------------------------------------------------------------------------
function Level.OnAction_AIAnchor06()
	AI.Invoke( "Actor.RecieveDamage( Level.FindActor('KABR') , 2.0 )" , 7.5 );
	--AI.Invoke( "Level.OnSoundPoison()", 7.0 );
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_AIAnchor05()
-- Desc:
----------------------------------------------------------------------------------------------
function Level.OnAction_AIAnchor05()
	if ( Level.PizzaPoisoned == true ) then
		AI.SetJob( AI.FindNPC('KABR'), 'poison' );
	else
		AI.SetJob( AI.FindNPC('KABR'), 'smoke' );
	end;

end

----------------------------------------------------------------------------------------------
-- Name: OnSoundAmplifier()
-- Desc: 
----------------------------------------------------------------------------------------------
function Level.OnSoundAmplifier()
	local p = {};
	p.x, p.y, p.z = node.GetPosition( Entity.GetNode( Level.FindItem('EAMP') ) );
	AI.AddSound('boom', 120.0, p );	
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_AIAnchor08()
-- Desc: Kabrera turning on amplifier
----------------------------------------------------------------------------------------------
function Level.OnAction_AIAnchor08()
	
	if ( Level.GuitarAmpDeadly == true ) then
		
		local kabrActor = Level.FindActor('KABR');
		local kabrNPC	= AI.FindNPC('KABR');

	    AI.DisableActorControl( kabrActor, true );
		AI.Enable( kabrNPC, "sleeping" );
		AI.Enable( kabrNPC, "sleeping" );

		Actor.StartCustomAnim( kabrActor, "Custom_GuitarAmp_Shock", 0.1);
 	    AI.Invoke( "Actor.RecieveDamage( Level.FindActor('KABR'), 2.0, 'VEL' )", 1.45 );
		AI.Invoke( "Level.OnSoundAmplifier()", 1.5 );

		Level.EnableEffect('EHIT', true );
		AI.Invoke( "Level.EnableEffect( 'EHIT' , false )", 1.3 );
				
	else
		Level.GuitarAmpOff = false;
		AI.SetJob( AI.FindNPC('KABR'), 'default' );
		AI.EnableZone( "guitar_amp", true );
	end;
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_AIAnchor04()
-- Desc: Kabrera watching girl
----------------------------------------------------------------------------------------------
function Level.OnAction_AIAnchor04()
	Level.RunAnchorJob( AI.FindNPC('WOM1'), 'AN50' , true );
end

----------------------------------------------------------------------------------------------
-- Name: PlayGuitarMusic()
-- Desc: 
----------------------------------------------------------------------------------------------
function Level.PlayGuitarMusic( onOff )
	Level.GuitarMusic = onOff;	
	if ( onOff == true ) then
		Level.PlaySound( Level.FindSound('guitar_music') );
		Level.FadeOutSound( Level.FindSound('radio_bar'), 3.0 );		
	else
		Level.StopSound( Level.FindSound('guitar_music') );

		if ( Level.PianoMusic == false ) then
			Level.FadeInSound( Level.FindSound('radio_bar'), 3.0 );			
		end;
	end;
end

----------------------------------------------------------------------------------------------
-- Name: PlayPianoMusic()
-- Desc: 
----------------------------------------------------------------------------------------------
function Level.PlayPianoMusic( onOff )
	Level.PianoMusic = onOff;	
	if ( onOff == true ) then
		Level.PlaySound( Level.FindSound('piano_music') );
		Level.FadeOutSound( Level.FindSound('radio_bar'), 3.0 );
	else
		Level.StopSound( Level.FindSound('piano_music') );

		if ( Level.GuitarMusic == false ) then
			Level.FadeInSound( Level.FindSound('radio_bar'), 3.0 );			
		end;
	end;
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_AIAnchor03()
-- Desc: Kabrera start playing guitar
----------------------------------------------------------------------------------------------
function Level.OnAction_AIAnchor03()
	if ( Level.GuitarAmpOff == true ) then
		AI.SetJob( AI.FindNPC('KABR'), 'amp_on' );
	else
		Level.PlayGuitarMusic(true);

		if ( Level.PianoMusic == true ) then
			Level.PlayPianoMusic(false);
			Level.PlayPianoMusic(true);
		end;

		if ( Level.LetsPlayTogether == true ) then
			local npc = AI.FindNPC('ART2');
			if ( npc != nil and AI.IsUsingAnchor( npc, AI.FindAnchor('AN53') ) == true ) then
				Level.PlayPianoMusic(true);
			end;

			Level.LetsPlayTogether = false;
		end;

	end;
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_StopAIAnchor03()
-- Desc: Kabrera stop playing guitar
----------------------------------------------------------------------------------------------
function Level.OnAction_StopAIAnchor03()
	Level.PlayGuitarMusic(false);	
end

----------------------------------------------------------------------------------------------
-- Name: CheckKabreraPlaying()
-- Desc: 
----------------------------------------------------------------------------------------------
function Level.CheckKabreraPlaying()

	if ( Level.PianoMusic == true ) then
		return;
	end;

	local npc = AI.FindNPC('ART2');
	if ( npc == nil or AI.IsUsingAnchor( npc, AI.FindAnchor('AN53') ) == false ) then
		return;
	end;

	Level.PlayPianoMusic(true);	

	if ( Level.GuitarMusic == true ) then
		Level.PlayGuitarMusic(false);
		Level.PlayGuitarMusic(true);
	end;

end

----------------------------------------------------------------------------------------------
-- Name: OnAction_AIAnchor53()
-- Desc: 
----------------------------------------------------------------------------------------------
function Level.OnAnchor_AIAnchor53()
		
	if ( Level.LetsPlayTogether == true ) then
		AI.Invoke("Level.CheckKabreraPlaying()", 4.0 );		
	else
		Level.PlayPianoMusic(true);	

		if ( Level.GuitarMusic == true ) then
			Level.PlayGuitarMusic(false);
			Level.PlayGuitarMusic(true);
		end;
	end;

	AI.Invoke("AI.SetJob( AI.FindNPC('ART2'), 'smoke' )", 88.0 );
	
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_StopAIAnchor53()
-- Desc: 
----------------------------------------------------------------------------------------------
function Level.OnAnchor_StopAIAnchor53()
	Level.PlayPianoMusic(false);	
end

----------------------------------------------------------------------------------------------
-- Name: OnGuitarAmpOff()
-- Desc:
----------------------------------------------------------------------------------------------
function Level.OnGuitarAmpOff()
	
	Level.GuitarAmpOff = true;

	local npc = AI.FindNPC('KABR');
	if ( npc != nil ) then
		if ( AI.IsUsingAnchor( npc, AI.FindAnchor('AN03') ) == true ) then
			AI.SetJob( npc, 'amp_on' );
		end;
	end;

end

----------------------------------------------------------------------------------------------
-- Name: OnEnter_SimpleTrigger34()
-- Desc: Talk on gas station
----------------------------------------------------------------------------------------------
function Level.OnEnter_SimpleTrigger34()
	local npc = AI.FindNPC('BT05');
	if ( npc == nil ) then
		return;
	end;

	local talkTo = AI.FindNPC('BT06');
	if ( AI.IsDefault(talkTo) == true and AI.IsUsingAnchor( talkTo, AI.FindAnchor('AN91') ) == true ) then
		Level.RunAnchorJob3( npc, 'AN92', 'AN93', 'AN94' , true );
		
		AI.HandleVoice( AI.FindNPC('BT06'), 'script_level05_talk_gas' );

		--Level.SayMessage( AI.FindNPC('BT06'), Level.GetMissionText('MSG1'), 5.0 );
		--AI.Invoke( "Level.SayMessage( AI.FindNPC('BT05'), Level.GetMissionText('MSG2'), 5.0 )", 4.0 );
		
	else
		Level.RunAnchorJob2( npc, 'AN93', 'AN94', true );
	end;
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_SimpleTrigger42()
-- Desc: Leave the mission
----------------------------------------------------------------------------------------------
function Level.OnAction_SimpleTrigger42()         
	Level.OnCompleteMissionTask('LEAV');
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_SimpleTrigger40()
-- Desc: Release cage
----------------------------------------------------------------------------------------------
function Level.OnAction_SimpleTrigger40()
         
   AI.Invoke( "AI.StartDecamouflage(100.0, 120.0, 2.0, true)", 0.5 );            
   Level.StartPlayerCustomAnim( "Custom_OnLight", true, '', false );      

   Level.OrientPlayerPos( -514.8160,157,337.9561, 0.0880, 0, -0.9961, false );      
   Level.PlaySound( Level.FindSound('drop_cage') );

   AI.Invoke( "AI.StopDecamouflage()", 2.5 );
   AI.Invoke( "Level.DropCage()", 0.6 );

end

----------------------------------------------------------------------------------------------
-- Name: OnAction_SimpleTrigger33()
-- Desc: Push guard from balcon
----------------------------------------------------------------------------------------------
function Level.OnAction_SimpleTrigger33()

   Level.ChangePlayerStand( Level.GetPlayer(), 0 );
   
   AI.Invoke( "Actor.RecieveDamage( Level.FindActor('BT04'), 2.0, 0.0, 0.2, 1.0, 6000.0 )", 0.6 );
   AI.Invoke( "AI.StartDecamouflage(100.0, 120.0, 2.0, true)", 0.2 );
            
   Level.StartPlayerCustomAnim( "Takedown_Push_Back", true, '', false );   
   Level.OrientPlayerPos( -289.6733,157,518.9215, 0.0813, 0, -0.9967, false );      
   AI.Invoke( "AI.StopDecamouflage()", 2.5 );

   Level.PlaySound( Level.FindSound('push_BT04') );

end

----------------------------------------------------------------------------------------------
-- Name: PourIntoGuardDrink( notifyID, showItemID )
-- Desc: Pour into guard drink
----------------------------------------------------------------------------------------------
function Level.PourIntoGuardDrink( notifyID, showItemID )

   Level.StartPlayerCustomAnim( "Custom_PourPoison_Table", true, notifyID, true );    
   Level.OrientPlayerPos( -404.8911, 157.2, 368.6575, 0.0, 0.0, 1.0, true );
   
   AI.StartDecamouflage(5.0, 100.0, 6.0, true);
   Level.ShowItemPoison( showItemID );  

end


----------------------------------------------------------------------------------------------
-- Name: OnAction_SimpleTrigger21()
-- Desc: Pour poison into vargas guard drink
----------------------------------------------------------------------------------------------
function Level.OnAction_SimpleTrigger21()
	Level.PourIntoGuardDrink( 'PSVG' , Level.GetPlayerPoisonItemID() );
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_SimpleTrigger20()
-- Desc: Pour soporific into vargas guard drink
----------------------------------------------------------------------------------------------
function Level.OnAction_SimpleTrigger20()
	Level.PourIntoGuardDrink( 'SPVG' , 'SOPO' );
end

----------------------------------------------------------------------------------------------
-- Name: PourIntoCourierDrink( notifyID, showItemID )
-- Desc: Pour into courier drink
----------------------------------------------------------------------------------------------
function Level.PourIntoCourierDrink( notifyID, showItemID )

   Level.StartPlayerCustomAnim( "Custom_PourPoison", true, notifyID, true );    
   Level.OrientPlayerPos( -513.0861, 107.2, 315.1417, -0.1064, 0.0, -0.9943, true );
   
   AI.StartDecamouflage(1.0, 10.0, 6.0, true);
   Level.ShowItemPoison( showItemID );  

end

----------------------------------------------------------------------------------------------
-- Name: OnAction_SimpleTrigger16()
-- Desc: Pour poison into courier drink
----------------------------------------------------------------------------------------------
function Level.OnAction_SimpleTrigger16()
	Level.PourIntoCourierDrink( 'PSNC', Level.GetPlayerPoisonItemID() );
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_SimpleTrigger61()
-- Desc: Pour soporific into courier drink
----------------------------------------------------------------------------------------------
function Level.OnAction_SimpleTrigger61()
	Level.PourIntoCourierDrink( 'CSOP', 'SOPO' );
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_SimpleTrigger18()
-- Desc: Drop body through window
----------------------------------------------------------------------------------------------
function Level.OnAction_SimpleTrigger18()
	
	Level.OrientPlayerPos( -288.1374, 107.0, 483.4343, -0.7041, 0.0, -0.7101, true );

	Level.StartPlayerCustomAnim( "@Stand_Body_PutWindow", false, '', false );
	Actor.StartCustomAnim( Actor.GetPickupedActor( Level.GetPlayer() ), "Stand_BodyBot_PutWindow", 0.3 );
	AI.Invoke( "Actor.DropActor( Level.GetPlayer(), true )", 2.1 );

	Level.PlaySound( Level.FindSound('PutWindow') );
	AI.Invoke( "Level.StopSound( Level.FindSound('PutWindow') )", 3.0 );

end

----------------------------------------------------------------------------------------------
-- Name: OnAction_SimpleTrigger17()
-- Desc: Pour aphrodisiac into courier drink
----------------------------------------------------------------------------------------------
function Level.OnAction_SimpleTrigger17()
	Level.PourIntoCourierDrink( 'VGRC', 'VIGR' );
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_SimpleTrigger15()
-- Desc: Cutscene with Barman
----------------------------------------------------------------------------------------------
function Level.OnAction_SimpleTrigger15()	
	if ( Level.CutsceneBarman == false ) then
		Level.StartCutscene_Barman();	
		Level.BarmanTalk = true;
	end;	
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_SimpleTrigger14()
-- Desc: Hide body in the car
----------------------------------------------------------------------------------------------
function Level.OnAction_SimpleTrigger14()

	Level.OrientPlayerPos( 312.5526, 95.4, 156.5941, 0.0237, 0.0, 0.9997, true );

	Level.StartPlayerCustomAnim( "@Stand_Body_PutImpala", false, '', false );
	Actor.StartCustomAnim( Actor.GetPickupedActor( Level.GetPlayer() ), "Stand_BodyBot_PutImpala", 0.3 );
	AI.Invoke( "Level.EnableWorldObjectAnim( Level.FindWorldObject( 'TRNK' ), true, 0.0, 32.0, 7.5, -1, false )" );

	AI.Invoke( "Actor.DropActor( Level.GetPlayer(), true )", 3.5 );
	AI.Invoke( "Entity.SetHidden( Level.FindActor('VARG'), true )", 3.8 );
		
	AI.Invoke( "Level.OnCompleteMissionTask('VARG')", 3.9 );

end

--------------------------------------------------------
-- Name: Level.StunWithTableBottle()
-- Desc: 
--------------------------------------------------------
function Level.StunWithTableBottle()

	local bottle = Level.FindWorldObject('SBT1');
	Actor.DeattachWorldObjectTag( Level.GetPlayer(), bottle );
	
	local bx, by, bz = Level.GetWorldObjectPos( bottle );
	
	Level.SetWorldObjectRot( bottle, 0.0, 0.0, 0.0 );   
    Level.SetWorldObjectPos( bottle, -436.90323, 161.30759, 472.3847 );

	Level.CreateEffect( 'BGLS', bx, by, bz );

	Actor.StunDamage( Level.FindActor('VARG'), 2.0, 0.4, 0.2, 0.9, 2000.0 );

	local pos = { x = bx, y = by, z = bz };
	AI.AddSound("hit", 50.0, pos);
	
end
	
----------------------------------------------------------------------------------------------
-- Name: OnAction_SimpleTrigger13()
-- Desc: Stun Vargas near safe
----------------------------------------------------------------------------------------------
function Level.OnAction_SimpleTrigger13()

   Level.EnableWorldObjectFlash( Level.FindWorldObject('SBT1'), false );
   Level.ChangePlayerStand( Level.GetPlayer(), 0 );

   Level.SetDOFPostFilter( 1, 20, 40.0, 60.0 );

   if ( AI.IsUsingAnchor( AI.FindNPC('VARG'), AI.FindAnchor('AN16') ) == true ) then			
		Level.OrientPlayerPos( -427.0567, 157,467.5879, 0.0, 0, -1.0, false );      
   else
	    Level.OrientPlayerPos( -424.6781, 157,468.8836, 0.0, 0, -1.0, false );      
   end;

   Level.StartPlayerCustomAnim( "Takedown_StunBottle", true, 'SBT1', false );   
   
   AI.Invoke( "Actor.AttachWorldObjectTag( Level.GetPlayer(), Level.FindWorldObject('SBT1'), 'hgbip_Pistol' )", 1.4117 );
   AI.Invoke( "Level.StunWithTableBottle()", 1.95 );

   AI.Invoke( "AI.StartDecamouflage(100.0, 120.0, 2.0, true)", 0.2 );
   
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_SimpleTrigger12()
-- Desc: Talk to Vargas about package
----------------------------------------------------------------------------------------------
function Level.OnAction_SimpleTrigger12()

	if ( Level.PlayerHasVargasPackage() == false ) then
		Level.SetPlayerMessage( Level.GetPlayer(), Level.GetMissionText( 'NOPK' ) );
		SimpleTrigger12.OnEnterArea( SimpleTrigger12, Entity.GetNode( Level.GetPlayer() ) );
		return;
	end;

	Level.StartCutscene_Vargas();
end

--------------------------------------------------------
-- Name: Level.StunWithLayBottle()
-- Desc: 
--------------------------------------------------------
function Level.StunWithLayBottle()

	local bottle = Level.FindWorldObject('SBT2');
	Actor.DeattachWorldObjectTag( Level.GetPlayer(), bottle );
	
	local bx, by, bz = Level.GetWorldObjectPos( bottle );
	
	Level.SetWorldObjectRot( bottle, 0.0, 0.0, 0.0 );   
    Level.SetWorldObjectPos( bottle, -436.90323, 161.30759, 472.3847 );

	Level.CreateEffect( 'BGLS', bx, by, bz );

	Actor.StunDamage( Level.FindActor('VARG'), 2.0 );

	local pos = { x = bx, y = by, z = bz };
	AI.AddSound("hit", 50.0, pos);
	
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_SimpleTrigger11()
-- Desc: Stun Vargas on bed
----------------------------------------------------------------------------------------------
function Level.OnAction_SimpleTrigger11()
	
	Level.EnableWorldObjectFlash( Level.FindWorldObject('SBT2'), false );
    Level.ChangePlayerStand( Level.GetPlayer(), 0 );

    Level.SetDOFPostFilter( 1, 20, 40.0, 60.0 );
 
	Level.OrientPlayerPos( -417.9500, 157, 474.8114, -1.0, 0, 0.0, false );      
    Level.StartPlayerCustomAnim( "Takedown_StunBottleLay", true, 'SBT2', false );
   
    AI.Invoke( "Actor.AttachWorldObjectTag( Level.GetPlayer(), Level.FindWorldObject('SBT2'), 'hgbip_Pistol' )", 1.14 );
    AI.Invoke( "Level.StunWithLayBottle()", 1.64 );

    AI.Invoke( "AI.StartDecamouflage(100.0, 120.0, 2.0, true)", 0.2 );
	
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_AIAnchor11()
-- Desc: Vargas drink water
----------------------------------------------------------------------------------------------
function Level.OnAction_AIAnchor11()
	if ( Level.VargasSoporific == true ) then
		AI.SetJob( AI.FindNPC('VARG'), 'sleep' );
	elseif ( Level.VargasViagra == true ) then
		Level.VargasViagra = false;
		AI.SetJob( AI.FindNPC('VARG'), 'viagra' );
	end;
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_SimpleTrigger09()
-- Desc: Pour soporific into Vargas drink
----------------------------------------------------------------------------------------------
function Level.OnAction_SimpleTrigger09()

   Level.StartPlayerCustomAnim( "Custom_PourPoison_Table", true, 'VSOP', true );    
   Level.OrientPlayerPos( -420.3266, 157.5, 480.2934, -0.7556, 0.0, -0.6551, true );
   
   AI.StartDecamouflage(15.0, 150.0, 6.0, true);
   Level.ShowItemPoison( 'SOPO' );

end

----------------------------------------------------------------------------------------------
-- Name: OnAction_SimpleTrigger60()
-- Desc: Pour viagra into Vargas drink
----------------------------------------------------------------------------------------------
function Level.OnAction_SimpleTrigger60()

   Level.StartPlayerCustomAnim( "Custom_PourPoison_Table", true, 'VVGR', true );    
   Level.OrientPlayerPos( -420.3266, 157.5, 480.2934, -0.7556, 0.0, -0.6551, true );
   
   AI.StartDecamouflage(15.0, 150.0, 6.0, true);
   Level.ShowItemPoison( 'VIGR' );	

end

----------------------------------------------------------------------------------------------
-- Name: Level.OnAnchor_AIAnchor119()
-- Desc: 
----------------------------------------------------------------------------------------------
function Level.OnAnchor_AIAnchor119()
	AI.SetJob( AI.FindNPC('VARG'), 'idle' );
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_SimpleTrigger03()
-- Desc: Turn amp off
----------------------------------------------------------------------------------------------
function Level.OnAction_SimpleTrigger03()

	Level.StartPlayerCustomAnim( "Custom_GuitarAmpTune_InOut", true, '', false );    
	AI.Invoke( "Level.StartPlayerCustomAnim( 'Custom_GuitarAmpTune', true, '', false, false, 0.001 )", 0.9 );
	AI.Invoke( "Level.StartPlayerCustomAnim( 'Custom_GuitarAmpTune_out', true, 'AMPF', false, true, 0.2 )", 2.0 );
	AI.Invoke( "Level.StopPlayerCustomAnim(false)", 2.8 );

    Level.OrientPlayerPos( -563.1826, 116.15, 260.7913, 0.69, 0.0, -0.7238, true );

	AI.Invoke( "Level.OnGuitarAmpOff()", 1.0 );
   
end

--------------------------------------------------------
-- Name: Level.PlayerFinishSwapCase()
-- Desc: Finish swap cases
--------------------------------------------------------
function Level.PlayerFinishSwapCase()

	local player = Level.GetPlayer();	
	Actor.DeattachItemTag( player, Level.FindItem('SWAP') );

	local handsSuitcase = Actor.FindItem( player, 'EAMP' );		
	Entity.SetHidden( handsSuitcase , false );

	Actor.SwapPickupItem( player, 'RAMP' );
	Level.EnableItemPickup( handsSuitcase, false );

	Level.GuitarAmpDeadly = true;
	AI.Invoke( "Level.OnGuitarAmpOff()", 0.5 );

end

--------------------------------------------------------
-- Name: Level.PlayerHideSwapCase()
-- Desc: 
--------------------------------------------------------
function Level.PlayerHideSwapCase()
	Entity.SetHidden( Actor.FindItem( Level.GetPlayer(), 'EAMP' ), true );
	Entity.SetHidden( Level.FindItem('RAMP'), false );
end

--------------------------------------------------------
-- Name: Level.PlayerStartSwapCase()
-- Desc: 
--------------------------------------------------------
function Level.PlayerStartSwapCase()

    local player        = Level.GetPlayer();
	local benchSuitcase = Level.FindItem( 'RAMP' );

	if ( benchSuitcase == nil ) then
		return;
	end;

	local tempSuitcase = Level.FindItem('SWAP');
	if ( tempSuitcase == nil ) then
		return;
	end;

	Entity.SetHidden( benchSuitcase, true );
	Entity.SetHidden( tempSuitcase, false );

	Actor.AttachItemTag( Level.GetPlayer(), tempSuitcase, 'hgbip_Machinegun' );	
		
end

----------------------------------------------------------------------------------------------
-- Name: OnAction_SimpleTrigger07()
-- Desc: Replace amplifier with bad one
----------------------------------------------------------------------------------------------
function Level.OnAction_SimpleTrigger07()

	if ( Actor.HasItem( Level.GetPlayer(), 'EAMP' ) == false ) then
		return;
	end;

	Actor.AttachShoulderWeaponSpine( Level.GetPlayer(), true );

	Level.StartPlayerCustomAnim( "Action_SwapGuitarAmp", false, 'BAMP', false );    
    Level.OrientPlayerPos( -564.1171, 116.2, 261.7715, 0.6900, 0.0, -0.7238, true );

	AI.Invoke( "Level.PlayerStartSwapCase()", 6.0 / 7.0 );
	AI.Invoke( "Level.PlayerHideSwapCase()", 1.7 );
	AI.Invoke( "Level.PlayerFinishSwapCase()", 2.57 );

	AI.Invoke( "Actor.AttachShoulderWeaponSpine( Level.GetPlayer(), false )", 3.0 );

end

----------------------------------------------------------------------------------------------
-- Name: OnAction_SimpleTrigger02()
-- Desc: Pour poison into Kabrera pizza
----------------------------------------------------------------------------------------------
function Level.OnAction_SimpleTrigger02()

   Level.StartPlayerCustomAnim( "Custom_PourPoison_Table", true, 'PIZA', true );    
   Level.OrientPlayerPos( -651.73, 107.0, 219.8782, -1.0, 0.0, 0.0, true );
   
   AI.StartDecamouflage(15.0, 150.0, 6.0, true);
   --AI.PlayerEnterZone(AI.FindPlayer(), "#poisson3", 'LPCK');
   
   local showItem = Level.GetPlayerPoisonItemID();
   Level.ShowItemPoison( showItem );  

   
end

----------------------------------------------------------------------------------------------
-- Name: CanPoisonCourier()
-- Desc:
----------------------------------------------------------------------------------------------
function Level.CanPoisonCourier()

	local npc = AI.FindNPC('COUR');
	if ( npc != nil ) then
		if ( AI.IsUsingAnchor( npc, AI.FindAnchor('AN21') ) == true or AI.IsUsingAnchor( npc, AI.FindAnchor('AN22') ) == true ) then
			return false;
		end;
	end;

	return true;

end

----------------------------------------------------------------------------------------------
-- Name: OnTestActionTrigger()
-- Desc:
----------------------------------------------------------------------------------------------
function Level.OnTestActionTrigger(actionId, actor)

	if ( actionId == 'PIZA' ) then -- Poison pizza

		if ( Level.PizzaPoisoned == true or Level.PlayerHasPoison() == false ) then
			return false;
		end;

		if ( AI.IsUsingAnchor( AI.FindNPC('KABR'), AI.FindAnchor('AN05') ) == true ) then
			return false;
		end;

		return true;
	elseif ( actionId == 'AMPF' ) then -- Turn amp off

		if ( Level.GuitarAmpOff == true or Level.GuitarAmpDeadly == true ) then
			return false;
		end;

		if ( Actor.HasItem( Level.GetPlayer(), 'EAMP' ) == true ) then
			return false;
		end;

	elseif ( actionId == 'BAMP' ) then -- Replace amplifier

		if ( Level.GuitarAmpDeadly == true ) then
			return false;
		end;

		if ( Actor.HasItem( Level.GetPlayer(), 'EAMP' ) == false ) then
			return false;
		end;

	elseif ( actionId == 'EAMP' ) then -- Deadly amp mini game

		if ( Level.DeadlyAmpReady == true ) then
			return false;
		end;

	elseif ( actionId == 'VSOP' ) then -- Pour soporific into Vargas drink

		if ( Level.VargasSoporific == true ) then
			return false;
		end;
		
		if ( Level.PlayerHasSoporific() == false ) then
			return false;
		end;

		local npc = AI.FindNPC('VARG');
		if ( npc == nil ) then
			return false;
		end;

		if ( AI.IsUsingAnchor( npc, AI.FindAnchor('AN14') ) == true or AI.IsUsingAnchor( npc, AI.FindAnchor('AN16') ) == true ) then
			return false;
		end;

		return true;

	elseif ( actionId == 'VVGR' ) then -- Pour viagra into Vargas drink

		if ( Level.VargasSoporific == true ) then
			return false;
		end;
		
		if ( Level.PlayerHasViagra() == false ) then
			return false;
		end;

		local npc = AI.FindNPC('VARG');
		if ( npc == nil ) then
			return false;
		end;

		if ( AI.IsUsingAnchor( npc, AI.FindAnchor('AN14') ) == true or AI.IsUsingAnchor( npc, AI.FindAnchor('AN16') ) == true ) then
			return false;
		end;

		return true;

	elseif ( actionId == 'STN1' ) then -- Stun Vargas on bed

		if ( Level.VargasOnBed == false ) then
			return false;
		end;

		local npc = AI.FindNPC('VARG');
		if ( npc != nil ) then
			if ( AI.IsUsingAnchor( npc, AI.FindAnchor('AN13') ) == true ) then
				return true;
			end;
		end;

		return false;

	elseif ( actionId == 'VTLK' ) then -- Talk to Vargas about package

		if ( Level.VargasTalk == true ) then
			return false;
		end;
		
		local npc = AI.FindNPC('VARG');
		if ( npc == nil or AI.IsDefault(npc) == false ) then 
			return false;
		end;

		if ( AI.IsUsingAnchor( npc, AI.FindAnchor('AN09') ) == false ) then
			return false;
		end;

		local playerForm = AI.GetPlayerForm( AI.FindPlayer( Level.GetPlayer() ) );
		if ( playerForm != "Courier" ) then
			return false;
		end;

		return true;

	elseif ( actionId == 'VSAF' ) then -- Stun Vargas near safe
		
		local npc = AI.FindNPC('VARG');
		if ( npc == nil ) then 
			return false;
		end;
		
		if ( AI.IsUsingAnchor( npc, AI.FindAnchor('AN16') ) == true or 
			 AI.IsUsingAnchor( npc, AI.FindAnchor('AN11') ) == true or 
			 AI.IsUsingAnchor( npc, AI.FindAnchor('AN14') ) == true or 
			 AI.IsUsingAnchor( npc, AI.FindAnchor('A118') ) == true  ) then

			return true;

		end;
		
		return false;

	elseif ( actionId == 'HIDE' ) then

		if ( Actor.HasPickupedActor( Level.GetPlayer(), 'VARG' ) == false ) then
			return false;
		end;

		return true;

	elseif ( actionId == 'TBAR' ) then -- Talk to barman

		if ( Level.BarmanTalk == true ) then
			return false;
		end;

		local npc = AI.FindNPC('BARM');
		if ( npc == nil or AI.IsDefault( npc ) == false ) then
			return false;
		end;

		if ( AI.IsUsingAnchor( npc, AI.FindAnchor( 'AN17' ) ) == false ) then
			return false;
		end;

		local cour = AI.FindNPC('COUR');
		if ( cour == nil or AI.IsDefault(cour) == false ) then
			return false;
		end;

		if ( Actor.IsNeutralized( Level.FindActor('COUR') ) == true ) then
			return false;
		end;

		return true;

	elseif ( actionId == 'PSNC' ) then -- Pour poison into courier drink

		if ( Level.PlayerHasPoison() == false ) then
			return false;
		end;

		if ( Level.CourierDrink == Level.DRINK_STATE_POISON ) then
			return false;
		end;

		if ( Level.CanPoisonCourier() == false ) then
			return false;
	    end;

		return true;

	elseif ( actionId == 'VGRC' ) then -- Pour aphodisiac into courier drink

		if ( Level.PlayerHasViagra() == false ) then
			return false;
		end;

		if ( Level.CourierDrink != Level.DRINK_STATE_DEFAULT ) then
			return false;
		end;

		if ( Level.CanPoisonCourier() == false ) then
			return false;
	    end;

		return true;

	elseif ( actionId == 'CSOP' ) then -- Pour soporific into courier drink

		if ( Level.PlayerHasSoporific() == false ) then
			return false;
		end;

		if ( Level.CourierDrink != Level.DRINK_STATE_DEFAULT ) then
			return false;
		end;

		if ( Level.CanPoisonCourier() == false ) then
			return false;
	    end;

		return true;

	elseif ( actionId == 'DPBD' ) then -- Body through window

		if ( Actor.HasPickupedActor( Level.GetPlayer() ) == false ) then
			return false;
		end;

		local doorState = Level.GetDoorState( Level.FindDoor('TWND') );
		if ( doorState != 0 ) then
			return false;
		end;

		return true;

	elseif ( actionId == 'SPVG' ) then -- Pour soporific into vargas guard drink

		if ( Level.VarGuardDrink != Level.DRINK_STATE_DEFAULT ) then
			return false;
		end;

		if ( Level.PlayerHasSoporific() == false ) then
			return false;
		end;

		if ( AI.IsUsingAnchor( AI.FindNPC('VGRD'), AI.FindAnchor('AN29') ) == true ) then
			return false;
		end;

		return true;

	elseif ( actionId == 'PSVG' ) then -- Pour poison into vargas guard drink

		if ( Level.VarGuardDrink == Level.DRINK_STATE_POISON ) then
			return false;
		end;

		if ( Level.PlayerHasPoison() == false ) then
			return false;
		end;

		if ( AI.IsUsingAnchor( AI.FindNPC('VGRD'), AI.FindAnchor('AN29') ) == true ) then
			return false;
		end;

		return true;

	elseif ( actionId == 'PHG4' ) then -- Push from balcon guard BikerOut04

		local npc = AI.FindNPC('BT04');
		if ( npc == nil ) then 
			return false;
		end;

		if ( AI.IsUsingAnchor( npc, AI.FindAnchor('AN90') ) == true ) then
			return true;
		end;

		local actor = Level.FindActor('BT04');

		if ( Actor.GetStandType( actor ) != 0 ) then
		   return false;
		end;

		local n = Entity.GetNode( actor );
		local pos = {};
		pos.x, pos.y, pos.z = node.GetPosition( n );
				  
		local dx = pos.x - -288.25665;
		local dy = pos.y - 156.70204;
		local dz = pos.z - 529.76648;

	    local sqrdist = dx * dx + dy * dy + dz * dz;		
		if ( sqrdist < 18.0 ) then
			return true;
		end;

		return false;

	elseif ( actionId == 'CAGE' ) then -- Drop cage

		if ( Level.CagePower == 0 ) then
			return false;
		end;

		return true;

	elseif ( actionId == 'LEAV' ) then -- Leave the place

		if ( Level.HasMissionTask('LEAV') == true and Level.IsMissionTaskCompleted('LEAV') == false ) then
			return true;
		else
			return false;
		end;

	end;

	return true;

end;

----------------------------------------------------------------------------------------------
-- Name: OnFinishPlayerCustomAnim()
-- Desc:
----------------------------------------------------------------------------------------------
function Level.OnFinishPlayerCustomAnim( notifyID, userBreaked )

	local hideItemID = nil;

	if ( notifyID == 'PIZA' ) then -- Pour poison into pizza

		hideItemID = Level.GetPlayerPoisonItemID();
		AI.StopDecamouflage();

		if ( userBreaked == false ) then
			Level.PizzaPoisoned = true;
			Level.PoisonUsed    = true;

			Level.EnableWorldObjectFlash( Level.FindWorldObject('PIZA'), false );
		else
		   SimpleTrigger02.OnEnterArea( SimpleTrigger02, Entity.GetNode( Level.GetPlayer() ) );
	   end;

	elseif ( notifyID == 'VSOP' ) then -- Pour soporific into Vargas drink

		hideItemID = 'SOPO';
		AI.StopDecamouflage();

		if ( userBreaked == false ) then
			Level.VargasSoporific = true;
			Level.UseSoporific = true;
			Level.SetCustomItemDesc( Actor.FindItem( Level.GetPlayer(), 'SOPO' ), 'USED' );
		else
			SimpleTrigger09.OnEnterArea( SimpleTrigger09, Entity.GetNode( Level.GetPlayer() ) );
		end;

	elseif ( notifyID == 'VVGR' ) then -- Pour soporific into Vargas drink

		hideItemID = 'VIGR';
		AI.StopDecamouflage();

		if ( userBreaked == false ) then
			Level.VargasViagra = true;
			Level.ViagraUsed   = true;
		else
			SimpleTrigger60.OnEnterArea( SimpleTrigger60, Entity.GetNode( Level.GetPlayer() ) );
		end;

	elseif ( notifyID == 'PSNC' ) then -- Poison into courier drink

		hideItemID = Level.GetPlayerPoisonItemID();
		AI.StopDecamouflage();

		if ( userBreaked == false ) then
			Level.CourierDrink  = Level.DRINK_STATE_POISON;
			Level.PoisonUsed    = true;
		else
			SimpleTrigger16.OnEnterArea( SimpleTrigger16, Entity.GetNode( Level.GetPlayer() ) );
		end;

	elseif ( notifyID == 'VGRC' ) then -- Viagra into courier drink

		hideItemID = Level.GetPlayerPoisonItemID();
		AI.StopDecamouflage();

		if ( userBreaked == false ) then
			Level.CourierDrink  = Level.DRINK_STATE_VIAGRA;
			Level.ViagraUsed = true;
		else
			SimpleTrigger17.OnEnterArea( SimpleTrigger17, Entity.GetNode( Level.GetPlayer() ) );
		end;

	elseif ( notifyID == 'CSOP' ) then -- Sopoprific into courier drink

		hideItemID = 'SOPO';
		AI.StopDecamouflage();

		if ( userBreaked == false ) then
			Level.CourierDrink  = Level.DRINK_STATE_SOPORIFIC;
			Level.UseSoporific  = true;
			Level.SetCustomItemDesc( Actor.FindItem( Level.GetPlayer(), 'SOPO' ), 'USED' );
		else
			SimpleTrigger61.OnEnterArea( SimpleTrigger61, Entity.GetNode( Level.GetPlayer() ) );
		end;

	elseif ( notifyID == 'SPVG' ) then -- Soporific into vargas guard drink

		hideItemID = 'SOPO';
		AI.StopDecamouflage();

		if ( userBreaked == false ) then
			Level.VarGuardDrink = Level.DRINK_STATE_SOPORIFIC;
			Level.UseSoporific = true;
			Level.SetCustomItemDesc( Actor.FindItem( Level.GetPlayer(), 'SOPO' ), 'USED' );
		else
			SimpleTrigger20.OnEnterArea( SimpleTrigger20, Entity.GetNode( Level.GetPlayer() ) );
		end;

	elseif ( notifyID == 'PSVG' ) then -- Poison into vargas guard drink
		
		hideItemID = Level.GetPlayerPoisonItemID();
		AI.StopDecamouflage();

		if ( userBreaked == false ) then
			Level.VarGuardDrink = Level.DRINK_STATE_POISON;
			Level.PoisonUsed = true;
		else
			SimpleTrigger21.OnEnterArea( SimpleTrigger21, Entity.GetNode( Level.GetPlayer() ) );
		end;

	elseif ( notifyID == 'BAMP' ) then -- Replace amplifier

		
	elseif ( notifyID == 'SBT1' or notifyID == 'SBT2' ) then -- Stun Vargas with bottle near table

		Level.SetDOFPostFilter( 0, 0, 0, 0, 0 );
		AI.StopDecamouflage();

	end;

	-- Hide item

	if ( hideItemID != nil ) then
		Level.HideItemInHands( hideItemID, Level.ItemInHands[ hideItemID ] );
		Level.ItemInHands[ hideItemID ] = Level.ItemInHands[ hideItemID ] + 1;
	end;

end

--------------------------------------------------------
-- Name: Level.OnPickupItemCheck()
-- Desc: 
--------------------------------------------------------
function Level.OnPickupItemCheck( actorFourCC, itemFourCC, actor )

	if ( itemFourCC == 'EAMP' ) then

		if ( Level.DeadlyAmpReady == false ) then
			return false;
		end;

	end;

	return true;

end

--------------------------------------------------------
-- Name: Level.OnNotifyHitBulletObject()
-- Desc: 
--------------------------------------------------------
function Level.OnNotifyHitBulletObject( actorId, objectId, surfaceName, hitX, hitY, hitZ )

	if ( objectId == 'CAG1' ) then
		if ( Level.CagePower == 0 ) then
			return;
		end;

		Level.CagePower = Level.CagePower - 1;
		
		if ( Level.CagePower == 0 ) then
			Level.DropCage();
		end;
	end;
	
end

--------------------------------------------------------
-- Name: Level.OnNotifyPickupItem()
-- Desc: 
--------------------------------------------------------
function Level.OnNotifyPickupItem( fourCC, entity, actor )
	if ( fourCC == 'OUTS' ) then			
		Level.TualetOutOfOrder = false;
	end;
end

--------------------------------------------------------
-- Name: Level.OnNotifyDropItem()
-- Desc: 
--------------------------------------------------------
function Level.OnNotifyDropItem( fourCC, entity, actor )

	local actorID = Actor.GetUniqueID( actor );

end

----------------------------------------------------------------------------------------------
-- Name: OnStopMove()
-- Desc:
----------------------------------------------------------------------------------------------
function Level.OnStopMove( npcId, npc, player, zoneName )

	if ( zoneName == 'near_artist' ) then
		Level.SayMessage(npc, Level.GetMissionText('STP4'), 5.0 );		
        AI.HandleVoice(npc, "script_level05_stop_artists");
	elseif ( zoneName == 'club_entering' ) then
		Level.SayMessage(npc, Level.GetMissionText('STP2'), 5.0 );
		AI.HandleVoice( npc, 'script_level05_club' );
	elseif ( zoneName == 'near_vargas' ) then
		Level.SayMessage(npc, Level.GetMissionText('STP3'), 5.0 );
		AI.HandleVoice( npc, 'script_level05_busy' );	
	elseif ( zoneName == 'vargas_office' or zoneName == 'vargas_courier' or zoneName == 'artist_area' or zoneName == 'reporter_area' ) then
		AI.HandleVoice( npc, 'male_usa_stopmove_get_out2' );
	elseif ( zoneName == 'kitchen' ) then
		AI.HandleVoice( npc, 'male_usa_stopmove_kitchen' );
	elseif ( zoneName != "#lockpick" and zoneName != "#body" ) then
		AI.HandleVoice( npc, 2 );
	end;
end

--------------------------------------------------------
-- Name: Level.OnFinishElectroMiniGame()
-- Desc: 
--------------------------------------------------------
function Level.OnFinishElectroMiniGame( gameId, completed, breaked )

	if ( gameId == 'EAMP' and completed == true ) then
		Level.DeadlyAmpReady = true;
		Level.EnableEntityFlash( Level.FindItem('EAMP'), false );
	end;

end

--------------------------------------------------------
-- Name: Level.OnLightSwitchTrigger()
-- Desc: 
--------------------------------------------------------
function Level.OnLightSwitchTrigger( brushId, state )

	--if (state == false) and (brushId == 'HL34') then
	--	local npc = AI.FindNPC('SC06');
	--	if AI.IsDefault(npc) then
	--		Level.RunTurnLightAnchor(npc, brushId );
	--	end
	--end

end

--------------------------------------------------------
-- Name: Level.OnOpenDoor()
-- Desc: Open door notification
--------------------------------------------------------
function Level.OnOpenDoor( doorId )
		
	if ( doorId == 'TWND' ) then	    
		Level.EnableGeomHelper( 'WIN1' , true );   
		Level.EnableGeomHelper( 'WIN2' , true );		
	end;

end;

--------------------------------------------------------
-- Name: Level.OnCloseDoor()
-- Desc: Close door notification
--------------------------------------------------------
function Level.OnCloseDoor( doorId )

	if ( doorId == 'TWND' ) then
		Level.EnableGeomHelper( 'WIN1' , false );   
		Level.EnableGeomHelper( 'WIN2' , false );		
	end

end

--------------------------------------------------------
-- Name: Level.OnTestAnchor()
-- Desc: Testing anchor conditions
--------------------------------------------------------
function Level.OnTestAnchor( anchorID )

	if ( anchorID == 'CWOM' ) then		
		local npc = AI.FindNPC('WOM4');
		if ( npc != nil and AI.IsUsingAnchor(npc, AI.FindAnchor('AN74') ) == true ) then
			AI.Invoke( "Level.RunAnchorJob2( AI.FindNPC('WOM4'), 'AN77', 'AN78', true )", 8.0 );
			return true;
		else
			return false;
		end;
	end;

	return true;

end

--------------------------------------------------------
-- Name: Level.SafeDoorCheck()
-- Desc:
--------------------------------------------------------
function Level.SafeDoorCheck()
	
	local npc = AI.FindNPC('VARG');
	if ( npc == nil or AI.IsUsingAnchor( npc, AI.FindAnchor('AN16') ) == false ) then 
		Level.EnableWorldObjectAnim( Level.FindWorldObject( 'BSAF' ), false );		
	else
		AI.Invoke( "Level.SafeDoorCheck()", 0.1 );
	end;

end

--------------------------------------------------------
-- Name: Level.OnAnchor_AIAnchor16()
-- Desc: Vargas opening safe
--------------------------------------------------------
function Level.OnAnchor_AIAnchor16()
	AI.Invoke( "Level.EnableWorldObjectAnim( Level.FindWorldObject( 'BSAF' ), true, 2.0, 74.0, 6.0, -1, false )" );
	AI.Invoke( "Level.SafeDoorCheck()", 0.1 );
end

--------------------------------------------------------
-- Name: Level.OnEnterTrigger_SimpleTrigger57()
-- Desc: 
--------------------------------------------------------
function Level.OnEnterTrigger_SimpleTrigger57()

	if ( Actor.HasPickupedActor( Level.GetPlayer(), 'VARG' ) == false ) then
		return;
	end;

	if ( Level.IsMissionTaskCompleted('VARG') == true ) then
		return;
	end;

	Level.EnableWorldObjectFlash( Level.FindWorldObject('TRNK'), true );

end

--------------------------------------------------------
-- Name: Level.DeattachBarBottle()
-- Desc: 
--------------------------------------------------------
function Level.DeattachBarBottle( actorName )
	local bottle = Level.FindWorldObject('BBTL');
	Actor.DeattachWorldObjectTag( Level.FindActor( actorName ), bottle );

	Level.SetWorldObjectRot( bottle, 0.0, 0.0, 0.0 );   
    Level.SetWorldObjectPos( bottle, -514.63123, 116.35447, 322.28827 );
end

--------------------------------------------------------
-- Name: Level.OnSetupAnchor_AIAnchor23()
-- Desc: 
--------------------------------------------------------
function Level.OnSetupAnchor_AIAnchor23()
	AI.Invoke( "Actor.AttachWorldObjectTag( Level.FindActor('BARM'), Level.FindWorldObject('BBTL'), 'hgbip_Pistol' )", 2.25 );
	AI.Invoke( "Level.DeattachBarBottle('BARM')", 6.6 );
end

--------------------------------------------------------
-- Name: Level.OnAnchor_AIAnchor112()
-- Desc: Kabrera smoking
--------------------------------------------------------
function Level.OnAnchor_AIAnchor112()

	local pianist = AI.FindNPC('ART2');

	if ( pianist != nil and AI.IsUsingAnchor(pianist, AI.FindAnchor('A111') ) == true ) then
		AI.SetJob( pianist, 'play' );		
		Level.LetsPlayTogether = true;	
	end;

	AI.Invoke( "AI.SetJob( AI.FindNPC('KABR'), 'default' )", 9.0 );

end

--------------------------------------------------------
-- Name: Level.OnAnchor_AIAnchor111()
-- Desc: Pianist smoking anchor notification
--------------------------------------------------------
function Level.OnAnchor_AIAnchor111()
	local kabrera = AI.FindNPC('KABR');
	if ( kabrera == nil or Actor.IsNeutralized( Level.FindActor('KABR') ) == true ) then
		AI.SetJob( AI.FindNPC('ART2'), 'play' );
	end;
end

--------------------------------------------------------
-- Name: Level.OnAnchor_AIAnchor113()
-- Desc: Courier check touilet door
--------------------------------------------------------
function Level.OnAnchor_AIAnchor113()
	if ( Level.TualetOutOfOrder == true ) then
		AI.SetJob( AI.FindNPC('COUR'), 'piss' );
	end;
end

--------------------------------------------------------
-- Name: Level.OnAnchor_AIAnchor116()
-- Desc: 
--------------------------------------------------------
function Level.OnAnchor_AIAnchor116()
	AI.SetJob( AI.FindNPC('COUR'), 'default' );	
end

--------------------------------------------------------
-- Name: Level.OnPlacePlateDoor()
-- Desc: 
--------------------------------------------------------
function Level.OnPlacePlateDoor( doorId )
	if ( doorId == 'LD03' ) then
		Level.TualetOutOfOrder = true;
	end;
end

--------------------------------------------------------
-- Name: Level.OnEnterTrigger_SimpleTrigger62()
-- Desc: 
--------------------------------------------------------
function Level.OnEnterTrigger_SimpleTrigger62()
	
	if ( Level.IsMissionTaskCompleted( 'FREE' ) == true ) then
		return;
	end;

	if ( Level.CutscenePhoto == true ) then
		return;
	end;

	Level.StartCutscene_Photo();
end

--------------------------------------------------------
-- Name: Level.InitCutscene_Photo()
-- Desc: 
--------------------------------------------------------
function Level.InitCutscene_Photo()

   local ns = Level.FindCutScene('photo');
   if ( ns != nil ) then
	  return;
   end;

   ns = Level.NewCutScene('photo', 110, 614.0 );

   Level.AddCinematicCamera('Models\\CutScenes\\Bikers_Photo\\Camera_01.scm', 2, 8.0, 10.0, 80.0, 1.0, 'PH01' );
   Level.AddCinematicCamera('Models\\CutScenes\\Bikers_Photo\\Camera_02.scm', 2, 8.0, 10.0, 80.0, 1.0, 'PH02' );
   Level.AddCinematicCamera('Models\\CutScenes\\Bikers_Photo\\Camera_03.scm', 2, 8.0, 10.0, 50.0, 1.0, 'PH03' );
   Level.AddCinematicCamera('Models\\CutScenes\\Bikers_Photo\\Camera_04.scm', 2, 8.0, 10.0, 80.0, 1.0, 'PH04' );
   Level.AddCinematicCamera('Models\\CutScenes\\Bikers_Photo\\Camera_05.scm', 2, 8.0, 20.0, 50.0, 1.0, 'PH05' );
   Level.AddCinematicCamera('Models\\CutScenes\\Bikers_Photo\\Camera_06.scm', 2, 8.0, 30.0, 80.0, 1.0, 'PH06' );
  
   CutScene.SetCameraParam( ns, '#PH01', 'fov', 45.0 );
   CutScene.SetCameraParam( ns, '#PH02', 'fov', 30.0 );
   CutScene.SetCameraParam( ns, '#PH03', 'fov', 32.0 );
   CutScene.SetCameraParam( ns, '#PH04', 'fov', 32.0 );
   CutScene.SetCameraParam( ns, '#PH05', 'fov', 25.0 );
   CutScene.SetCameraParam( ns, '#PH06', 'fov', 22.0 );

   CutScene.AddAnimatedActor( ns, 'STRG', 110 , 614 , 'Models\\CutScenes\\Bikers_Photo\\SemyonAnim.skl' );

   CutScene.AddEvent( ns, 'change_camera' , 150.0, 'PH01' );
   CutScene.AddEvent( ns, 'change_camera' , 235.0, 'PH02' );
   CutScene.AddEvent( ns, 'change_camera' , 338.5, 'PH03' );
   CutScene.AddEvent( ns, 'change_camera' , 380.0, 'PH04' );
   CutScene.AddEvent( ns, 'change_camera' , 430.0, 'PH05' );
   CutScene.AddEvent( ns, 'change_camera' , 530.0, 'PH06' );

   CutScene.AddAnimatedObject( ns, 'C16P', false );
   CutScene.SetCamera( ns, '#PH06' );
   
end

--------------------------------------------------------
-- Name: Level.StartCutscene_Photo()
-- Desc: 
--------------------------------------------------------
function Level.StartCutscene_Photo()

   local ns = Level.FindCutScene('photo');
   if ( ns == nil ) then
	   return;
   end;

   if ( Actor.IsNeutralized( Level.GetPlayer() ) == true ) then
	   return;
   end;

   Level.CutscenePhotoSkip = false;
   AI.Invoke( "Level.CutscenePhotoSkip=true", 8.0 );

   Level.CutsceneMusicMood = Level.GetMusic();
   Level.SetMusic( Level.MUSIC_MOOD_NONE, 1.0 );	

   Level.Enable( "lockmusic", true );
   Level.Enable( "ai", false );

   AI.Invoke( "Level.SetSoundVolume( Level.FindSound('generator') , 0.1 )", 0.01 );
   CutScene.SetAudio( ns, "Models\\CutScenes\\Bikers_Photo\\DTS3_CS_16.ogg", true, false );

   Level.ChangePlayerStand( Level.GetPlayer(), 0 );
   Level.EnablePlayerCutsceneMode(true);
   Level.StartPlayerCustomAnim( "Stand_Idle_1", false, '', false );      
   
   CutScene.SetFrame( ns, 110.0 );   
   CutScene.Play( ns, 15.0 );

   System:SetVar("cl_player_clothes", false );
   System:SetVar("r_frame_backlog", false );

   Level.OrientPlayer( -592.349, 106.804, 391.176, 0.0 );   
   Level.SetHudFadeIn(2.0);

   Level.HideAllActors( true, true, false );

   if ( CutScene.Activate( ns , true ) == false ) then
	   Level.FinishCutscene_Photo( ns );
   end;
  
end;

--------------------------------------------------------
-- Name: Level.FinishCutscene_Photo()
-- Desc: 
--------------------------------------------------------
function Level.FinishCutscene_Photo( cs )

	CutScene.StopAudio(cs);

	Level.StopSound( Level.FindSound('generator') );	
	Level.FadeInSound( Level.FindSound('generator'), 1.0 );
	AI.Invoke( "Level.SetSoundVolume( Level.FindSound('generator') , 0.3 )", 0.1 );

	System:SetVar("cl_player_clothes", true );	 
	System:SetVar("r_frame_backlog", true );

	Level.EnablePlayerCutsceneMode(false);
	Level.OrientPlayer( -589.31683, 107.0, 394.38641, 180.0 );   	
	Level.SetPlayerCameraAngles( 340, 10 );

	Level.SetWorldObjectAnimFrame( Level.FindWorldObject('C16P'), 614 );
	Level.SetWorldObjectPos( Level.FindWorldObject('C16P'), 18.70465, 3.62573, 7.29639 );

	Level.SetHudFadeIn(1.0);

	Level.Enable( "lockmusic", false );
	Level.Enable( "ai", true );

	Level.SetMusic( Level.CutsceneMusicMood, 2.0 );	
	Level.HideAllActors( false, false, false );

	Level.CutscenePhoto = true;
	AI.Invoke( "Level.OnCompleteMissionTask('FREE')", 1.0 );

end

--------------------------------------------------------
-- Name: Level.InitCutscene_Vargas()
-- Desc: 
--------------------------------------------------------
function Level.InitCutscene_Vargas()

   local ns = Level.FindCutScene('vargas');
   if ( ns != nil ) then
	  return;
   end;

   ns = Level.NewCutScene('vargas', 0, 864.0 );

   Level.AddCinematicCamera('Models\\CutScenes\\Bikers_Vargas\\Camera_01.scm', 2, 8.0, 10.0, 80.0, 1.0, 'VG01' );
   Level.AddCinematicCamera('Models\\CutScenes\\Bikers_Vargas\\Camera_02.scm', 2, 8.0, 10.0, 80.0, 1.0, 'VG02' );
   Level.AddCinematicCamera('Models\\CutScenes\\Bikers_Vargas\\Camera_03.scm', 2, 15.0, 10.0, 50.0, 1.0, 'VG03' );
   Level.AddCinematicCamera('Models\\CutScenes\\Bikers_Vargas\\Camera_04.scm', 2, 15.0, 10.0, 50.0, 1.0, 'VG04' );
  
   CutScene.SetCameraParam( ns, '#VG04', 'fov', 20.0 );
   CutScene.SetCameraParam( ns, '#VG01', 'fov', 13.0 );
   CutScene.SetCameraParam( ns, '#VG02', 'fov', 25.0 );
   CutScene.SetCameraParam( ns, '#VG03', 'fov', 30.0 );

   CutScene.LoadSubTitles( ns, "Models\\CutScenes\\Bikers_Vargas\\subtitles.shadvs" );
   
   CutScene.AddAnimatedActor( ns, 'STRG', 0 , 864 , 'Models\\CutScenes\\Bikers_Vargas\\Semyon.skl' );

   CutScene.AddAnimatedObject( ns, 'CVAG', false );
   CutScene.AddAnimatedObject( ns, 'CVPK', false );
   CutScene.AddAnimatedObject( ns, 'CVPN', false );
   CutScene.AddAnimatedObject( ns, 'CVBX', false );

   CutScene.AddEvent( ns, 'change_camera' , 120.0, 'VG01' );
   CutScene.AddEvent( ns, 'change_camera' , 214.0, 'VG02' );
   CutScene.AddEvent( ns, 'change_camera' , 400.0, 'VG03' );
   
   CutScene.SetCamera( ns, '#VG04' );
   
end

--------------------------------------------------------
-- Name: Level.StartCutscene_Vargas()
-- Desc: 
--------------------------------------------------------
function Level.StartCutscene_Vargas()

   local ns = Level.FindCutScene('vargas');
   if ( ns == nil ) then
	   return;
   end;

   if ( Actor.IsNeutralized( Level.GetPlayer() ) == true ) then
	   return;
   end;

   Level.CutsceneVargasSkip = false;
   AI.Invoke( "Level.CutsceneVargasSkip=true", 15.0 );

   Level.CutsceneMusicMood = Level.GetMusic();
   Level.SetMusic( Level.MUSIC_MOOD_NONE, 1.0 );	

   Level.Enable( "lockmusic", true );
   Level.Enable( "ai", false );
   
   CutScene.SetAudio( ns, "Models\\CutScenes\\Bikers_Vargas\\Audio.ogg", true, false );
   Level.StopSound( Level.FindSound('radio01') );

   Level.ChangePlayerStand( Level.GetPlayer(), 0 );
   Level.EnablePlayerCutsceneMode(true);
   Level.StartPlayerCustomAnim( "Stand_Idle_1", false, '', false );      
   
   CutScene.SetFrame( ns, 0.0 );   
   CutScene.Play( ns, 30.0 );
   
   System:SetVar("r_frame_backlog", false );

   Level.OrientPlayer( -445.092, 156.78, 462.521, 180.0 );   
   Level.SetHudFadeIn(2.0);

   Level.SetWorldObjectPos( Level.FindWorldObject('CVAG'), -444.13699, 156.78, 480.83301 );
   Level.SetWorldObjectPos( Level.FindWorldObject('CVPN'), 0, 0, 0 );
   Level.SetWorldObjectPos( Level.FindWorldObject('CVBX'), 0, 0, 0 );

   Level.HideObject( 'CVKR' );

   AI.Invoke( "Level.SetWorldObjectPos( Level.FindWorldObject('CVPK'), 0, 0, 0 )", 10.0 );

   Level.HideAllActors( true, true, false );
   Level.EnableLight( 'CVG1', true );

   if ( CutScene.Activate( ns , true ) == false ) then
	   Level.FinishCutscene_Vargas( ns );
   end;
  
end;

--------------------------------------------------------
-- Name: Level.FinishCutscene_Vargas()
-- Desc: 
--------------------------------------------------------
function Level.FinishCutscene_Vargas( cs )

	CutScene.StopAudio(cs);

	Level.FadeInSound( Level.FindSound('radio01'), 2.0 );
	
	System:SetVar("r_frame_backlog", true );

	Level.EnablePlayerCutsceneMode(false);
	Level.SetPlayerCameraAngles( 200, 10 );
	
	Level.SetWorldObjectPos( Level.FindWorldObject('CVAG'), -462.99307, 52.46571, 232.16702 );
	Level.SetWorldObjectPos( Level.FindWorldObject('CVPK'), -29.61377, -106.77597, -240.75531 );
	Level.SetWorldObjectPos( Level.FindWorldObject('CVPN'), -33.40002, -104.30816, -251.29634 );
	Level.SetWorldObjectPos( Level.FindWorldObject('CVBX'), -21.50116, -102.75497, -255.6203 );

	Level.ShowObject( 'CVKR' );

	Level.SetHudFadeIn(1.0);

	Level.Enable( "lockmusic", false );
	Level.Enable( "ai", true );

	Level.SetMusic( Level.CutsceneMusicMood, 2.0 );	
	Level.HideAllActors( false, false, false );

	Level.EnableLight( 'CVG1', false );

	Level.CutsceneVargas = true;
	Level.VargasTalk     = true;
	
	if ( Level.GetDifficulty() < Level.LD_HARD ) then
		Level.EnableWorldObjectFlash( Level.FindWorldObject('SBT1'), true );
	end;

	AI.Invoke( "Level.EnableWorldObjectFlash( Level.FindWorldObject('SBT1'), false )", 15.0 );

	NPC.DoCustomAnimation( AI.FindNPC('VARG'), "Custom_GetUp_Table");	
	AI.Invoke( "Level.RunAnchorJob( AI.FindNPC('VARG'), 'AN16' , true )", 1.8 );
	AI.Invoke( "AI.EnableZone( 'vargas_courier', true )", 30.0 );

	Actor.RemoveInventory( Level.GetPlayer(), Actor.FindItem( Level.GetPlayer(), 'PCKG' ) );
	
end

--------------------------------------------------------
-- Name: Level.InitCutscene_Barman()
-- Desc: 
--------------------------------------------------------
function Level.InitCutscene_Barman()

   local ns = Level.FindCutScene('barman');
   if ( ns != nil ) then
	  return;
   end;

   ns = Level.NewCutScene('barman', 0, 1795.0 );

   Level.AddCinematicCamera('Models\\CutScenes\\Bikers_Barman\\Camera_01.scm', 2, 30.0, 5.0, 50.0, 1.0, 'BM01' );
   Level.AddCinematicCamera('Models\\CutScenes\\Bikers_Barman\\Camera_02.scm', 2, 8.0, 10.0, 80.0, 1.0, 'BM02' );
   Level.AddCinematicCamera('Models\\CutScenes\\Bikers_Barman\\Camera_03.scm', 2, 8.0, 10.0, 50.0, 1.0, 'BM03' );
   Level.AddCinematicCamera('Models\\CutScenes\\Bikers_Barman\\Camera_04.scm', 2, 8.0, 10.0, 80.0, 1.0, 'BM04' );
   Level.AddCinematicCamera('Models\\CutScenes\\Bikers_Barman\\Camera_05.scm', 2, 8.0, 10.0, 60.0, 1.0, 'BM05' );
      
   CutScene.SetCameraParam( ns, '#BM01', 'fov', 20.0 );
   CutScene.SetCameraParam( ns, '#BM02', 'fov', 23.0 );
   CutScene.SetCameraParam( ns, '#BM03', 'fov', 23.0 );
   CutScene.SetCameraParam( ns, '#BM04', 'fov', 30.0 );
   CutScene.SetCameraParam( ns, '#BM05', 'fov', 28.0 );
   
   CutScene.LoadSubTitles( ns, "Models\\CutScenes\\Bikers_Barman\\subtitles.shadvs" );
   
   CutScene.AddAnimatedActor( ns, 'STRG', 0 , 1800, 'Models\\CutScenes\\Bikers_Barman\\Semyon.skl' );

   CutScene.AddAnimatedObject( ns, 'CBRM', false );
   CutScene.AddAnimatedObject( ns, 'CBC1', false );
   CutScene.AddAnimatedObject( ns, 'CBC2', false );
   CutScene.AddAnimatedObject( ns, 'CBC5', false );
   CutScene.AddAnimatedObject( ns, 'CBCR', false );
   CutScene.AddAnimatedObject( ns, 'CBOT', false );

   CutScene.AddNotify( ns, 0, 500.0 );
   CutScene.AddNotify( ns, 1, 950.0 );
   CutScene.AddNotify( ns, 2, 1720.0 );
   CutScene.AddNotify( ns, 3, 204.0 );
         
   CutScene.AddEvent( ns, 'change_camera' , 65.0, 'BM02' );
   --CutScene.AddEvent( ns, 'change_camera' , 204.0, 'BM03' );
   CutScene.AddEvent( ns, 'change_camera' , 853.0, 'BM04' );
   CutScene.AddEvent( ns, 'change_camera' , 1000.0, 'BM05' );
   CutScene.AddEvent( ns, 'change_camera' , 1520.0, 'BM04' );
      
   CutScene.SetCamera( ns, '#BM01' );
   
end

--------------------------------------------------------
-- Name: Level.RunAnimIfDefault()
-- Desc: 
--------------------------------------------------------
function Level.RunAnimIfDefault( actorId, isDefault, animName )
	if ( isDefault == true ) then
		local actor = Level.FindActor( actorId );
		if ( actor != nil ) then
			Entity.SetHidden( actor, false );

			if ( animName != nil ) then
				local callback = "Actor.StartCustomAnim( Level.FindActor( '" .. actorId .. "') , '" .. animName .. "' , 0.3)";
				AI.Invoke( callback, 2.0 );
			end;
		end;
	end;
end

--------------------------------------------------------
-- Name: Level.CutsceneBarman_Teleport()
-- Desc: 
--------------------------------------------------------
function Level.CutsceneBarman_Teleport( cutsceneOn )
   local n = Entity.GetNode( Level.FindActor('HM02') );

   if ( cutsceneOn == true ) then
	    AI.DisableActorControl( Level.FindActor('HM02'), true );
		node.SetPosition( n, -502.84686, 106.82605, 186.97935 );
   else
	   AI.DisableActorControl( Level.FindActor('HM02'), false );
	   node.SetPosition( n, -347.64462, 156.61372, 175.64108 );
	   Actor.StopCustomAnim( Level.FindActor('HM02') );
   end;

   node.InvalidateTransforms( n , true );
end

--------------------------------------------------------
-- Name: Level.StartCutscene_Barman()
-- Desc: 
--------------------------------------------------------
function Level.StartCutscene_Barman()

   local ns = Level.FindCutScene('barman');
   if ( ns == nil ) then
	   return;
   end;

   if ( Actor.IsNeutralized( Level.GetPlayer() ) == true ) then
	   return;
   end;

   Level.CutsceneBarmanSkip = false;
   AI.Invoke( "Level.CutsceneBarmanSkip=true", 13.0 );

   Level.CutsceneMusicMood = Level.GetMusic();
   Level.SetMusic( Level.MUSIC_MOOD_NONE, 1.0 );	

   Level.Enable( "lockmusic", true );
   Level.Enable( "ai", false );

   local isDefaultGR20 = AI.IsDefault( AI.FindNPC('GR20') );
   local isDefaultGD11 = AI.IsDefault( AI.FindNPC('GD11') );
   local isDefaultGD12 = AI.IsDefault( AI.FindNPC('GD12') );
   local isDefaultGD16 = AI.IsDefault( AI.FindNPC('GD16') );
   local isDefaultHM01 = AI.IsDefault( AI.FindNPC('HM01') );
   Level.isDefaultHM02 = AI.IsDefault( AI.FindNPC('HM02') );
   
   CutScene.SetAudio( ns, "Models\\CutScenes\\Bikers_Barman\\Audio.ogg", true, false );
   
   Level.ChangePlayerStand( Level.GetPlayer(), 0 );
   Level.EnablePlayerCutsceneMode(true);

   Level.StartPlayerCustomAnim( "Stand_Idle_1", false, '', false );      
   
   CutScene.SetFrame( ns, 0.0 );   
   CutScene.Play( ns, 30.0 );

   System:SetVar("cl_player_clothes", false );
   System:SetVar("r_frame_backlog", false );

   Level.OrientPlayer( -484.14484, 107.41843, 312.00946, 180.0 );
   AI.Invoke( "Level.OrientPlayer( -484.14484, 107.41843, 312.00946, 180.0 )", 2.0 );

   Level.SetHudFadeIn(2.0);
   Level.HideAllActors( true, false, false );

   Level.RunAnimIfDefault( 'GR20', isDefaultGR20, 'Custom_Smoke_Relax' );
   Level.RunAnimIfDefault( 'GD11', isDefaultGD11, 'Custom_Sit_Table_Smoke' );
   Level.RunAnimIfDefault( 'GD12', isDefaultGD12, 'Custom_Billyard_Clean' );
   Level.RunAnimIfDefault( 'GD16', isDefaultGD16, 'Custom_Billyard_Shoot' );
   Level.RunAnimIfDefault( 'HM01', isDefaultHM01, 'Custom_GoDance' );
   Level.RunAnimIfDefault( 'HM02', Level.isDefaultHM02, 'Custom_GoDance' );

   if ( Level.isDefaultHM02 != false ) then
	 AI.Invoke( "Level.CutsceneBarman_Teleport(true)", 2.0 );
   end;
         
   Level.StopSound( Level.FindSound('radio_bar') );
   Level.StopSound( Level.FindSound('guitar_music') );
   Level.StopSound( Level.FindSound('piano_music') );

   Level.SetWorldObjectPos( Level.FindWorldObject('BARS'), -496.70886, 116.87187, 321.89355 );

   Level.SetWorldObjectState( Level.FindWorldObject('BARS'), 'freeze', true );
   AI.Invoke( "Level.SetWorldObjectState( Level.FindWorldObject('BARS'), 'freeze', false )", 10.0 );

   AI.Invoke( "Level.SetWorldObjectPos( Level.FindWorldObject('CBC2'), 0, 0, 0 )", 4.0 );
   Level.SetWorldObjectPos( Level.FindWorldObject('CBC5'), 0, 0, 0 );

   Level.SetWorldObjectPos( Level.FindWorldObject('CBRM'), -498.25082, 109.06143, 330.40546 );
   Level.SetWorldObjectPos( Level.FindWorldObject('CBOT'), -498.25082, 109.06143, 330.40546 );
   Level.SetWorldObjectPos( Level.FindWorldObject('CBC1'), -498.25082, 109.06143, 330.40546 );
   Level.SetWorldObjectPos( Level.FindWorldObject('CSTK'), -513.06702, 118.56664, 320.82001 );

   Level.EnableLight( 'CBE1', false );
   --Level.EnableLight( 'CBL1', false );
   --Level.EnableLight( 'CBL2', false );
     
   if ( CutScene.Activate( ns , true ) == false ) then
	   Level.FinishCutscene_Barman( ns );
   end;
     
end;

--------------------------------------------------------
-- Name: Level.OnCutSceneNotify()
-- Desc: 
--------------------------------------------------------
function Level.OnCutSceneNotify( cutscene, notifyId, frame )

	if ( notifyId == 0 ) then
		Level.SetWorldObjectPos( Level.FindWorldObject('CBCR'), -504.12982, 107.41843, 318.03146 );		
	elseif ( notifyId == 1 ) then
		Level.PlaySound( Level.FindSound('cutscene_drums') );
		AI.Invoke( "Level.FadeOutSound( Level.FindSound('cutscene_drums'), 1.0 )", 0.5 );
	elseif ( notifyId == 2 ) then
		Level.SetHudFadeOut(3.0);
	elseif ( notifyId == 3 ) then
		CutScene.SetCamera( cutscene, '#BM03' );
		AI.Invoke( "Level.EnableLight( 'CBE1', true )" );
	end;

end

--------------------------------------------------------
-- Name: Level.FinishCutscene_Barman()
-- Desc: 
--------------------------------------------------------
function Level.FinishCutscene_Barman( cs )

	CutScene.StopAudio(cs);

	if ( Level.GuitarMusic == true ) then
		Level.PlayGuitarMusic(true);		
	end;

	if ( Level.PianoMusic == true ) then
		Level.PlayPianoMusic(true);		
	end;

	if ( Level.GuitarMusic == false and Level.PianoMusic == false ) then
		Level.FadeInSound( Level.FindSound('radio_bar'), 2.0 );
	end;

	System:SetVar("cl_player_clothes", true );
	System:SetVar("r_frame_backlog", true );

	Level.EnablePlayerCutsceneMode(false);
	Level.OrientPlayer( -483.40613, 106.75, 305.74249, 180.0 );
	Level.SetPlayerCameraAngles( 200, 10 );
	
	Level.SetWorldObjectPos( Level.FindWorldObject('CBCR'), -485.46704, 49.35465, 223.21976 );
		
	Level.SetHudFadeIn(1.0);

	Actor.StopCustomAnim( Level.FindActor('GR20') );
	Actor.StopCustomAnim( Level.FindActor('GD11') );
	Actor.StopCustomAnim( Level.FindActor('GD12') );
	Actor.StopCustomAnim( Level.FindActor('GD16') );
	Actor.StopCustomAnim( Level.FindActor('HM01') );
	Actor.StopCustomAnim( Level.FindActor('HM02') );

	Level.Enable( "lockmusic", false );
	Level.Enable( "ai", true );

	Level.SetMusic( Level.CutsceneMusicMood, 2.0 );	
	Level.HideAllActors( false, false, false );

	Level.SetWorldObjectState( Level.FindWorldObject('BARS'), 'freeze', false );
	Level.SetWorldObjectPos( Level.FindWorldObject('BARS'), -496.70886, 120.95224, 321.89355 );

	Level.SetWorldObjectPos( Level.FindWorldObject('CSTK'), -513.06702, 120.10368, 320.82001 );

	Level.SetWorldObjectPos( Level.FindWorldObject('CBC2'), 25.44598, -64.76634, -106.0329 );
	Level.SetWorldObjectPos( Level.FindWorldObject('CBRM'), -478.48373, 52.91391, 222.39226 );
	Level.SetWorldObjectPos( Level.FindWorldObject('CBOT'), -478.48373, 52.91391, 222.39226 );
	Level.SetWorldObjectPos( Level.FindWorldObject('CBC1'), -478.48373, 52.91391, 222.39226 );

	Level.SetWorldObjectAnimFrame( Level.FindWorldObject('CBC5'), 1000 );

	if ( Level.isDefaultHM02 == true ) then
		Level.CutsceneBarman_Teleport(false);
	end;
	
	Level.CutsceneBarman = true;

	Level.EnableLight( 'CBL1', true );
	Level.EnableLight( 'CBL2', true );

	AI.SetJob( AI.FindNPC('COUR'), 'default' );
	
end

--------------------------------------------------------
-- Name: Level.OnFinishCutScene()
-- Desc:
--------------------------------------------------------
function Level.OnFinishCutScene( cutscene, boolBreaked, cutsceneName )
   
   if ( cutsceneName == 'photo' ) then
	   if ( boolBreaked == true and Level.CutscenePhotoSkip == false ) then
		   return;
	   end;

	   Level.FinishCutscene_Photo( cutscene );
   elseif ( cutsceneName == 'vargas' ) then
	   if ( boolBreaked == true and Level.CutsceneVargasSkip == false ) then
		   return;
	   end;
	   Level.FinishCutscene_Vargas( cutscene );
   elseif ( cutsceneName == 'barman' ) then

	   if ( boolBreaked == true and Level.CutsceneBarmanSkip == false ) then
		   return;
	   end;

	   Level.FinishCutscene_Barman( cutscene );
   end;

   Level.SetDOFPostFilter( 0, 0, 0, 0, 0 );
   CutScene.Activate(nil);

end

--------------------------------------------------------
-- Name: Level.OnEnterTrigger_SimpleTrigger63()
-- Desc:
--------------------------------------------------------
function Level.OnEnterTrigger_SimpleTrigger63()
	local npc = AI.FindNPC('COUR');
	if ( AI.GetJob(npc) == 'wait' ) then
		AI.SetJob(npc, 'default');
	end;
end

--------------------------------------------------------
-- Name: Level.OnStartNextLevel()
-- Desc: 
--------------------------------------------------------
function Level.OnStartNextLevel()

	if ( System:PlayVideo( "Models\\CutScenes\\Other\\20_Cutscene.ogg", "System:LoadLevel( 'gamemenu' , 6 )", 
						   "Models\\CutScenes\\Other\\20_Cutscene.shadvs", 5.0 ) == false ) then

			System:LoadLevel( 'gamemenu' , 6 );

	end;

end

--------------------------------------------------------
-- Name: Level.OnMenuClicked()
-- Desc: 
--------------------------------------------------------
function Level.OnMenuClicked( clickId, param1 )
	
	if ( clickId == "ScoreMenu.Continue" ) then

		Level.SetMusic( Level.MUSIC_MOOD_NONE, 0.0 );
		Level.Enable("lockmusic", true );

		if ( System:PlayVideo( "Models\\CutScenes\\Other\\19_Cutscene.ogg", "Level.OnStartNextLevel()", 
							   "Models\\CutScenes\\Other\\19_Cutscene.shadvs", 5.0 ) == false ) then

				Level.OnStartNextLevel();

		end;

	end;

end

--------------------------------------------------------
-- Name: Level.OnEnterTrigger_SimpleTrigger65()
-- Desc: 
--------------------------------------------------------
function Level.OnEnterTrigger_SimpleTrigger65()

	if ( Level.BikersTalk1 == true ) then
		return;
	end;

	local npc1 = AI.FindNPC('GR19');
	local npc2 = AI.FindNPC('GR20');

	if ( AI.IsDefault(npc1) == true and AI.IsDefault(npc2) == true ) then
			Level.RunAnchorJob( npc1, 'A123', true );
			AI.HandleVoice( npc1, 'script_level05_talk_1' );

			AI.Invoke( "AI.HandleVoice( AI.FindNPC('GR20'), 'script_level05_talk_2' )" , 10 );

			Level.BikersTalk1 = true;
	end;

end

--------------------------------------------------------
-- Name: Level.OnEnterTrigger_SimpleTrigger38()
-- Desc: 
--------------------------------------------------------
function Level.OnEnterTrigger_SimpleTrigger38()

	if ( Level.GuitarTalk == true ) then
		return;
	end;

	local npc = AI.FindNPC('ART1');

	if ( AI.IsDefault(npc) == true ) then

		AI.HandleVoice( npc, 'script_level05_guitar' );
		Level.SayMessage( npc, Level.GetMissionText('TLK1'), 5.0 );

		AI.Invoke( "AI.SetJob( AI.FindNPC('ART1'), 'default' )", 6.0 );

		Level.GuitarTalk = true;

	end;

end


--function aa()
--	Level.StartCutscene_Barman();	
--end

