/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui;

import jadx.core.utils.exceptions.JadxException;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.JadxSettingsAdapter;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.LogCollector;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxGUI {
    private static final Logger LOG = LoggerFactory.getLogger(JadxGUI.class);

    public static void main(String[] args) {
        try {
            LogCollector.register();
            final JadxSettings jadxArgs = JadxSettingsAdapter.load();
            if (!jadxArgs.processArgs(args)) {
                return;
            }
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        MainWindow window = new MainWindow(jadxArgs);
                        window.open();
                    }
                    catch (JadxException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Throwable e) {
            LOG.error("Error: {}", (Object)e.getMessage(), (Object)e);
            System.exit(1);
        }
    }
}

