/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.JavaClass;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.core.dex.info.AccessInfo;
import jadx.gui.treemodel.JField;
import jadx.gui.treemodel.JMethod;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.TextNode;
import jadx.gui.utils.NLS;
import jadx.gui.utils.Utils;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class JClass
extends JNode {
    private static final long serialVersionUID = -1239986875244097177L;
    private static final ImageIcon ICON_CLASS = Utils.openIcon("class_obj");
    private static final ImageIcon ICON_CLASS_DEFAULT = Utils.openIcon("class_default_obj");
    private static final ImageIcon ICON_CLASS_PRIVATE = Utils.openIcon("innerclass_private_obj");
    private static final ImageIcon ICON_CLASS_PROTECTED = Utils.openIcon("innerclass_protected_obj");
    private static final ImageIcon ICON_INTERFACE = Utils.openIcon("int_obj");
    private static final ImageIcon ICON_ENUM = Utils.openIcon("enum_obj");
    private static final ImageIcon ICON_ANNOTATION = Utils.openIcon("annotation_obj");
    private final transient JavaClass cls;
    private final transient JClass jParent;
    private transient boolean loaded;

    public JClass(JavaClass cls) {
        this.cls = cls;
        this.jParent = null;
        this.loaded = false;
    }

    public JClass(JavaClass cls, JClass parent) {
        this.cls = cls;
        this.jParent = parent;
        this.loaded = true;
    }

    public JavaClass getCls() {
        return this.cls;
    }

    public synchronized void load() {
        if (!this.loaded) {
            this.cls.decompile();
            this.loaded = true;
        }
        this.update();
    }

    public synchronized void update() {
        this.removeAllChildren();
        if (!this.loaded) {
            this.add(new TextNode(NLS.str("tree.loading")));
        } else {
            for (JavaClass javaClass : this.cls.getInnerClasses()) {
                JClass innerCls = new JClass(javaClass, this);
                this.add(innerCls);
                innerCls.update();
            }
            for (JavaField f : this.cls.getFields()) {
                this.add(new JField(f, this));
            }
            for (JavaMethod m : this.cls.getMethods()) {
                this.add(new JMethod(m, this));
            }
        }
    }

    @Override
    public String getContent() {
        return this.cls.getCode();
    }

    @Override
    public String getSyntaxName() {
        return "text/java";
    }

    @Override
    public Icon getIcon() {
        AccessInfo accessInfo = this.cls.getAccessInfo();
        if (accessInfo.isEnum()) {
            return ICON_ENUM;
        }
        if (accessInfo.isAnnotation()) {
            return ICON_ANNOTATION;
        }
        if (accessInfo.isInterface()) {
            return ICON_INTERFACE;
        }
        if (accessInfo.isProtected()) {
            return ICON_CLASS_PROTECTED;
        }
        if (accessInfo.isPrivate()) {
            return ICON_CLASS_PRIVATE;
        }
        if (accessInfo.isPublic()) {
            return ICON_CLASS;
        }
        return ICON_CLASS_DEFAULT;
    }

    @Override
    public JavaNode getJavaNode() {
        return this.cls;
    }

    @Override
    public JClass getJParent() {
        return this.jParent;
    }

    @Override
    public JClass getRootClass() {
        if (this.jParent == null) {
            return this;
        }
        return this.jParent.getRootClass();
    }

    @Override
    public String getName() {
        return this.cls.getName();
    }

    public String getFullName() {
        return this.cls.getFullName();
    }

    @Override
    public int getLine() {
        return this.cls.getDecompiledLine();
    }

    @Override
    public Integer getSourceLine(int line) {
        return this.cls.getSourceLine(line);
    }

    public int hashCode() {
        return this.cls.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof JClass && this.cls.equals((Object)((JClass)obj).cls);
    }

    @Override
    public String makeString() {
        return this.cls.getName();
    }

    @Override
    public String makeLongString() {
        return this.cls.getFullName();
    }
}

