/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.JavaPackage;
import jadx.gui.JadxWrapper;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JPackage;
import jadx.gui.treemodel.JRoot;
import jadx.gui.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class JSources
extends JNode {
    private static final long serialVersionUID = 8962924556824862801L;
    private static final ImageIcon ROOT_ICON = Utils.openIcon("packagefolder_obj");
    private final transient JadxWrapper wrapper;
    private final transient boolean flatPackages;

    public JSources(JRoot jRoot, JadxWrapper wrapper) {
        this.flatPackages = jRoot.isFlatPackages();
        this.wrapper = wrapper;
        this.update();
    }

    public final void update() {
        this.removeAllChildren();
        if (this.flatPackages) {
            for (JavaPackage pkg : this.wrapper.getPackages()) {
                this.add(new JPackage(pkg));
            }
        } else {
            List<JPackage> rootPkgs = this.getHierarchyPackages(this.wrapper.getPackages());
            for (JPackage jPackage : rootPkgs) {
                jPackage.update();
                this.add(jPackage);
            }
        }
    }

    List<JPackage> getHierarchyPackages(List<JavaPackage> packages) {
        boolean repeat;
        HashMap<String, JPackage> pkgMap = new HashMap<String, JPackage>();
        for (JavaPackage javaPackage : packages) {
            this.addPackage(pkgMap, new JPackage(javaPackage));
        }
        block1: do {
            repeat = false;
            for (Object pkg : pkgMap.values()) {
                if (((JPackage)pkg).getInnerPackages().size() != 1 || !((JPackage)pkg).getClasses().isEmpty()) continue;
                JPackage innerPkg = ((JPackage)pkg).getInnerPackages().get(0);
                ((JPackage)pkg).getInnerPackages().clear();
                ((JPackage)pkg).getInnerPackages().addAll(innerPkg.getInnerPackages());
                ((JPackage)pkg).getClasses().addAll(innerPkg.getClasses());
                ((JPackage)pkg).setName(((JPackage)pkg).getName() + "." + innerPkg.getName());
                innerPkg.getInnerPackages().clear();
                innerPkg.getClasses().clear();
                repeat = true;
                continue block1;
            }
        } while (repeat);
        Iterator iterator = pkgMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Object pkg;
            pkg = (JPackage)iterator.next().getValue();
            if (!((JPackage)pkg).getInnerPackages().isEmpty() || !((JPackage)pkg).getClasses().isEmpty()) continue;
            iterator.remove();
        }
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        for (JPackage pkg : pkgMap.values()) {
            set.addAll(pkg.getInnerPackages());
        }
        ArrayList<JPackage> rootPkgs = new ArrayList<JPackage>();
        for (JPackage pkg : pkgMap.values()) {
            if (set.contains(pkg)) continue;
            rootPkgs.add(pkg);
        }
        Collections.sort(rootPkgs);
        return rootPkgs;
    }

    private void addPackage(Map<String, JPackage> pkgs, JPackage pkg) {
        int dot;
        String pkgName = pkg.getName();
        JPackage replaced = pkgs.put(pkgName, pkg);
        if (replaced != null) {
            pkg.getInnerPackages().addAll(replaced.getInnerPackages());
            pkg.getClasses().addAll(replaced.getClasses());
        }
        if ((dot = pkgName.lastIndexOf(46)) > 0) {
            String prevPart = pkgName.substring(0, dot);
            String shortName = pkgName.substring(dot + 1);
            pkg.setName(shortName);
            JPackage prevPkg = pkgs.get(prevPart);
            if (prevPkg == null) {
                prevPkg = new JPackage(prevPart);
                this.addPackage(pkgs, prevPkg);
            }
            prevPkg.getInnerPackages().add(pkg);
        }
    }

    @Override
    public Icon getIcon() {
        return ROOT_ICON;
    }

    @Override
    public JClass getJParent() {
        return null;
    }

    @Override
    public String makeString() {
        return "Source code";
    }
}

