/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import jadx.gui.jobs.BackgroundJob;
import jadx.gui.jobs.BackgroundWorker;
import jadx.gui.jobs.DecompileJob;
import jadx.gui.jobs.IndexJob;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.TextNode;
import jadx.gui.ui.CodeArea;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.ProgressPanel;
import jadx.gui.ui.TabbedPane;
import jadx.gui.utils.CacheObject;
import jadx.gui.utils.NLS;
import jadx.gui.utils.Position;
import jadx.gui.utils.search.TextSearchIndex;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonSearchDialog
extends JDialog {
    private static final Logger LOG = LoggerFactory.getLogger(CommonSearchDialog.class);
    private static final long serialVersionUID = 8939332306115370276L;
    public static final int MAX_RESULTS_COUNT = 100;
    protected final transient TabbedPane tabbedPane;
    protected final transient CacheObject cache;
    protected final transient MainWindow mainWindow;
    protected final transient Font codeFont;
    protected ResultsModel resultsModel;
    protected ResultsTable resultsTable;
    protected JLabel warnLabel;
    protected ProgressPanel progressPane;
    protected String highlightText;

    public CommonSearchDialog(MainWindow mainWindow) {
        super(mainWindow);
        this.mainWindow = mainWindow;
        this.tabbedPane = mainWindow.getTabbedPane();
        this.cache = mainWindow.getCacheObject();
        this.codeFont = mainWindow.getSettings().getFont();
    }

    protected abstract void openInit();

    protected abstract void loadFinished();

    protected abstract void loadStart();

    public void loadWindowPos() {
        this.mainWindow.getSettings().loadWindowPos(this);
    }

    public void prepare() {
        if (this.cache.getIndexJob().isComplete()) {
            this.loadFinishedCommon();
            this.loadFinished();
            return;
        }
        LoadTask task = new LoadTask();
        task.addPropertyChangeListener(this.progressPane);
        task.execute();
    }

    protected void registerInitOnOpen() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CommonSearchDialog.this.openInit();
                    }
                });
            }
        });
    }

    protected void openSelectedItem() {
        int selectedId = this.resultsTable.getSelectedRow();
        if (selectedId == -1) {
            return;
        }
        JNode node = (JNode)this.resultsModel.getValueAt(selectedId, 0);
        this.tabbedPane.codeJump(new Position(node.getRootClass(), node.getLine()));
        this.dispose();
    }

    @Override
    public void dispose() {
        this.mainWindow.getSettings().saveWindowPos(this);
        super.dispose();
    }

    protected void initCommon() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonSearchDialog.this.dispose();
            }
        }, stroke, 2);
    }

    @NotNull
    protected JPanel initButtonsPanel() {
        this.progressPane = new ProgressPanel(this.mainWindow, false);
        JButton cancelButton = new JButton(NLS.str("search_dialog.cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CommonSearchDialog.this.dispose();
            }
        });
        JButton openBtn = new JButton(NLS.str("search_dialog.open"));
        openBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CommonSearchDialog.this.openSelectedItem();
            }
        });
        this.getRootPane().setDefaultButton(openBtn);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(this.progressPane);
        buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(openBtn);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        return buttonPane;
    }

    protected JPanel initResultsTable() {
        ResultsTableCellRenderer renderer = new ResultsTableCellRenderer();
        this.resultsModel = new ResultsModel(renderer);
        this.resultsTable = new ResultsTable(this.resultsModel);
        this.resultsTable.setShowHorizontalLines(false);
        this.resultsTable.setDragEnabled(false);
        this.resultsTable.setSelectionMode(0);
        this.resultsTable.setBackground(CodeArea.CODE_BACKGROUND);
        this.resultsTable.setColumnSelectionAllowed(false);
        this.resultsTable.setAutoResizeMode(0);
        this.resultsTable.setAutoscrolls(false);
        Enumeration<TableColumn> columns = this.resultsTable.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            column.setCellRenderer(renderer);
        }
        this.resultsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    CommonSearchDialog.this.openSelectedItem();
                }
            }
        });
        this.resultsTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CommonSearchDialog.this.openSelectedItem();
                }
            }
        });
        this.warnLabel = new JLabel();
        this.warnLabel.setForeground(Color.RED);
        this.warnLabel.setVisible(false);
        JPanel resultsPanel = new JPanel();
        resultsPanel.setLayout(new BoxLayout(resultsPanel, 3));
        resultsPanel.add(this.warnLabel);
        resultsPanel.add(new JScrollPane(this.resultsTable, 20, 30));
        resultsPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        return resultsPanel;
    }

    protected void loadStartCommon() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.progressPane.setIndeterminate(true);
        this.progressPane.setVisible(true);
        this.resultsTable.setEnabled(false);
        this.warnLabel.setVisible(false);
    }

    private void loadFinishedCommon() {
        this.setCursor(null);
        this.resultsTable.setEnabled(true);
        this.progressPane.setVisible(false);
        TextSearchIndex textIndex = this.cache.getTextIndex();
        if (textIndex == null) {
            this.warnLabel.setText("Index not initialized, search will be disabled!");
            this.warnLabel.setVisible(true);
        }
    }

    private class LoadTask
    extends SwingWorker<Void, Void> {
        public LoadTask() {
            CommonSearchDialog.this.loadStartCommon();
            CommonSearchDialog.this.loadStart();
        }

        @Override
        public Void doInBackground() {
            try {
                BackgroundWorker backgroundWorker = CommonSearchDialog.this.mainWindow.getBackgroundWorker();
                if (backgroundWorker == null) {
                    return null;
                }
                backgroundWorker.exec();
                DecompileJob decompileJob = CommonSearchDialog.this.cache.getDecompileJob();
                CommonSearchDialog.this.progressPane.changeLabel(this, decompileJob.getInfoString());
                decompileJob.processAndWait();
                IndexJob indexJob = CommonSearchDialog.this.cache.getIndexJob();
                CommonSearchDialog.this.progressPane.changeLabel(this, ((BackgroundJob)indexJob).getInfoString());
                indexJob.processAndWait();
            }
            catch (Exception e) {
                LOG.error("Waiting background tasks failed", (Throwable)e);
            }
            return null;
        }

        @Override
        public void done() {
            CommonSearchDialog.this.loadFinishedCommon();
            CommonSearchDialog.this.loadFinished();
        }
    }

    protected class ResultsTableCellRenderer
    implements TableCellRenderer {
        private final Color selectedBackground;
        private final Color selectedForeground;
        private final Color foreground;
        private final JLabel emptyLabel = new JLabel();
        private Map<Integer, Component> componentCache = new HashMap<Integer, Component>();

        public ResultsTableCellRenderer() {
            UIDefaults defaults = UIManager.getDefaults();
            this.foreground = defaults.getColor("List.foreground");
            this.selectedBackground = defaults.getColor("List.selectionBackground");
            this.selectedForeground = defaults.getColor("List.selectionForeground");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            int id = row << 2 | column;
            Component comp = this.componentCache.get(id);
            if (comp == null) {
                if (obj instanceof JNode) {
                    comp = this.makeCell((JNode)obj, column);
                    this.componentCache.put(id, comp);
                } else {
                    comp = this.emptyLabel;
                }
            }
            this.updateSelection(comp, isSelected);
            return comp;
        }

        private void updateSelection(Component comp, boolean isSelected) {
            if (isSelected) {
                comp.setBackground(this.selectedBackground);
                comp.setForeground(this.selectedForeground);
            } else {
                comp.setBackground(CodeArea.CODE_BACKGROUND);
                comp.setForeground(this.foreground);
            }
        }

        private Component makeCell(JNode node, int column) {
            if (column == 0) {
                JLabel label = new JLabel(node.makeLongString() + "  ", node.getIcon(), 2);
                label.setOpaque(true);
                label.setToolTipText(label.getText());
                return label;
            }
            if (!node.hasDescString()) {
                return this.emptyLabel;
            }
            RSyntaxTextArea textArea = new RSyntaxTextArea();
            textArea.setFont(CommonSearchDialog.this.codeFont);
            textArea.setEditable(false);
            textArea.setSyntaxEditingStyle("text/java");
            textArea.setText("  " + node.makeDescString());
            textArea.setRows(1);
            textArea.setColumns(textArea.getText().length());
            if (CommonSearchDialog.this.highlightText != null) {
                SearchContext searchContext = new SearchContext(CommonSearchDialog.this.highlightText);
                searchContext.setMatchCase(true);
                searchContext.setMarkAll(true);
                SearchEngine.markAll((RTextArea)textArea, (SearchContext)searchContext);
            }
            return textArea;
        }

        public void clear() {
            this.componentCache.clear();
        }
    }

    protected static class ResultsModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -7821286846923903208L;
        private static final String[] COLUMN_NAMES = new String[]{"Node", "Code"};
        private final transient List<JNode> rows = new ArrayList<JNode>();
        private final transient ResultsTableCellRenderer renderer;
        private transient boolean addDescColumn;

        public ResultsModel(ResultsTableCellRenderer renderer) {
            this.renderer = renderer;
        }

        protected void addAll(Iterable<? extends JNode> nodes) {
            for (JNode jNode : nodes) {
                int size = this.getRowCount();
                if (size >= 100) {
                    if (size == 100) {
                        this.add(new TextNode("Search results truncated (limit: 100)"));
                    }
                    return;
                }
                this.add(jNode);
            }
        }

        private void add(JNode node) {
            if (node.hasDescString()) {
                this.addDescColumn = true;
            }
            this.rows.add(node);
        }

        public void clear() {
            this.addDescColumn = false;
            this.rows.clear();
            this.renderer.clear();
        }

        public boolean isAddDescColumn() {
            return this.addDescColumn;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int index) {
            return COLUMN_NAMES[index];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.rows.get(rowIndex);
        }
    }

    protected static class ResultsTable
    extends JTable {
        private static final long serialVersionUID = 3901184054736618969L;

        public ResultsTable(ResultsModel resultsModel) {
            super(resultsModel);
        }

        public void updateTable() {
            ResultsModel model = (ResultsModel)this.getModel();
            TableColumnModel columnModel = this.getColumnModel();
            int width = this.getParent().getWidth();
            int firstColMaxWidth = (int)((double)width * 0.5);
            int rowCount = this.getRowCount();
            int columnCount = this.getColumnCount();
            if (!model.isAddDescColumn()) {
                firstColMaxWidth = width;
            }
            Component codeComp = null;
            for (int col = 0; col < columnCount; ++col) {
                int colWidth = 50;
                for (int row = 0; row < rowCount; ++row) {
                    TableCellRenderer renderer = this.getCellRenderer(row, col);
                    Component comp = this.prepareRenderer(renderer, row, col);
                    if (comp == null) continue;
                    colWidth = Math.max(comp.getPreferredSize().width, colWidth);
                    if (codeComp != null || col != 1) continue;
                    codeComp = comp;
                }
                colWidth += 10;
                colWidth = col == 0 ? Math.min(colWidth, firstColMaxWidth) : Math.max(colWidth, width - columnModel.getColumn(0).getPreferredWidth());
                TableColumn column = columnModel.getColumn(col);
                column.setPreferredWidth(colWidth);
            }
            if (codeComp != null) {
                this.setRowHeight(Math.max(20, codeComp.getPreferredSize().height + 4));
            }
            this.updateUI();
        }
    }
}

