/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import jadx.gui.ui.CodeArea;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.Utilities;

public class LineNumbers
extends JPanel
implements CaretListener {
    private static final long serialVersionUID = -4978268673635308190L;
    private static final Border OUTER = new MatteBorder(0, 0, 0, 1, Color.LIGHT_GRAY);
    private static final int NUM_HEIGHT = 2146483647;
    private static final Color NUM_FOREGROUND = Color.GRAY;
    private static final Color NUM_BACKGROUND = CodeArea.CODE_BACKGROUND;
    private static final Color CURRENT_LINE_FOREGROUND = new Color(227, 0, 0);
    private CodeArea codeArea;
    private boolean useSourceLines = true;
    private int lastDigits;
    private int lastLine;
    private Map<String, FontMetrics> fonts;

    public LineNumbers(CodeArea component) {
        this.codeArea = component;
        this.setFont(component.getFont());
        this.setBackground(NUM_BACKGROUND);
        this.setForeground(NUM_FOREGROUND);
        this.setBorderGap(5);
        this.setPreferredWidth();
        component.addCaretListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    LineNumbers.this.useSourceLines = !LineNumbers.this.useSourceLines;
                    LineNumbers.this.repaint();
                }
            }
        });
    }

    public void setBorderGap(int borderGap) {
        EmptyBorder inner = new EmptyBorder(0, borderGap, 0, borderGap);
        this.setBorder(new CompoundBorder(OUTER, inner));
        this.lastDigits = 0;
    }

    private void setPreferredWidth() {
        Element root = this.codeArea.getDocument().getDefaultRootElement();
        int lines = root.getElementCount();
        int digits = Math.max(String.valueOf(lines).length(), 3);
        if (this.lastDigits != digits) {
            this.lastDigits = digits;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int width = fontMetrics.charWidth('0') * digits;
            Insets insets = this.getInsets();
            int preferredWidth = insets.left + insets.right + width;
            Dimension d = this.getPreferredSize();
            if (d != null) {
                d.setSize(preferredWidth, 2146483647);
                this.setPreferredSize(d);
                this.setSize(d);
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        FontMetrics fontMetrics = this.codeArea.getFontMetrics(this.codeArea.getFont());
        Insets insets = this.getInsets();
        int availableWidth = this.getSize().width - insets.left - insets.right;
        Rectangle clip = g.getClipBounds();
        int rowStartOffset = this.codeArea.viewToModel(new Point(0, clip.y));
        int endOffset = this.codeArea.viewToModel(new Point(0, clip.y + clip.height));
        while (rowStartOffset <= endOffset) {
            try {
                if (this.isCurrentLine(rowStartOffset)) {
                    g.setColor(CURRENT_LINE_FOREGROUND);
                } else {
                    g.setColor(NUM_FOREGROUND);
                }
                String lineNumber = this.getTextLineNumber(rowStartOffset);
                int stringWidth = fontMetrics.stringWidth(lineNumber);
                int x = availableWidth - stringWidth + insets.left;
                int y = this.getOffsetY(rowStartOffset, fontMetrics);
                g.drawString(lineNumber, x, y);
                rowStartOffset = Utilities.getRowEnd((JTextComponent)((Object)this.codeArea), rowStartOffset) + 1;
            }
            catch (Exception e) {
                break;
            }
        }
    }

    private boolean isCurrentLine(int rowStartOffset) {
        int caretPosition = this.codeArea.getCaretPosition();
        Element root = this.codeArea.getDocument().getDefaultRootElement();
        return root.getElementIndex(rowStartOffset) == root.getElementIndex(caretPosition);
    }

    protected String getTextLineNumber(int rowStartOffset) {
        int index;
        Element root = this.codeArea.getDocument().getDefaultRootElement();
        Element line = root.getElement(index = root.getElementIndex(rowStartOffset));
        if (line.getStartOffset() == rowStartOffset) {
            int lineNumber = index + 1;
            if (this.useSourceLines) {
                Integer sourceLine = this.codeArea.getSourceLine(lineNumber);
                if (sourceLine != null) {
                    return String.valueOf(sourceLine);
                }
            } else {
                return String.valueOf(lineNumber);
            }
        }
        return "";
    }

    private int getOffsetY(int rowStartOffset, FontMetrics fontMetrics) throws BadLocationException {
        Rectangle r = this.codeArea.modelToView(rowStartOffset);
        if (r == null) {
            throw new BadLocationException("Can't get Y offset", rowStartOffset);
        }
        int lineHeight = fontMetrics.getHeight();
        int y = r.y + r.height;
        int descent = 0;
        if (r.height == lineHeight) {
            descent = fontMetrics.getDescent();
        } else {
            if (this.fonts == null) {
                this.fonts = new HashMap<String, FontMetrics>();
            }
            Element root = this.codeArea.getDocument().getDefaultRootElement();
            int index = root.getElementIndex(rowStartOffset);
            Element line = root.getElement(index);
            for (int i = 0; i < line.getElementCount(); ++i) {
                Element child = line.getElement(i);
                AttributeSet as = child.getAttributes();
                String fontFamily = (String)as.getAttribute(StyleConstants.FontFamily);
                Integer fontSize = (Integer)as.getAttribute(StyleConstants.FontSize);
                String key = fontFamily + fontSize;
                FontMetrics fm = this.fonts.get(key);
                if (fm == null) {
                    Font font = new Font(fontFamily, 0, fontSize);
                    fm = this.codeArea.getFontMetrics(font);
                    this.fonts.put(key, fm);
                }
                descent = Math.max(descent, fm.getDescent());
            }
        }
        return y - descent;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        int caretPosition = this.codeArea.getCaretPosition();
        Element root = this.codeArea.getDocument().getDefaultRootElement();
        int currentLine = root.getElementIndex(caretPosition);
        if (this.lastLine != currentLine) {
            this.repaint();
            this.lastLine = currentLine;
        }
    }
}

