/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import ch.qos.logback.classic.Level;
import jadx.gui.settings.JadxSettings;
import jadx.gui.utils.LogCollector;
import jadx.gui.utils.NLS;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

class LogViewer
extends JDialog {
    private static final long serialVersionUID = -2188700277429054641L;
    private static final Level[] LEVEL_ITEMS = new Level[]{Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR};
    private static Level level = Level.WARN;
    private final transient JadxSettings settings;
    private transient RSyntaxTextArea textPane;

    public LogViewer(JadxSettings settings) {
        this.settings = settings;
        this.initUI();
        this.registerLogListener();
        settings.loadWindowPos(this);
    }

    public final void initUI() {
        this.textPane = new RSyntaxTextArea();
        this.textPane.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JPanel controlPane = new JPanel();
        controlPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        final JComboBox<Level> cb = new JComboBox<Level>(LEVEL_ITEMS);
        cb.setSelectedItem(level);
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = cb.getSelectedIndex();
                level = LEVEL_ITEMS[i];
                LogViewer.this.registerLogListener();
            }
        });
        JLabel levelLabel = new JLabel(NLS.str("log.level"));
        levelLabel.setLabelFor(cb);
        controlPane.add(levelLabel);
        controlPane.add(cb);
        JScrollPane scrollPane = new JScrollPane((Component)this.textPane);
        JButton close = new JButton(NLS.str("tabs.close"));
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LogViewer.this.close();
            }
        });
        close.setAlignmentX(0.5f);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)controlPane, "First");
        contentPane.add((Component)scrollPane, "Center");
        contentPane.add((Component)close, "Last");
        this.setTitle("Log Viewer");
        this.pack();
        this.setSize(800, 600);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.setLocationRelativeTo(null);
    }

    private void registerLogListener() {
        LogCollector logCollector = LogCollector.getInstance();
        logCollector.resetListener();
        this.textPane.setText("");
        logCollector.registerListener(new LogCollector.ILogListener(){

            @Override
            public Level getFilterLevel() {
                return level;
            }

            @Override
            public void onAppend(final String logStr) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LogViewer.this.textPane.append(logStr);
                        LogViewer.this.textPane.updateUI();
                    }
                });
            }
        });
    }

    private void close() {
        this.dispose();
    }

    @Override
    public void dispose() {
        LogCollector.getInstance().resetListener();
        this.settings.saveWindowPos(this);
        super.dispose();
    }
}

