/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import jadx.gui.ui.CommonSearchDialog;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.NLS;
import jadx.gui.utils.TextStandardActions;
import jadx.gui.utils.search.TextSearchIndex;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SearchDialog
extends CommonSearchDialog {
    private static final long serialVersionUID = -5105405456969134105L;
    private Set<SearchOptions> options = EnumSet.allOf(SearchOptions.class);
    private JTextField searchField;

    public SearchDialog(MainWindow mainWindow, Set<SearchOptions> options) {
        super(mainWindow);
        this.options = options;
        this.initUI();
        this.registerInitOnOpen();
        this.loadWindowPos();
    }

    @Override
    protected void openInit() {
        this.prepare();
        String lastSearch = this.cache.getLastSearch();
        if (lastSearch != null) {
            this.searchField.setText(lastSearch);
            this.searchField.selectAll();
        }
        this.searchField.requestFocus();
    }

    private synchronized void performSearch() {
        this.resultsModel.clear();
        String text = this.searchField.getText();
        if (text == null || text.isEmpty() || this.options.isEmpty()) {
            this.resultsTable.updateTable();
            return;
        }
        this.cache.setLastSearch(text);
        TextSearchIndex index = this.cache.getTextIndex();
        if (index == null) {
            this.resultsTable.updateTable();
            return;
        }
        if (this.options.contains((Object)SearchOptions.CLASS)) {
            this.resultsModel.addAll(index.searchClsName(text));
        }
        if (this.options.contains((Object)SearchOptions.METHOD)) {
            this.resultsModel.addAll(index.searchMthName(text));
        }
        if (this.options.contains((Object)SearchOptions.FIELD)) {
            this.resultsModel.addAll(index.searchFldName(text));
        }
        if (this.options.contains((Object)SearchOptions.CODE)) {
            this.resultsModel.addAll(index.searchCode(text));
        }
        this.highlightText = text;
        this.resultsTable.updateTable();
    }

    private void initUI() {
        JLabel findLabel = new JLabel(NLS.str("search_dialog.open_by_name"));
        this.searchField = new JTextField();
        this.searchField.setAlignmentX(0.0f);
        this.searchField.getDocument().addDocumentListener(new SearchFieldListener());
        new TextStandardActions(this.searchField);
        JCheckBox clsChBox = this.makeOptionsCheckBox(NLS.str("search_dialog.class"), SearchOptions.CLASS);
        JCheckBox mthChBox = this.makeOptionsCheckBox(NLS.str("search_dialog.method"), SearchOptions.METHOD);
        JCheckBox fldChBox = this.makeOptionsCheckBox(NLS.str("search_dialog.field"), SearchOptions.FIELD);
        JCheckBox codeChBox = this.makeOptionsCheckBox(NLS.str("search_dialog.code"), SearchOptions.CODE);
        JPanel searchOptions = new JPanel(new FlowLayout(0));
        searchOptions.setBorder(BorderFactory.createTitledBorder(NLS.str("search_dialog.search_in")));
        searchOptions.add(clsChBox);
        searchOptions.add(mthChBox);
        searchOptions.add(fldChBox);
        searchOptions.add(codeChBox);
        searchOptions.setAlignmentX(0.0f);
        JPanel searchPane = new JPanel();
        searchPane.setLayout(new BoxLayout(searchPane, 3));
        findLabel.setLabelFor(this.searchField);
        searchPane.add(findLabel);
        searchPane.add(Box.createRigidArea(new Dimension(0, 5)));
        searchPane.add(this.searchField);
        searchPane.add(Box.createRigidArea(new Dimension(0, 5)));
        searchPane.add(searchOptions);
        searchPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.initCommon();
        JPanel resultsPanel = this.initResultsTable();
        JPanel buttonPane = this.initButtonsPanel();
        Container contentPane = this.getContentPane();
        contentPane.add((Component)searchPane, "First");
        contentPane.add((Component)resultsPanel, "Center");
        contentPane.add((Component)buttonPane, "Last");
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    if (SearchDialog.this.resultsModel.getRowCount() != 0) {
                        SearchDialog.this.resultsTable.setRowSelectionInterval(0, 0);
                    }
                    SearchDialog.this.resultsTable.requestFocus();
                }
            }
        });
        this.setTitle(NLS.str("menu.text_search"));
        this.pack();
        this.setSize(800, 500);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.MODELESS);
    }

    private JCheckBox makeOptionsCheckBox(String name, final SearchOptions opt) {
        final JCheckBox chBox = new JCheckBox(name);
        chBox.setAlignmentX(0.0f);
        chBox.setSelected(this.options.contains((Object)opt));
        chBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (chBox.isSelected()) {
                    SearchDialog.this.options.add(opt);
                } else {
                    SearchDialog.this.options.remove((Object)opt);
                }
                SearchDialog.this.performSearch();
            }
        });
        return chBox;
    }

    @Override
    protected void loadFinished() {
        this.searchField.setEnabled(true);
    }

    @Override
    protected void loadStart() {
        this.searchField.setEnabled(false);
    }

    private class SearchFieldListener
    implements DocumentListener,
    ActionListener {
        private Timer timer;

        private SearchFieldListener() {
        }

        private synchronized void change() {
            if (this.timer != null) {
                this.timer.restart();
            } else {
                this.timer = new Timer(300, this);
                this.timer.start();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchDialog.this.performSearch();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.change();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.change();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.change();
        }
    }

    static enum SearchOptions {
        CLASS,
        METHOD,
        FIELD,
        CODE;

    }
}

