/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

public class ByteQueue {
    private byte[] databuf;
    private int skipped = 0;
    private int available = 0;

    public static int nextTwoPow(int n) {
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return n + 1;
    }

    public ByteQueue() {
        this(1024);
    }

    public ByteQueue(int n) {
        this.databuf = new byte[n];
    }

    public void read(byte[] byArray, int n, int n2, int n3) {
        if (byArray.length - n < n2) {
            throw new IllegalArgumentException("Buffer size of " + byArray.length + " is too small for a read of " + n2 + " bytes");
        }
        if (this.available - n3 < n2) {
            throw new IllegalStateException("Not enough data to read");
        }
        System.arraycopy(this.databuf, this.skipped + n3, byArray, n, n2);
    }

    public void addData(byte[] byArray, int n, int n2) {
        if (this.skipped + this.available + n2 > this.databuf.length) {
            int n3 = ByteQueue.nextTwoPow(this.available + n2);
            if (n3 > this.databuf.length) {
                byte[] byArray2 = new byte[n3];
                System.arraycopy(this.databuf, this.skipped, byArray2, 0, this.available);
                this.databuf = byArray2;
            } else {
                System.arraycopy(this.databuf, this.skipped, this.databuf, 0, this.available);
            }
            this.skipped = 0;
        }
        System.arraycopy(byArray, n, this.databuf, this.skipped + this.available, n2);
        this.available += n2;
    }

    public void removeData(int n) {
        if (n > this.available) {
            throw new IllegalStateException("Cannot remove " + n + " bytes, only got " + this.available);
        }
        this.available -= n;
        this.skipped += n;
    }

    public void removeData(byte[] byArray, int n, int n2, int n3) {
        this.read(byArray, n, n2, n3);
        this.removeData(n3 + n2);
    }

    public byte[] removeData(int n, int n2) {
        byte[] byArray = new byte[n];
        this.removeData(byArray, 0, n, n2);
        return byArray;
    }

    public int size() {
        return this.available;
    }

    public int available() {
        return this.available;
    }
}

