/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mceliece;

import java.math.BigInteger;
import org.bouncycastle.pqc.math.linearalgebra.BigIntUtils;
import org.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import org.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;

final class Conversions {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);

    public static GF2Vector encode(int n, int n2, byte[] byArray) {
        if (n < n2) {
            throw new IllegalArgumentException("n < t");
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = IntegerFunctions.binomial(n, n2);
        if (bigInteger.compareTo(bigInteger2) >= 0) {
            throw new IllegalArgumentException("Encoded number too large.");
        }
        GF2Vector gF2Vector = new GF2Vector(n);
        int n3 = n;
        int n4 = n2;
        for (int i = 0; i < n; ++i) {
            bigInteger2 = bigInteger2.multiply(BigInteger.valueOf(n3 - n4)).divide(BigInteger.valueOf(n3));
            --n3;
            if (bigInteger2.compareTo(bigInteger) > 0) continue;
            gF2Vector.setBit(i);
            bigInteger = bigInteger.subtract(bigInteger2);
            bigInteger2 = n3 == --n4 ? ONE : bigInteger2.multiply(BigInteger.valueOf(n4 + 1)).divide(BigInteger.valueOf(n3 - n4));
        }
        return gF2Vector;
    }

    public static byte[] decode(int n, int n2, GF2Vector gF2Vector) {
        if (gF2Vector.getLength() != n || gF2Vector.getHammingWeight() != n2) {
            throw new IllegalArgumentException("vector has wrong length or hamming weight");
        }
        int[] nArray = gF2Vector.getVecArray();
        BigInteger bigInteger = IntegerFunctions.binomial(n, n2);
        BigInteger bigInteger2 = ZERO;
        int n3 = n;
        int n4 = n2;
        for (int i = 0; i < n; ++i) {
            bigInteger = bigInteger.multiply(BigInteger.valueOf(n3 - n4)).divide(BigInteger.valueOf(n3));
            --n3;
            int n5 = i >> 5;
            int n6 = nArray[n5] & 1 << (i & 0x1F);
            if (n6 == 0) continue;
            bigInteger2 = bigInteger2.add(bigInteger);
            bigInteger = n3 == --n4 ? ONE : bigInteger.multiply(BigInteger.valueOf(n4 + 1)).divide(BigInteger.valueOf(n3 - n4));
        }
        return BigIntUtils.toMinimalByteArray(bigInteger2);
    }
}

