/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.annotation.Nullable;
import org.bouncycastle.cms.CMSException;
import org.cf.apkfile.ParseException;
import org.cf.apkfile.apk.Certificate;
import org.cf.apkfile.apk.Resources;
import org.cf.apkfile.dex.DexFile;
import org.cf.apkfile.manifest.AndroidManifest;
import org.cf.apkfile.res.ResourceTableChunk;
import org.pmw.tinylog.Logger;

public class ApkFile
extends JarFile {
    public static final Pattern CERTIFICATE_PATTERN = Pattern.compile("META-INF/[^\\.]+\\.(RSA|DSA|EC)", 2);
    public static final Pattern DEX_PATTERN = Pattern.compile(".dex$", 2);
    public static final Pattern ASSETS_PATTERN = Pattern.compile("^assets/");
    public static final Pattern RESOURCES_PATTERN = Pattern.compile("^res/");
    public static final Pattern RAW_RESOURCES_PATTERN = Pattern.compile("%res/raw/");
    public static final Pattern LIB_PATTERN = Pattern.compile("^lib/");
    public static final byte[] DEX_MAGIC = new byte[]{100, 101, 120, 10, 48, 51};
    private final AndroidManifest androidManifest;
    private final Certificate certificate;
    private final Map<String, DexFile> entryNameToDex;
    private final Map<String, JarEntry> entryNameToEntry;
    private final Resources resources;
    private final transient File theFile;
    private final transient boolean fullMethodSignatures;

    public ApkFile(File file) throws IOException, ParseException {
        this(file.getAbsolutePath());
    }

    public ApkFile(File file, boolean analyzeDexMagic, boolean parseResources, boolean parseAndroidManifest, boolean parseCertificate, boolean fullMethodSignatures) throws IOException, ParseException {
        this(file.getAbsolutePath(), analyzeDexMagic, parseResources, parseAndroidManifest, parseCertificate, fullMethodSignatures);
    }

    public ApkFile(String apkPath) throws IOException, ParseException {
        this(apkPath, true, true, true, true, true);
    }

    public ApkFile(String apkPath, boolean analyzeDexMagic, boolean parseResources, boolean parseAndroidManifest, boolean parseCertificate, boolean fullMethodSignatures) throws IOException, ParseException {
        super(apkPath, parseCertificate);
        this.fullMethodSignatures = fullMethodSignatures;
        this.theFile = new File(apkPath);
        this.entryNameToEntry = ApkFile.buildEntryNameToEntry(this);
        this.certificate = parseCertificate ? this.parseCertificate() : null;
        this.resources = parseResources ? this.parseResources() : null;
        if (parseAndroidManifest) {
            ResourceTableChunk resourceTable = this.resources != null ? this.resources.getResourceTable() : null;
            this.androidManifest = this.loadAndroidManifest(resourceTable);
        } else {
            this.androidManifest = null;
        }
        this.entryNameToDex = this.loadDexFiles(analyzeDexMagic);
        for (Map.Entry<String, DexFile> entry : this.entryNameToDex.entrySet()) {
            entry.getValue().analyze();
        }
    }

    public Collection<JarEntry> getAllEntries() {
        return this.getEntryMap().values();
    }

    public AndroidManifest getAndroidManifest() {
        return this.androidManifest;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public Map<String, DexFile> getDexFiles() {
        return this.entryNameToDex;
    }

    public Map<String, JarEntry> getEntries(String entryNamePattern) {
        return this.getEntries(Pattern.compile(entryNamePattern));
    }

    public Map<String, JarEntry> getEntries(Pattern entryNamePattern) {
        return this.entryNameToEntry.entrySet().stream().filter(e -> entryNamePattern.matcher((CharSequence)e.getKey()).find()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public JarEntry getEntry(String entryName) {
        Optional<Map.Entry> entry = this.entryNameToEntry.entrySet().stream().filter(e -> entryName.equals(e.getKey())).findFirst();
        return entry.map(Map.Entry::getValue).orElse(null);
    }

    public JarEntry getEntry(Pattern entryNamePattern) {
        Optional<Map.Entry> entry = this.entryNameToEntry.entrySet().stream().filter(e -> entryNamePattern.matcher((CharSequence)e.getKey()).matches()).findFirst();
        return entry.map(Map.Entry::getValue).orElse(null);
    }

    public Map<String, JarEntry> getEntryMap() {
        return this.entryNameToEntry;
    }

    public Resources getResources() {
        return this.resources;
    }

    public File getFile() {
        return this.theFile;
    }

    @Nullable
    public JarEntry getResourcesArscEntry() {
        return this.getEntry("resources.arsc");
    }

    @Nullable
    public JarEntry getAndroidManifestEntry() {
        return this.getEntry("AndroidManifest.xml");
    }

    public Map<String, JarEntry> getAssetsEntries() {
        return this.getEntries(ASSETS_PATTERN);
    }

    public Map<String, JarEntry> getResourcesEntries() {
        return this.getEntries(RESOURCES_PATTERN);
    }

    public Map<String, JarEntry> getRawResourcesEntries() {
        return this.getEntries(RAW_RESOURCES_PATTERN);
    }

    public Map<String, JarEntry> getLibEntries() {
        return this.getEntries(LIB_PATTERN);
    }

    public JarEntry getCertificateEntry() {
        return this.getEntry(CERTIFICATE_PATTERN);
    }

    public Map<String, JarEntry> getDexEntries() {
        return this.getEntries(DEX_PATTERN);
    }

    private AndroidManifest loadAndroidManifest(@Nullable ResourceTableChunk resourceTable) throws ParseException {
        InputStream manifestStream;
        JarEntry manifestEntry = this.getAndroidManifestEntry();
        if (manifestEntry == null) {
            throw new ParseException("No AndroidManifest found; invalid APK");
        }
        try {
            manifestStream = this.getInputStream(manifestEntry);
        }
        catch (IOException e) {
            throw new ParseException("Unable to stream AndroidManifest", e);
        }
        try {
            return new AndroidManifest(manifestStream, resourceTable);
        }
        catch (Exception e) {
            throw new ParseException("Failed to parse manifest", e);
        }
    }

    private Map<String, DexFile> loadDexFiles(boolean analyzeMagic) {
        Map<Object, Object> dexStreams = new HashMap();
        if (analyzeMagic) {
            for (Map.Entry<String, JarEntry> entry : this.entryNameToEntry.entrySet()) {
                JarEntry ze = entry.getValue();
                if (ze.getSize() < 112L) continue;
                byte[] bytes = new byte[6];
                try {
                    InputStream is = this.getInputStream(ze);
                    BufferedInputStream buf = new BufferedInputStream(is, bytes.length);
                    buf.read(bytes, 0, bytes.length);
                    buf.close();
                    if (Arrays.equals(DEX_MAGIC, bytes)) {
                        is = this.getInputStream(ze);
                        dexStreams.put(entry.getKey(), is);
                    }
                    buf.close();
                }
                catch (Exception e2) {
                    Logger.warn(e2, "Unable to read DEX file: " + ze.getName(), new Object[0]);
                }
            }
        } else {
            dexStreams = this.getDexEntries().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
                try {
                    return this.getInputStream((ZipEntry)e.getValue());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    return null;
                }
            }));
        }
        return dexStreams.entrySet().stream().map(e -> {
            try {
                return new AbstractMap.SimpleEntry(e.getKey(), new DexFile((InputStream)e.getValue(), this.fullMethodSignatures));
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Resources parseResources() throws ParseException {
        InputStream resourcesStream;
        JarEntry resourcesEntry = this.getResourcesArscEntry();
        if (resourcesEntry == null) {
            throw new ParseException("No resources.arsc found; invalid APK");
        }
        try {
            resourcesStream = this.getInputStream(resourcesEntry);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to stream resources: " + e);
        }
        try {
            return new Resources(resourcesStream);
        }
        catch (Exception e) {
            throw new ParseException("Failed to parse resources", e);
        }
    }

    private Certificate parseCertificate() throws ParseException {
        InputStream certStream;
        JarEntry certEntry = this.getCertificateEntry();
        if (certEntry == null) {
            throw new ParseException("No certificate found; unsigned APK");
        }
        try {
            certStream = this.getInputStream(certEntry);
        }
        catch (IOException e) {
            throw new ParseException("No certificate found; unsigned APK", e);
        }
        try {
            return new Certificate(certStream);
        }
        catch (CMSException e) {
            throw new ParseException("Unable to parse signature: " + certEntry.getName(), e);
        }
    }

    private static Map<String, JarEntry> buildEntryNameToEntry(JarFile jarFile) throws IOException {
        HashMap<String, JarEntry> entryNameToEntry = new HashMap<String, JarEntry>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            entryNameToEntry.put(name, entry);
        }
        return entryNameToEntry;
    }
}

