/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializer;
import gnu.trove.map.TObjectIntMap;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import org.cf.apkfile.ApkFile;
import org.cf.apkfile.ParseException;
import org.cf.apkfile.apk.JarFileExclusionStrategy;
import org.pmw.tinylog.Configurator;
import org.pmw.tinylog.Level;
import org.pmw.tinylog.writers.FileWriter;

public class Main {
    public static void main(String[] args) throws IOException, ParseException {
        Main.configureLog();
        if (args.length != 1) {
            System.out.println("Usage: main <apk path>");
            System.exit(-1);
        }
        String apkPath = args[0];
        GsonBuilder gsonBuilder = new GsonBuilder();
        JsonSerializer<TObjectIntMap> serializer = (src, typeOfSrc, context) -> {
            JsonObject jsonMerchant = new JsonObject();
            for (Object key : src.keys()) {
                int value = src.get(key);
                jsonMerchant.addProperty(key.toString(), value);
            }
            return jsonMerchant;
        };
        gsonBuilder.registerTypeAdapter((Type)((Object)TObjectIntMap.class), serializer);
        Gson gson = gsonBuilder.disableHtmlEscaping().serializeSpecialFloatingPointValues().setExclusionStrategies(new JarFileExclusionStrategy()).setPrettyPrinting().create();
        OutputStreamWriter writer = new OutputStreamWriter(System.out);
        ApkFile apkFile = new ApkFile(apkPath, true, true, true, true, false);
        gson.toJson((Object)apkFile, (Appendable)writer);
        ((Writer)writer).close();
        apkFile.close();
    }

    private static void configureLog() {
        Configurator.defaultConfig().writer(new FileWriter("log.txt")).level(Level.INFO).activate();
    }
}

