/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.apk;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;

public class Certificate {
    private final Collection<SubjectAndIssuerRdns> allRdns;

    public Certificate(InputStream certStream) throws CMSException {
        this.allRdns = Certificate.extractAll(certStream);
    }

    public Collection<SubjectAndIssuerRdns> getAllRdns() {
        return this.allRdns;
    }

    private static Collection<SubjectAndIssuerRdns> extractAll(InputStream certStream) throws CMSException {
        LinkedList<SubjectAndIssuerRdns> allRdns = new LinkedList<SubjectAndIssuerRdns>();
        CMSSignedData data = new CMSSignedData(certStream);
        Collection matches = data.getCertificates().getMatches(null);
        for (X509CertificateHolder holder : matches) {
            allRdns.add(Certificate.buildRdns(holder.getSubject(), holder.getIssuer()));
        }
        return allRdns;
    }

    private static SubjectAndIssuerRdns buildRdns(X500Name subject, X500Name issuer) {
        Hashtable defaultSymbols = null;
        try {
            Field f = BCStyle.class.getDeclaredField("DefaultSymbols");
            f.setAccessible(true);
            defaultSymbols = (Hashtable)f.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, String> subjectMap = new HashMap<String, String>();
        for (RDN rdn : subject.getRDNs()) {
            for (AttributeTypeAndValue typeAndValue : rdn.getTypesAndValues()) {
                String type = defaultSymbols == null ? typeAndValue.getType().toString() : (String)defaultSymbols.get(typeAndValue.getType());
                subjectMap.put(type, typeAndValue.getValue().toString());
            }
        }
        HashMap<String, String> issuerMap = new HashMap<String, String>();
        for (RDN rdn : subject.getRDNs()) {
            for (AttributeTypeAndValue typeAndValue : rdn.getTypesAndValues()) {
                String type = defaultSymbols == null ? typeAndValue.getType().toString() : (String)defaultSymbols.get(typeAndValue.getType());
                issuerMap.put(type, typeAndValue.getValue().toString());
            }
        }
        return new SubjectAndIssuerRdns(subjectMap, issuerMap);
    }

    public static class SubjectAndIssuerRdns {
        private final Map<String, String> issuerRdns;
        private final Map<String, String> subjectRdns;

        SubjectAndIssuerRdns(Map<String, String> subjectRdns, Map<String, String> issuerRdns) {
            this.subjectRdns = subjectRdns;
            this.issuerRdns = issuerRdns;
        }

        public Map<String, String> getIssuerRdns() {
            return this.issuerRdns;
        }

        public Map<String, String> getSubjectRdns() {
            return this.subjectRdns;
        }

        public String toString() {
            return "SUBJECT: " + Arrays.toString(this.subjectRdns.entrySet().toArray()) + "\nISSUER: " + Arrays.toString(this.issuerRdns.entrySet().toArray());
        }
    }
}

