/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.apk;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.cf.apkfile.res.Chunk;
import org.cf.apkfile.res.ResourceFile;
import org.cf.apkfile.res.ResourceTableChunk;

public class Resources {
    public static final String[] ENTRY_STRING_HEADERS = new String[]{"Configs"};
    public static final String[] ENTRY_NUMERIC_HEADERS = new String[]{"Private Size", "Shared Size", "Proportional Size", "Config Count"};
    public static final String[] CONFIG_STRING_HEADERS = new String[]{"Keys", "MCC", "MNC", "LANGUAGE_STRING", "REGION_STRING", "SCREEN_LAYOUT_DIRECTION", "SMALLEST_SCREEN_WIDTH_DP", "SCREEN_WIDTH_DP", "SCREEN_HEIGHT_DP", "SCREEN_LAYOUT_SIZE", "SCREEN_LAYOUT_LONG", "SCREEN_LAYOUT_ROUND", "ORIENTATION", "UI_MODE_TYPE", "UI_MODE_NIGHT", "DENSITY_DPI", "TOUCHSCREEN", "KEYBOARD_HIDDEN", "KEYBOARD", "NAVIGATION_HIDDEN", "NAVIGATION", "SDK_VERSION"};
    public static final String[] CONFIG_NUMERIC_HEADERS = new String[]{"Size", "Null Entries", "Entry Count", "Density"};
    private final transient ResourceTableChunk resourceTable;
    private final Map<String, Map<String, Object>> entries;
    private final Map<String, Map<String, Object>> resourceConfigs;

    public Resources(InputStream resourcesStream) throws IOException {
        ResourceFile resourceFile = ResourceFile.fromInputStream(resourcesStream);
        Chunk chunk = resourceFile.getChunks().get(0);
        if (!(chunk instanceof ResourceTableChunk)) {
            throw new RuntimeException("Resources file appears to be invalid");
        }
        this.resourceTable = (ResourceTableChunk)chunk;
        this.entries = new HashMap<String, Map<String, Object>>();
        this.resourceConfigs = new HashMap<String, Map<String, Object>>();
    }

    public Map<String, Map<String, Object>> getEntries() {
        return this.entries;
    }

    public Map<String, Map<String, Object>> getResourceConfigs() {
        return this.resourceConfigs;
    }

    public ResourceTableChunk getResourceTable() {
        return this.resourceTable;
    }
}

