/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.dex;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.cf.apkfile.dex.DexMethod;
import org.cf.apkfile.utils.Utils;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedMethod;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.util.ReferenceUtil;
import org.pmw.tinylog.Logger;

public class DexClass {
    private final TObjectIntMap<MethodReference> apiCounts;
    private final TObjectIntMap<String> classAccessors;
    private final transient DexBackedClassDef classDef;
    private final TObjectIntMap<FieldReference> fieldReferenceCounts;
    private final TObjectIntMap<String> methodAccessorCounts;
    private final Map<String, DexMethod> methodSignatureToMethod;
    private final TObjectIntMap<Opcode> opCounts;
    private final TObjectIntMap<StringReference> stringReferenceCounts;
    private final boolean fullMethodSignatures;
    private int annotationCount = 0;
    private double cyclomaticComplexity = 0.0;
    private int debugItemCount = 0;
    private int fieldCount = 0;
    private int instructionCount = 0;
    private int registerCount = 0;
    private int tryCatchCount = 0;
    private int failedMethods = 0;

    public DexClass(DexBackedClassDef classDef) {
        this(classDef, true);
    }

    public DexClass(DexBackedClassDef classDef, boolean fullMethodSignatures) {
        this.fullMethodSignatures = fullMethodSignatures;
        this.classDef = classDef;
        this.methodSignatureToMethod = new HashMap<String, DexMethod>();
        this.opCounts = new TObjectIntHashMap<Opcode>();
        this.apiCounts = new TObjectIntHashMap<MethodReference>();
        this.stringReferenceCounts = new TObjectIntHashMap<StringReference>();
        this.fieldReferenceCounts = new TObjectIntHashMap<FieldReference>();
        this.methodAccessorCounts = new TObjectIntHashMap<String>();
        this.analyze();
        this.classAccessors = DexClass.buildAccessors(classDef.getAccessFlags());
    }

    private void analyze() {
        this.fieldCount = Utils.makeCollection(this.classDef.getFields()).size();
        for (DexBackedMethod dexBackedMethod : this.classDef.getMethods()) {
            DexMethod dexMethod;
            try {
                dexMethod = new DexMethod(dexBackedMethod, this.fullMethodSignatures);
                ++this.failedMethods;
            }
            catch (Exception e) {
                Logger.warn("Failed to analyze method: " + ReferenceUtil.getMethodDescriptor(dexBackedMethod) + "; skipping", e);
                continue;
            }
            String methodDescriptor = ReferenceUtil.getMethodDescriptor(dexBackedMethod);
            String methodSignature = methodDescriptor.split("->", 2)[1];
            this.methodSignatureToMethod.put(methodSignature, dexMethod);
            Utils.rollUp(this.opCounts, dexMethod.getOpCounts());
            Utils.rollUp(this.apiCounts, dexMethod.getApiCounts());
            Utils.rollUp(this.stringReferenceCounts, dexMethod.getStringReferenceCounts());
            Utils.rollUp(this.fieldReferenceCounts, dexMethod.getFieldReferenceCounts());
            Utils.rollUp(this.methodAccessorCounts, dexMethod.getMethodAccessors());
            this.annotationCount += dexMethod.getAnnotationCount();
            this.registerCount += dexMethod.getRegisterCount();
            this.instructionCount += dexMethod.getInstructionCount();
            this.tryCatchCount += dexMethod.getTryCatchCount();
            this.debugItemCount += dexMethod.getDebugItemCount();
            this.cyclomaticComplexity += (double)dexMethod.getCyclomaticComplexity();
        }
        if (!this.methodSignatureToMethod.isEmpty()) {
            this.cyclomaticComplexity /= (double)this.methodSignatureToMethod.size();
        }
    }

    public int getAnnotationCount() {
        return this.annotationCount;
    }

    public TObjectIntMap<MethodReference> getApiCounts() {
        return this.apiCounts;
    }

    public TObjectIntMap<String> getClassAccessors() {
        return this.classAccessors;
    }

    public DexBackedClassDef getClassDef() {
        return this.classDef;
    }

    public double getCyclomaticComplexity() {
        return this.cyclomaticComplexity;
    }

    public int getDebugItemCount() {
        return this.debugItemCount;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public TObjectIntMap<FieldReference> getFieldReferenceCounts() {
        return this.fieldReferenceCounts;
    }

    public int getInstructionCount() {
        return this.instructionCount;
    }

    public DexMethod getMethod(String methodSignature) {
        return this.methodSignatureToMethod.get(methodSignature);
    }

    public TObjectIntMap<String> getMethodAccessorCounts() {
        return this.methodAccessorCounts;
    }

    public Map<String, DexMethod> getMethodSignatureToMethod() {
        return this.methodSignatureToMethod;
    }

    public TObjectIntMap<Opcode> getOpCounts() {
        return this.opCounts;
    }

    public int getRegisterCount() {
        return this.registerCount;
    }

    public TObjectIntMap<StringReference> getStringReferenceCounts() {
        return this.stringReferenceCounts;
    }

    public int getTryCatchCount() {
        return this.tryCatchCount;
    }

    private static TObjectIntMap<String> buildAccessors(int accessFlags) {
        TObjectIntHashMap<String> map = new TObjectIntHashMap<String>();
        map.put("public", Modifier.isPublic(accessFlags) ? 1 : 0);
        map.put("protected", Modifier.isProtected(accessFlags) ? 1 : 0);
        map.put("private", Modifier.isPrivate(accessFlags) ? 1 : 0);
        map.put("final", Modifier.isFinal(accessFlags) ? 1 : 0);
        map.put("interface", Modifier.isInterface(accessFlags) ? 1 : 0);
        map.put("native", Modifier.isNative(accessFlags) ? 1 : 0);
        map.put("static", Modifier.isStatic(accessFlags) ? 1 : 0);
        map.put("strict", Modifier.isStrict(accessFlags) ? 1 : 0);
        map.put("synchronized", Modifier.isSynchronized(accessFlags) ? 1 : 0);
        map.put("transient", Modifier.isTransient(accessFlags) ? 1 : 0);
        map.put("volatile", Modifier.isVolatile(accessFlags) ? 1 : 0);
        map.put("abstract", Modifier.isAbstract(accessFlags) ? 1 : 0);
        return map;
    }

    public int getFailedMethods() {
        return this.failedMethods;
    }
}

