/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.dex;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cf.apkfile.dex.DexClass;
import org.cf.apkfile.dex.DexMethod;
import org.cf.apkfile.utils.Utils;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.util.ReferenceUtil;
import org.pmw.tinylog.Logger;

public class DexFile {
    private static final transient Set<String> localClasses = new HashSet<String>();
    private final TObjectIntMap<MethodReference> apiCounts;
    private final TObjectIntMap<String> classAccessorCounts;
    private final Map<String, DexClass> classPathToClass;
    private final TObjectIntMap<FieldReference> fieldReferenceCounts;
    private final TObjectIntMap<String> methodAccessorCounts;
    private final Map<String, DexMethod> methodDescriptorToMethod;
    private final TObjectIntMap<Opcode> opCounts;
    private final TObjectIntMap<StringReference> stringReferenceCounts;
    private final boolean fullMethodSignatures;
    private int annotationCount = 0;
    private float cyclomaticComplexity = 0.0f;
    private int debugItemCount = 0;
    private int fieldCount = 0;
    private int instructionCount = 0;
    private int registerCount = 0;
    private int tryCatchCount = 0;
    private int failedClasses;
    private final transient DexBackedDexFile dexFile;

    public DexFile(InputStream is) throws IOException {
        this(is, true);
    }

    public DexFile(InputStream is, boolean fullMethodSignatures) throws IOException {
        this.fullMethodSignatures = fullMethodSignatures;
        BufferedInputStream bis = new BufferedInputStream(is);
        this.dexFile = DexBackedDexFile.fromInputStream(Opcodes.forApi(39), bis);
        this.classPathToClass = new HashMap<String, DexClass>();
        this.methodDescriptorToMethod = new HashMap<String, DexMethod>();
        this.opCounts = new TObjectIntHashMap<Opcode>();
        this.apiCounts = new TObjectIntHashMap<MethodReference>();
        this.stringReferenceCounts = new TObjectIntHashMap<StringReference>();
        this.fieldReferenceCounts = new TObjectIntHashMap<FieldReference>();
        this.methodAccessorCounts = new TObjectIntHashMap<String>();
        this.classAccessorCounts = new TObjectIntHashMap<String>();
        DexFile.loadLocalClasses(this.dexFile);
    }

    private static synchronized void loadLocalClasses(DexBackedDexFile dexFile) {
        for (DexBackedClassDef dexBackedClassDef : dexFile.getClasses()) {
            String classPath = dexBackedClassDef.getType();
            localClasses.add(classPath);
        }
    }

    private boolean isLocalNonSupportClass(String classPath) {
        return !classPath.startsWith("Landroid/support/") && localClasses.contains(classPath);
    }

    public void analyze() {
        for (DexBackedClassDef dexBackedClassDef : this.dexFile.getClasses()) {
            DexClass dexClass;
            String classPath = dexBackedClassDef.getType();
            try {
                dexClass = new DexClass(dexBackedClassDef, this.fullMethodSignatures);
                ++this.failedClasses;
            }
            catch (Exception e) {
                Logger.warn("Failed to analyze class: " + dexBackedClassDef.getType() + "; skipping", e);
                continue;
            }
            this.classPathToClass.put(classPath, dexClass);
            for (DexMethod method : dexClass.getMethodSignatureToMethod().values()) {
                String methodDescriptor = ReferenceUtil.getMethodDescriptor(method.getMethod());
                this.methodDescriptorToMethod.put(methodDescriptor, method);
            }
            dexClass.getApiCounts().keySet().removeIf(k -> this.isLocalNonSupportClass(this.getComponentBase(k.getDefiningClass())));
            dexClass.getFieldReferenceCounts().keySet().removeIf(k -> this.isLocalNonSupportClass(this.getComponentBase(k.getDefiningClass())));
            for (DexMethod dexMethod : dexClass.getMethodSignatureToMethod().values()) {
                dexMethod.getApiCounts().keySet().removeIf(k -> this.isLocalNonSupportClass(this.getComponentBase(k.getDefiningClass())));
                dexMethod.getFieldReferenceCounts().keySet().removeIf(k -> this.isLocalNonSupportClass(this.getComponentBase(k.getDefiningClass())));
            }
            Utils.rollUp(this.opCounts, dexClass.getOpCounts());
            Utils.rollUp(this.apiCounts, dexClass.getApiCounts());
            Utils.rollUp(this.stringReferenceCounts, dexClass.getStringReferenceCounts());
            Utils.rollUp(this.fieldReferenceCounts, dexClass.getFieldReferenceCounts());
            Utils.rollUp(this.methodAccessorCounts, dexClass.getMethodAccessorCounts());
            Utils.rollUp(this.classAccessorCounts, dexClass.getClassAccessors());
            this.fieldCount += dexClass.getFieldCount();
            this.annotationCount += dexClass.getAnnotationCount();
            this.registerCount += dexClass.getRegisterCount();
            this.instructionCount += dexClass.getInstructionCount();
            this.tryCatchCount += dexClass.getTryCatchCount();
            this.debugItemCount += dexClass.getDebugItemCount();
            this.cyclomaticComplexity = (float)((double)this.cyclomaticComplexity + dexClass.getCyclomaticComplexity());
        }
        if (!this.classPathToClass.isEmpty()) {
            this.cyclomaticComplexity /= (float)this.classPathToClass.size();
        }
    }

    private String getComponentBase(String classDescriptor) {
        int index = 0;
        while (classDescriptor.charAt(index) == '[') {
            ++index;
        }
        if (index == 0) {
            return classDescriptor;
        }
        return classDescriptor.substring(index);
    }

    public int getAnnotationCount() {
        return this.annotationCount;
    }

    public TObjectIntMap<MethodReference> getApiCounts() {
        return this.apiCounts;
    }

    public DexClass getClass(String classPath) {
        return this.classPathToClass.get(classPath);
    }

    public TObjectIntMap<String> getClassAccessorCounts() {
        return this.classAccessorCounts;
    }

    public Map<String, DexClass> getClassPathToClass() {
        return this.classPathToClass;
    }

    public float getCyclomaticComplexity() {
        return this.cyclomaticComplexity;
    }

    public int getDebugItemCount() {
        return this.debugItemCount;
    }

    public DexBackedDexFile getDexFile() {
        return this.dexFile;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public TObjectIntMap<FieldReference> getFieldReferenceCounts() {
        return this.fieldReferenceCounts;
    }

    public int getInstructionCount() {
        return this.instructionCount;
    }

    public DexMethod getMethod(String methodDescriptor) {
        return this.methodDescriptorToMethod.get(methodDescriptor);
    }

    public TObjectIntMap<String> getMethodAccessorCounts() {
        return this.methodAccessorCounts;
    }

    public Map<String, DexMethod> getMethodDescriptorToMethod() {
        return this.methodDescriptorToMethod;
    }

    public TObjectIntMap<Opcode> getOpCounts() {
        return this.opCounts;
    }

    public int getRegisterCount() {
        return this.registerCount;
    }

    public TObjectIntMap<StringReference> getStringReferenceCounts() {
        return this.stringReferenceCounts;
    }

    public int getTryCatchCount() {
        return this.tryCatchCount;
    }
}

