/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.dex;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.lang.reflect.Modifier;
import javax.annotation.Nonnull;
import org.cf.apkfile.dex.ShortMethodReference;
import org.cf.apkfile.utils.Utils;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.dexbacked.DexBackedMethod;
import org.jf.dexlib2.dexbacked.DexBackedMethodImplementation;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import org.jf.dexlib2.iface.instruction.formats.SparseSwitchPayload;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.StringReference;

public class DexMethod {
    private final TObjectIntMap<MethodReference> apiCounts;
    private final TObjectIntMap<FieldReference> fieldReferenceCounts;
    private final transient DexBackedMethod method;
    private final TObjectIntMap<String> methodAccessors;
    private final TObjectIntMap<Opcode> opCounts;
    private final TObjectIntMap<StringReference> stringReferenceCounts;
    private final boolean fullMethodSignatures;
    private int annotationCount = 0;
    private int cyclomaticComplexity = 0;
    private int debugItemCount = 0;
    private int instructionCount = 0;
    private int registerCount = 0;
    private int tryCatchCount = 0;

    public DexMethod(DexBackedMethod method) {
        this(method, true);
    }

    public DexMethod(DexBackedMethod method, boolean fullMethodSignatures) {
        this.fullMethodSignatures = fullMethodSignatures;
        this.method = method;
        this.opCounts = new TObjectIntHashMap<Opcode>();
        this.apiCounts = new TObjectIntHashMap<MethodReference>();
        this.stringReferenceCounts = new TObjectIntHashMap<StringReference>();
        this.fieldReferenceCounts = new TObjectIntHashMap<FieldReference>();
        this.annotationCount = method.getAnnotations().size();
        if (method.getImplementation() != null) {
            this.analyze(method.getImplementation());
        }
        this.methodAccessors = DexMethod.buildAccessors(method.getAccessFlags());
    }

    private void analyze(@Nonnull DexBackedMethodImplementation implementation) {
        this.cyclomaticComplexity = DexMethod.calculateComplexity(implementation);
        this.registerCount = implementation.getRegisterCount();
        this.tryCatchCount = implementation.getTryBlocks().size();
        this.debugItemCount = Utils.makeCollection(implementation.getDebugItems()).size();
        for (Instruction instruction : implementation.getInstructions()) {
            ++this.instructionCount;
            Opcode op = instruction.getOpcode();
            this.opCounts.adjustOrPutValue(op, 1, 1);
            if (!(instruction instanceof ReferenceInstruction)) continue;
            ReferenceInstruction refInstr = (ReferenceInstruction)instruction;
            switch (op.referenceType) {
                case 3: {
                    MethodReference methodRef = (MethodReference)refInstr.getReference();
                    if (this.fullMethodSignatures) {
                        this.apiCounts.adjustOrPutValue(methodRef, 1, 1);
                        break;
                    }
                    ShortMethodReference shortMethodRef = new ShortMethodReference(methodRef);
                    this.apiCounts.adjustOrPutValue(shortMethodRef, 1, 1);
                    break;
                }
                case 2: {
                    FieldReference fieldRef = (FieldReference)refInstr.getReference();
                    this.fieldReferenceCounts.adjustOrPutValue(fieldRef, 1, 1);
                    break;
                }
                case 0: {
                    StringReference stringRef = (StringReference)refInstr.getReference();
                    this.stringReferenceCounts.adjustOrPutValue(stringRef, 1, 1);
                }
            }
        }
    }

    private static int calculateComplexity(@Nonnull DexBackedMethodImplementation implementation) {
        int branches = 0;
        int exits = 0;
        for (Instruction instruction : implementation.getInstructions()) {
            switch (instruction.getOpcode()) {
                case IF_EQ: 
                case IF_EQZ: 
                case IF_GE: 
                case IF_GEZ: 
                case IF_GT: 
                case IF_GTZ: 
                case IF_LE: 
                case IF_LEZ: 
                case IF_LT: 
                case IF_LTZ: 
                case IF_NE: 
                case IF_NEZ: {
                    branches += 2;
                    break;
                }
                case PACKED_SWITCH_PAYLOAD: {
                    branches += ((PackedSwitchPayload)instruction).getSwitchElements().size();
                    break;
                }
                case RETURN: 
                case RETURN_OBJECT: 
                case RETURN_VOID: 
                case RETURN_VOID_BARRIER: 
                case RETURN_VOID_NO_BARRIER: 
                case RETURN_WIDE: {
                    ++exits;
                    break;
                }
                case SPARSE_SWITCH_PAYLOAD: {
                    branches += ((SparseSwitchPayload)instruction).getSwitchElements().size();
                    break;
                }
                case THROW: 
                case THROW_VERIFICATION_ERROR: {
                    ++exits;
                }
            }
        }
        return branches - exits + 2;
    }

    public int getAnnotationCount() {
        return this.annotationCount;
    }

    public TObjectIntMap<MethodReference> getApiCounts() {
        return this.apiCounts;
    }

    public int getCyclomaticComplexity() {
        return this.cyclomaticComplexity;
    }

    public int getDebugItemCount() {
        return this.debugItemCount;
    }

    public TObjectIntMap<FieldReference> getFieldReferenceCounts() {
        return this.fieldReferenceCounts;
    }

    public int getInstructionCount() {
        return this.instructionCount;
    }

    public DexBackedMethod getMethod() {
        return this.method;
    }

    public TObjectIntMap<String> getMethodAccessors() {
        return this.methodAccessors;
    }

    public TObjectIntMap<Opcode> getOpCounts() {
        return this.opCounts;
    }

    public int getRegisterCount() {
        return this.registerCount;
    }

    public TObjectIntMap<StringReference> getStringReferenceCounts() {
        return this.stringReferenceCounts;
    }

    public int getTryCatchCount() {
        return this.tryCatchCount;
    }

    public String toString() {
        return "";
    }

    private static TObjectIntMap<String> buildAccessors(int accessFlags) {
        TObjectIntHashMap<String> map = new TObjectIntHashMap<String>();
        map.put("public", Modifier.isPublic(accessFlags) ? 1 : 0);
        map.put("protected", Modifier.isProtected(accessFlags) ? 1 : 0);
        map.put("private", Modifier.isPrivate(accessFlags) ? 1 : 0);
        map.put("final", Modifier.isFinal(accessFlags) ? 1 : 0);
        map.put("interface", Modifier.isInterface(accessFlags) ? 1 : 0);
        map.put("native", Modifier.isNative(accessFlags) ? 1 : 0);
        map.put("static", Modifier.isStatic(accessFlags) ? 1 : 0);
        map.put("strict", Modifier.isStrict(accessFlags) ? 1 : 0);
        map.put("synchronized", Modifier.isSynchronized(accessFlags) ? 1 : 0);
        map.put("transient", Modifier.isTransient(accessFlags) ? 1 : 0);
        map.put("volatile", Modifier.isVolatile(accessFlags) ? 1 : 0);
        map.put("abstract", Modifier.isAbstract(accessFlags) ? 1 : 0);
        return map;
    }
}

