/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.dex;

import com.google.common.base.Objects;
import java.util.List;
import javax.annotation.Nonnull;
import org.jf.dexlib2.iface.reference.MethodReference;

public class ShortMethodReference
implements MethodReference {
    private final MethodReference methodRef;
    private final String shortSignature;

    ShortMethodReference(MethodReference methodRef) {
        this.methodRef = methodRef;
        String fullSignature = methodRef.toString();
        int parensIndex = fullSignature.indexOf(40);
        this.shortSignature = fullSignature.substring(0, parensIndex);
    }

    @Override
    @Nonnull
    public String getDefiningClass() {
        return this.methodRef.getDefiningClass();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.methodRef.getName();
    }

    @Override
    @Nonnull
    public List<? extends CharSequence> getParameterTypes() {
        return this.methodRef.getParameterTypes();
    }

    @Override
    @Nonnull
    public String getReturnType() {
        return this.methodRef.getReturnType();
    }

    @Override
    public int compareTo(@Nonnull MethodReference o) {
        String signature = o.toString();
        return this.shortSignature.compareTo(signature);
    }

    public String toString() {
        return this.shortSignature;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ShortMethodReference other = (ShortMethodReference)obj;
        return Objects.equal(this.shortSignature, other.shortSignature);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.shortSignature);
    }
}

