/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.manifest;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.cf.apkfile.manifest.AndroidManifestParsingException;
import org.cf.apkfile.manifest.Application;
import org.cf.apkfile.manifest.Instrumentation;
import org.cf.apkfile.manifest.Permission;
import org.cf.apkfile.manifest.PermissionGroup;
import org.cf.apkfile.manifest.PermissionTree;
import org.cf.apkfile.manifest.Screen;
import org.cf.apkfile.manifest.SupportsScreens;
import org.cf.apkfile.manifest.UsesConfiguration;
import org.cf.apkfile.manifest.UsesFeature;
import org.cf.apkfile.res.AttributeId;
import org.cf.apkfile.res.Chunk;
import org.cf.apkfile.res.ResourceTableChunk;
import org.cf.apkfile.res.XmlChunk;
import org.cf.apkfile.res.XmlStartElementChunk;
import org.pmw.tinylog.Logger;
import org.xmlpull.v1.XmlPullParserException;

public class AndroidManifest {
    private Application application;
    private List<Screen> compatibleScreens;
    private boolean hasResources;
    private int installLocation;
    private List<Instrumentation> instrumentations;
    private int maxSdkVersion;
    private int minSdkVersion;
    private String packageName;
    private List<PermissionGroup> permissionGroups;
    private List<PermissionTree> permissionTrees;
    private List<Permission> permissions;
    private int platformBuildVersionCode;
    private String platformBuildVersionName;
    private String sharedUserId;
    private String sharedUserLabel;
    private List<String> supportsGlTextures;
    private SupportsScreens supportsScreens;
    private int targetSdkVersion;
    private List<UsesConfiguration> usesConfigurations;
    private List<UsesFeature> usesFeatures;
    private List<String> usesPermissions;
    private int versionCode;
    private String versionName;

    public AndroidManifest(InputStream manifestStream) throws AndroidManifestParsingException {
        this.initialize(manifestStream, null);
    }

    public AndroidManifest(InputStream manifestStream, @Nullable ResourceTableChunk resourceTable) throws AndroidManifestParsingException {
        this.initialize(manifestStream, resourceTable);
    }

    public Application getApplication() {
        return this.application;
    }

    public Collection<Screen> getCompatibleScreens() {
        return this.compatibleScreens;
    }

    public int getInstallLocation() {
        return this.installLocation;
    }

    public Collection<Instrumentation> getInstrumentations() {
        return this.instrumentations;
    }

    public int getMaxSdkVersion() {
        return this.maxSdkVersion;
    }

    public int getMinSdkVersion() {
        return this.minSdkVersion;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Collection<PermissionGroup> getPermissionGroups() {
        return this.permissionGroups;
    }

    public Collection<PermissionTree> getPermissionTrees() {
        return this.permissionTrees;
    }

    public Collection<Permission> getPermissions() {
        return this.permissions;
    }

    public int getPlatformBuildVersionCode() {
        return this.platformBuildVersionCode;
    }

    public String getPlatformBuildVersionName() {
        return this.platformBuildVersionName;
    }

    public String getSharedUserId() {
        return this.sharedUserId;
    }

    public String getSharedUserLabel() {
        return this.sharedUserLabel;
    }

    public Collection<String> getSupportsGlTextures() {
        return this.supportsGlTextures;
    }

    public SupportsScreens getSupportsScreens() {
        return this.supportsScreens;
    }

    public int getTargetSdkVersion() {
        return this.targetSdkVersion;
    }

    public Collection<UsesConfiguration> getUsesConfigurations() {
        return this.usesConfigurations;
    }

    public Collection<UsesFeature> getUsesFeatures() {
        return this.usesFeatures;
    }

    public Collection<String> getUsesPermissions() {
        return this.usesPermissions;
    }

    public int getVersionCode() {
        return this.versionCode;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public boolean hasResources() {
        return this.hasResources;
    }

    private void initialize(InputStream manifestStream, @Nullable ResourceTableChunk resourceTable) throws AndroidManifestParsingException {
        this.compatibleScreens = new LinkedList<Screen>();
        this.instrumentations = new LinkedList<Instrumentation>();
        this.permissions = new LinkedList<Permission>();
        this.permissionGroups = new LinkedList<PermissionGroup>();
        this.permissionTrees = new LinkedList<PermissionTree>();
        this.supportsGlTextures = new LinkedList<String>();
        this.usesConfigurations = new LinkedList<UsesConfiguration>();
        this.usesFeatures = new LinkedList<UsesFeature>();
        this.usesPermissions = new LinkedList<String>();
        try {
            this.parse(manifestStream, resourceTable);
        }
        catch (Exception e) {
            throw new AndroidManifestParsingException(e);
        }
    }

    private void parse(InputStream manifestStream, @Nullable ResourceTableChunk resourceTable) throws XmlPullParserException, IOException {
        this.hasResources = resourceTable != null;
        byte[] buf = ByteStreams.toByteArray(manifestStream);
        ByteBuffer buffer = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
        XmlChunk manifest = (XmlChunk)Chunk.newInstance(buffer, resourceTable);
        manifest.setResourceTable(resourceTable);
        for (Chunk c : manifest.getChunks().values()) {
            if (!(c instanceof XmlStartElementChunk)) continue;
            XmlStartElementChunk chunk = (XmlStartElementChunk)c;
            String name = chunk.getName();
            if ("manifest".equals(name)) {
                if (this.packageName != null) {
                    Logger.warn("Multiple manifests elements in AndroidManifest; ignoring");
                    continue;
                }
                this.parsePackageInformation(chunk);
                continue;
            }
            if ("application".equals(name)) {
                this.application = new Application(chunk, manifest, this.packageName);
                continue;
            }
            if ("compatible-screens".equals(name)) {
                this.parseCompatibleScreens(chunk, manifest);
                continue;
            }
            if ("instrumentation".equals(name)) {
                this.instrumentations.add(new Instrumentation(chunk));
                continue;
            }
            if ("permission".equals(name)) {
                this.permissions.add(new Permission(chunk));
                continue;
            }
            if ("permission-group".equals(name)) {
                this.permissionGroups.add(new PermissionGroup(chunk));
                continue;
            }
            if ("permission-tree".equals(name)) {
                this.permissionTrees.add(new PermissionTree(chunk));
                continue;
            }
            if ("supports-screens".equals(name)) {
                this.supportsScreens = new SupportsScreens(chunk);
                continue;
            }
            if ("supports-gl-texture".equals(name)) {
                this.supportsGlTextures.add(chunk.getAttribute(AttributeId.NAME));
                continue;
            }
            if ("uses-configuration".equals(name)) {
                this.usesConfigurations.add(new UsesConfiguration(chunk));
                continue;
            }
            if ("uses-feature".equals(name)) {
                this.usesFeatures.add(new UsesFeature(chunk));
                continue;
            }
            if ("uses-permission".equals(name)) {
                this.usesPermissions.add(chunk.getAttribute(AttributeId.NAME));
                continue;
            }
            if (!"uses-sdk".equals(name)) continue;
            this.parseUsesSdk(chunk);
        }
    }

    private void parseUsesSdk(XmlStartElementChunk usesSdk) {
        String value = usesSdk.getAttribute(AttributeId.MIN_SDK_VERSION);
        if (value != null && !value.isEmpty()) {
            try {
                this.minSdkVersion = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                Logger.warn("Invalid minSdkVersion value: " + value);
            }
        }
        if ((value = usesSdk.getAttribute(AttributeId.TARGET_SDK_VERSION)) != null && !value.isEmpty()) {
            try {
                this.targetSdkVersion = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                Logger.warn("Invalid targetSdkVersion value: " + value);
            }
        }
        if ((value = usesSdk.getAttribute(AttributeId.MAX_SDK_VERSION)) != null && !value.isEmpty()) {
            try {
                this.maxSdkVersion = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                Logger.warn("Invalid maxSdkVersion value: " + value);
            }
        }
    }

    private void parseCompatibleScreens(XmlStartElementChunk screens, XmlChunk manifest) throws XmlPullParserException, IOException {
        List<Chunk> compatibleScreenChunks = manifest.getChunksWithin(screens);
        for (Chunk c : compatibleScreenChunks) {
            XmlStartElementChunk chunk;
            String name;
            if (!(c instanceof XmlStartElementChunk) || !"screen".equals(name = (chunk = (XmlStartElementChunk)c).getName())) continue;
            this.compatibleScreens.add(new Screen(chunk));
        }
    }

    private void parsePackageInformation(XmlStartElementChunk manifest) {
        this.installLocation = manifest.getAttribute(AttributeId.INSTALL_LOCATION, 0);
        this.packageName = manifest.getAttribute("package");
        this.platformBuildVersionCode = manifest.getAttribute("platformBuildVersionCode", -1);
        this.platformBuildVersionName = manifest.getAttribute("platformBuildVersionName");
        this.sharedUserId = manifest.getAttribute(AttributeId.SHARED_USER_ID);
        this.sharedUserLabel = manifest.getAttribute(AttributeId.SHARED_USER_LABEL);
        this.versionCode = manifest.getAttribute(AttributeId.VERSION_CODE, -1);
        this.versionName = manifest.getAttribute(AttributeId.VERSION_NAME);
    }
}

