/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.manifest;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.cf.apkfile.manifest.Activity;
import org.cf.apkfile.manifest.ActivityAlias;
import org.cf.apkfile.manifest.IntentFilter;
import org.cf.apkfile.manifest.Provider;
import org.cf.apkfile.manifest.Receiver;
import org.cf.apkfile.manifest.Service;
import org.cf.apkfile.manifest.UsesLibrary;
import org.cf.apkfile.manifest.Utils;
import org.cf.apkfile.res.AttributeId;
import org.cf.apkfile.res.Chunk;
import org.cf.apkfile.res.XmlChunk;
import org.cf.apkfile.res.XmlStartElementChunk;
import org.xmlpull.v1.XmlPullParserException;

public class Application {
    private final Collection<Activity> activities = new LinkedList<Activity>();
    private final Collection<ActivityAlias> activityAliases = new LinkedList<ActivityAlias>();
    private final boolean allowTaskReparenting;
    private final boolean allowBackup;
    private final String backupAgent;
    private final boolean backupInForeground;
    private final String banner;
    private final boolean debuggable;
    private final String description;
    private final boolean directBootAware;
    private final boolean enabled;
    private final boolean extractNativeLibs;
    private final String fullBackupContent;
    private final boolean fullBackupOnly;
    private final boolean hardwareAccelerated;
    private final boolean hasCode;
    private final String icon;
    private final boolean isGame;
    private final boolean killAfterRestore;
    private final boolean largeHeap;
    private final String label;
    private final String logo;
    private final String manageSpaceActivity;
    private final String name;
    private final String networkSecurityConfig;
    private final String permission;
    private final boolean persistent;
    private final String process;
    private final Collection<Provider> providers;
    private final Collection<Receiver> receivers = new LinkedList<Receiver>();
    private final boolean restoreAnyVersion;
    private final String requiredAccountType;
    private final boolean resizableActivity;
    private final boolean supportsRtl;
    private final Collection<Service> services = new LinkedList<Service>();
    private final String taskAffinity;
    private final String theme;
    private final int uiOptions;
    private final boolean usesCleartextTraffic;
    private final boolean vmSafeMode;
    private final Collection<UsesLibrary> usesLibraries;

    Application(XmlStartElementChunk application, XmlChunk manifest, String packageName) throws XmlPullParserException, IOException {
        this.providers = new LinkedList<Provider>();
        this.usesLibraries = new LinkedList<UsesLibrary>();
        this.allowBackup = application.getAttribute(AttributeId.ALLOW_BACKUP, true);
        this.allowTaskReparenting = application.getAttribute(AttributeId.ALLOW_TASK_REPARENTING, false);
        this.backupAgent = application.getAttribute(AttributeId.BACKUP_AGENT);
        this.backupInForeground = application.getAttribute(AttributeId.BACKUP_IN_FOREGROUND, false);
        this.banner = application.getAttribute(AttributeId.BANNER);
        this.debuggable = application.getAttribute(AttributeId.DEBUGGABLE, false);
        this.description = application.getAttribute(AttributeId.DESCRIPTION);
        this.directBootAware = application.getAttribute(AttributeId.DIRECT_BOOT_AWARE, false);
        this.enabled = application.getAttribute(AttributeId.ENABLED, true);
        this.extractNativeLibs = application.getAttribute(AttributeId.EXTRACT_NATIVE_LIBS, true);
        this.fullBackupContent = application.getAttribute(AttributeId.FULL_BACKUP_CONTENT);
        this.fullBackupOnly = application.getAttribute(AttributeId.FULL_BACKUP_ONLY, false);
        this.hasCode = application.getAttribute(AttributeId.HAS_CODE, true);
        this.hardwareAccelerated = application.getAttribute(AttributeId.HARDWARE_ACCELERATED, true);
        this.icon = application.getAttribute(AttributeId.ICON);
        this.isGame = application.getAttribute(AttributeId.IS_GAME, false);
        this.killAfterRestore = application.getAttribute(AttributeId.KILL_AFTER_RESTORE, true);
        this.largeHeap = application.getAttribute(AttributeId.LARGE_HEAP, false);
        this.label = application.getAttribute(AttributeId.LABEL);
        this.logo = application.getAttribute(AttributeId.LOGO);
        this.manageSpaceActivity = application.getAttribute(AttributeId.MANAGE_SPACE_ACTIVITY);
        String appName = application.getAttribute(AttributeId.NAME);
        this.name = Utils.ensureFullName(appName, packageName);
        this.networkSecurityConfig = application.getAttribute(AttributeId.NETWORK_SECURITY_CONFIG);
        this.permission = application.getAttribute(AttributeId.PERMISSION);
        this.persistent = application.getAttribute(AttributeId.PERSISTENT, false);
        this.process = application.getAttribute(AttributeId.PROCESS);
        this.restoreAnyVersion = application.getAttribute(AttributeId.RESTORE_ANY_VERSION, false);
        this.requiredAccountType = application.getAttribute(AttributeId.REQUIRED_ACCOUNT_TYPE);
        this.resizableActivity = application.getAttribute(AttributeId.RESIZEABLE_ACTIVITY, false);
        this.supportsRtl = application.getAttribute(AttributeId.SUPPORTS_RTL, false);
        this.taskAffinity = application.getAttribute(AttributeId.TASK_AFFINITY);
        this.theme = application.getAttribute(AttributeId.THEME);
        this.uiOptions = application.getAttribute(AttributeId.UI_OPTIONS, 0);
        this.usesCleartextTraffic = application.getAttribute(AttributeId.USES_CLEARTEXT_TRAFFIC, true);
        this.vmSafeMode = application.getAttribute(AttributeId.VM_SAFE_MODE, false);
        List<Chunk> applicationChunks = manifest.getChunksWithin(application);
        for (Chunk c : applicationChunks) {
            if (!(c instanceof XmlStartElementChunk)) continue;
            XmlStartElementChunk chunk = (XmlStartElementChunk)c;
            String name = chunk.getName();
            if ("activity".equals(name)) {
                this.activities.add(new Activity(chunk, manifest, packageName));
                continue;
            }
            if ("activity-alias".equals(name)) {
                this.activityAliases.add(new ActivityAlias(chunk, manifest, packageName));
                continue;
            }
            if ("provider".equals(name)) {
                this.providers.add(new Provider(chunk, manifest, packageName));
                continue;
            }
            if ("receiver".equals(name)) {
                this.receivers.add(new Receiver(chunk, manifest, packageName));
                continue;
            }
            if ("service".equals(name)) {
                this.services.add(new Service(chunk, manifest, packageName));
                continue;
            }
            if (!"uses-library".equals(name)) continue;
            this.usesLibraries.add(new UsesLibrary(chunk));
        }
    }

    public Collection<Activity> getActivities() {
        return this.activities;
    }

    public Collection<ActivityAlias> getActivityAliases() {
        return this.activityAliases;
    }

    public String getBackupAgent() {
        return this.backupAgent;
    }

    public String getBanner() {
        return this.banner;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLogo() {
        return this.logo;
    }

    @Nullable
    public Activity getMainLauncher() {
        Activity mainLauncher = null;
        block0: for (Activity activity : this.activities) {
            boolean hasMain = false;
            boolean hasLauncher = false;
            for (IntentFilter intentFilter : activity.getIntentFilters()) {
                if (intentFilter.getActions().contains("android.intent.action.MAIN")) {
                    hasMain = true;
                }
                if (intentFilter.getCategories().contains("android.intent.category.LAUNCHER")) {
                    hasLauncher = true;
                }
                if (!hasMain || !hasLauncher) continue;
                mainLauncher = activity;
                break block0;
            }
        }
        return mainLauncher;
    }

    public String getManageSpaceActivity() {
        return this.manageSpaceActivity;
    }

    public String getName() {
        return this.name;
    }

    public String getPermission() {
        return this.permission;
    }

    public String getProcess() {
        return this.process;
    }

    public Collection<Provider> getProviders() {
        return this.providers;
    }

    public Collection<Receiver> getReceivers() {
        return this.receivers;
    }

    public Collection<Service> getServices() {
        return this.services;
    }

    public String getTaskAffinity() {
        return this.taskAffinity;
    }

    public String getTheme() {
        return this.theme;
    }

    public Collection<UsesLibrary> getUsesLibraries() {
        return this.usesLibraries;
    }

    public boolean isAllowBackup() {
        return this.allowBackup;
    }

    public boolean isAllowTaskReparenting() {
        return this.allowTaskReparenting;
    }

    public boolean isBackupInForeground() {
        return this.backupInForeground;
    }

    public boolean isDebuggable() {
        return this.debuggable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isExtractNativeLibs() {
        return this.extractNativeLibs;
    }

    public boolean isGame() {
        return this.isGame;
    }

    public boolean isHardwareAccelerated() {
        return this.hardwareAccelerated;
    }

    public boolean isHasCode() {
        return this.hasCode;
    }

    public boolean isKillAfterRestore() {
        return this.killAfterRestore;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public boolean isRestoreAnyVersion() {
        return this.restoreAnyVersion;
    }

    public boolean isDirectBootAware() {
        return this.directBootAware;
    }

    public String getNetworkSecurityConfig() {
        return this.networkSecurityConfig;
    }

    public boolean isLargeHeap() {
        return this.largeHeap;
    }

    public boolean isVmSafeMode() {
        return this.vmSafeMode;
    }

    public boolean isUsesCleartextTraffic() {
        return this.usesCleartextTraffic;
    }

    public int getUiOptions() {
        return this.uiOptions;
    }

    public boolean isResizableActivity() {
        return this.resizableActivity;
    }

    public String getRequiredAccountType() {
        return this.requiredAccountType;
    }

    public boolean isSupportsRtl() {
        return this.supportsRtl;
    }
}

