/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.manifest;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.cf.apkfile.manifest.IntentFilter;
import org.cf.apkfile.manifest.Metadata;
import org.cf.apkfile.manifest.Utils;
import org.cf.apkfile.res.AttributeId;
import org.cf.apkfile.res.Chunk;
import org.cf.apkfile.res.XmlChunk;
import org.cf.apkfile.res.XmlStartElementChunk;
import org.xmlpull.v1.XmlPullParserException;

public abstract class Component {
    private final Collection<IntentFilter> intentFilters = new LinkedList<IntentFilter>();
    private final Collection<Metadata> metaData = new LinkedList<Metadata>();
    private boolean directBootAware;
    private boolean enabled;
    private boolean exported;
    private String icon;
    private String label;
    private String name;
    private String permission;
    private String process;

    Component() throws XmlPullParserException, IOException {
    }

    public final String getIcon() {
        return this.icon;
    }

    public final Collection<IntentFilter> getIntentFilters() {
        return this.intentFilters;
    }

    public final String getLabel() {
        return this.label;
    }

    public final Collection<Metadata> getMetaData() {
        return this.metaData;
    }

    public final String getName() {
        return this.name;
    }

    public final String getPermission() {
        return this.permission;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final boolean isExported() {
        return this.exported;
    }

    protected void parse(XmlStartElementChunk component, XmlChunk manifest, String packageName) throws XmlPullParserException, IOException {
        this.directBootAware = component.getAttribute(AttributeId.DIRECT_BOOT_AWARE, false);
        String componentName = component.getAttribute(AttributeId.NAME);
        this.name = Utils.ensureFullName(componentName, packageName);
        this.permission = component.getAttribute(AttributeId.PERMISSION);
        this.label = component.getAttribute(AttributeId.LABEL);
        this.icon = component.getAttribute(AttributeId.ICON);
        this.exported = component.getAttribute(AttributeId.EXPORTED, false);
        this.enabled = component.getAttribute(AttributeId.ENABLED, true);
        this.process = component.getAttribute(AttributeId.PROCESS);
        List<Chunk> componentChunks = manifest.getChunksWithin(component);
        for (Chunk c : componentChunks) {
            if (!(c instanceof XmlStartElementChunk)) continue;
            XmlStartElementChunk chunk = (XmlStartElementChunk)c;
            String name = chunk.getName();
            if ("intent-filter".equals(name)) {
                this.intentFilters.add(new IntentFilter(chunk, manifest));
                continue;
            }
            if ("meta-data".equals(name)) {
                this.metaData.add(new Metadata(chunk));
                continue;
            }
            this.parseUnknown(chunk, manifest);
        }
    }

    protected void parseUnknown(XmlStartElementChunk chunk, XmlChunk manifest) throws XmlPullParserException, IOException {
    }

    public final String getProcess() {
        return this.process;
    }

    public final boolean isDirectBootAware() {
        return this.directBootAware;
    }
}

