/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.manifest;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.cf.apkfile.manifest.Data;
import org.cf.apkfile.res.AttributeId;
import org.cf.apkfile.res.Chunk;
import org.cf.apkfile.res.XmlChunk;
import org.cf.apkfile.res.XmlStartElementChunk;
import org.xmlpull.v1.XmlPullParserException;

public class IntentFilter {
    private final List<String> actions = new LinkedList<String>();
    private final List<String> categories = new LinkedList<String>();
    private final List<Data> data = new LinkedList<Data>();
    private final String icon;
    private final String label;
    private final int priority;

    IntentFilter(XmlStartElementChunk intent, XmlChunk manifest) throws XmlPullParserException, IOException {
        this.icon = intent.getAttribute(AttributeId.ICON);
        this.label = intent.getAttribute(AttributeId.LABEL);
        this.priority = intent.getAttribute(AttributeId.PRIORITY, 0);
        List<Chunk> componentChunks = manifest.getChunksWithin(intent);
        for (Chunk c : componentChunks) {
            if (!(c instanceof XmlStartElementChunk)) continue;
            XmlStartElementChunk chunk = (XmlStartElementChunk)c;
            String name = chunk.getName();
            if ("action".equals(name)) {
                this.actions.add(chunk.getAttribute(AttributeId.NAME));
                continue;
            }
            if ("category".equals(name)) {
                this.categories.add(chunk.getAttribute(AttributeId.NAME));
                continue;
            }
            if (!"data".equals(name)) continue;
            this.data.add(new Data(chunk));
        }
    }

    public final Collection<String> getActions() {
        return this.actions;
    }

    public final Collection<String> getCategories() {
        return this.categories;
    }

    public final Collection<Data> getData() {
        return this.data;
    }

    public final String getIcon() {
        return this.icon;
    }

    public final String getLabel() {
        return this.label;
    }

    public final int getPriority() {
        return this.priority;
    }
}

