/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.manifest;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.cf.apkfile.manifest.Component;
import org.cf.apkfile.manifest.GrantUriPermission;
import org.cf.apkfile.res.AttributeId;
import org.cf.apkfile.res.XmlChunk;
import org.cf.apkfile.res.XmlStartElementChunk;
import org.xmlpull.v1.XmlPullParserException;

public class Provider
extends Component {
    private final String authorities;
    private final Collection<GrantUriPermission> grantUriPermissionList = new LinkedList<GrantUriPermission>();
    private final boolean grantUriPermissions;
    private final int initOrder;
    private final boolean multiprocess;
    private final String readPermission;
    private final boolean syncable;
    private final String writePermission;

    Provider(XmlStartElementChunk provider, XmlChunk manifest, String packageName) throws XmlPullParserException, IOException {
        this.authorities = provider.getAttribute(AttributeId.AUTHORITIES);
        this.grantUriPermissions = provider.getAttribute(AttributeId.GRANT_URI_PERMISSIONS, false);
        this.initOrder = provider.getAttribute(AttributeId.INIT_ORDER, 0);
        this.multiprocess = provider.getAttribute(AttributeId.MULTIPROCESS, false);
        this.readPermission = provider.getAttribute(AttributeId.READ_PERMISSION);
        this.syncable = provider.getAttribute(AttributeId.SYNCABLE, false);
        this.writePermission = provider.getAttribute(AttributeId.WRITE_PERMISSION);
        this.parse(provider, manifest, packageName);
    }

    public final String getAuthorities() {
        return this.authorities;
    }

    public final Collection<GrantUriPermission> getGrantUriPermissionList() {
        return this.grantUriPermissionList;
    }

    public final int getInitOrder() {
        return this.initOrder;
    }

    public final String getReadPermission() {
        return this.readPermission;
    }

    public final String getWritePermission() {
        return this.writePermission;
    }

    @Override
    protected void parseUnknown(XmlStartElementChunk chunk, XmlChunk manifest) throws XmlPullParserException, IOException {
        String name = chunk.getName();
        if ("grant-uri-permission".equals(name)) {
            this.grantUriPermissionList.add(new GrantUriPermission(chunk));
        }
    }

    public final boolean isGrantUriPermissions() {
        return this.grantUriPermissions;
    }

    public final boolean isMultiprocess() {
        return this.multiprocess;
    }

    public final boolean isSyncable() {
        return this.syncable;
    }
}

