/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.res;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.LittleEndianDataOutputStream;
import com.google.common.primitives.Shorts;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import javax.annotation.Nullable;
import org.cf.apkfile.res.LibraryChunk;
import org.cf.apkfile.res.PackageChunk;
import org.cf.apkfile.res.ResourceTableChunk;
import org.cf.apkfile.res.SerializableResource;
import org.cf.apkfile.res.StringPoolChunk;
import org.cf.apkfile.res.TypeChunk;
import org.cf.apkfile.res.TypeSpecChunk;
import org.cf.apkfile.res.UnknownChunk;
import org.cf.apkfile.res.XmlCdataChunk;
import org.cf.apkfile.res.XmlChunk;
import org.cf.apkfile.res.XmlEndElementChunk;
import org.cf.apkfile.res.XmlNamespaceEndChunk;
import org.cf.apkfile.res.XmlNamespaceStartChunk;
import org.cf.apkfile.res.XmlResourceMapChunk;
import org.cf.apkfile.res.XmlStartElementChunk;

public abstract class Chunk
implements SerializableResource {
    public static final int PAD_BOUNDARY = 4;
    public static final int METADATA_SIZE = 8;
    protected final int headerSize;
    protected final int chunkSize;
    protected final int offset;
    @Nullable
    private final Chunk parent;
    private ResourceTableChunk resourceTable = null;

    protected Chunk(ByteBuffer buffer, @Nullable Chunk parent) {
        this.parent = parent;
        this.offset = buffer.position() - 2;
        this.headerSize = buffer.getShort() & 0xFFFF;
        this.chunkSize = buffer.getInt();
    }

    public static Chunk newInstance(ByteBuffer buffer) {
        return Chunk.newInstance(buffer, null);
    }

    public static Chunk newInstance(ByteBuffer buffer, @Nullable Chunk parent) {
        Chunk result;
        Type type = Type.fromCode(buffer.getShort());
        switch (type) {
            case STRING_POOL: {
                result = new StringPoolChunk(buffer, parent);
                break;
            }
            case TABLE: {
                result = new ResourceTableChunk(buffer, parent);
                break;
            }
            case XML: {
                result = new XmlChunk(buffer, parent);
                break;
            }
            case XML_START_NAMESPACE: {
                result = new XmlNamespaceStartChunk(buffer, parent);
                break;
            }
            case XML_END_NAMESPACE: {
                result = new XmlNamespaceEndChunk(buffer, parent);
                break;
            }
            case XML_START_ELEMENT: {
                result = new XmlStartElementChunk(buffer, parent);
                break;
            }
            case XML_END_ELEMENT: {
                result = new XmlEndElementChunk(buffer, parent);
                break;
            }
            case XML_CDATA: {
                result = new XmlCdataChunk(buffer, parent);
                break;
            }
            case XML_RESOURCE_MAP: {
                result = new XmlResourceMapChunk(buffer, parent);
                break;
            }
            case TABLE_PACKAGE: {
                result = new PackageChunk(buffer, parent);
                break;
            }
            case TABLE_TYPE: {
                result = new TypeChunk(buffer, parent);
                break;
            }
            case TABLE_TYPE_SPEC: {
                result = new TypeSpecChunk(buffer, parent);
                break;
            }
            case TABLE_LIBRARY: {
                result = new LibraryChunk(buffer, parent);
                break;
            }
            default: {
                result = new UnknownChunk(buffer, parent);
            }
        }
        result.init(buffer);
        result.seekToEndOfChunk(buffer);
        return result;
    }

    protected void init(ByteBuffer buffer) {
    }

    @Nullable
    public Chunk getParent() {
        return this.parent;
    }

    protected abstract Type getType();

    public final int getHeaderSize() {
        return this.headerSize;
    }

    public int getOriginalChunkSize() {
        return this.chunkSize;
    }

    private final void seekToEndOfChunk(ByteBuffer buffer) {
        buffer.position(this.offset + this.getOriginalChunkSize());
    }

    protected final void writeHeader(ByteBuffer output, int chunkSize) {
        int start = output.position();
        output.putShort(this.getType().code());
        output.putShort((short)this.headerSize);
        output.putInt(chunkSize);
        this.writeHeader(output);
        int headerBytes = output.position() - start;
        Preconditions.checkState(headerBytes == this.getHeaderSize(), "Written header is wrong size. Got %s, want %s", headerBytes, this.getHeaderSize());
    }

    protected void writeHeader(ByteBuffer output) {
    }

    protected void writePayload(DataOutput output, ByteBuffer header, boolean shrink) throws IOException {
    }

    protected int writePad(DataOutput output, int currentLength) throws IOException {
        while (currentLength % 4 != 0) {
            output.write(0);
            ++currentLength;
        }
        return currentLength;
    }

    @Override
    public final byte[] toByteArray() throws IOException {
        return this.toByteArray(false);
    }

    @Override
    public final byte[] toByteArray(boolean shrink) throws IOException {
        ByteBuffer header = ByteBuffer.allocate(this.getHeaderSize()).order(ByteOrder.LITTLE_ENDIAN);
        this.writeHeader(header, 0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (LittleEndianDataOutputStream payload = new LittleEndianDataOutputStream(baos);){
            this.writePayload(payload, header, shrink);
        }
        byte[] payloadBytes = baos.toByteArray();
        int chunkSize = this.getHeaderSize() + payloadBytes.length;
        header.putInt(4, chunkSize);
        ByteBuffer result = ByteBuffer.allocate(chunkSize).order(ByteOrder.LITTLE_ENDIAN);
        result.put(header.array());
        result.put(payloadBytes);
        return result.array();
    }

    public void setResourceTable(ResourceTableChunk resourceTable) {
        this.resourceTable = resourceTable;
    }

    @Nullable
    protected ResourceTableChunk getResourceTable() {
        if (this.resourceTable != null) {
            return this.resourceTable;
        }
        if (this.getParent() != null) {
            return this.getParent().getResourceTable();
        }
        return null;
    }

    public static enum Type {
        NULL(0),
        STRING_POOL(1),
        TABLE(2),
        XML(3),
        XML_START_NAMESPACE(256),
        XML_END_NAMESPACE(257),
        XML_START_ELEMENT(258),
        XML_END_ELEMENT(259),
        XML_CDATA(260),
        XML_LAST_CHUNK_TYPE(383),
        XML_RESOURCE_MAP(384),
        TABLE_PACKAGE(512),
        TABLE_TYPE(513),
        TABLE_TYPE_SPEC(514),
        TABLE_LIBRARY(515),
        UNKNOWN(Short.MIN_VALUE);

        private static final Map<Short, Type> FROM_SHORT;
        private final short code;

        private Type(int code) {
            this.code = Shorts.checkedCast(code);
        }

        public static Type fromCode(short code) {
            Type type = FROM_SHORT.get(code);
            if (type == null) {
                type = UNKNOWN;
            }
            return type;
        }

        public short code() {
            return this.code;
        }

        static {
            ImmutableMap.Builder<Short, Type> builder = ImmutableMap.builder();
            for (Type type : Type.values()) {
                builder.put(type.code(), type);
            }
            FROM_SHORT = builder.build();
        }
    }
}

