/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.res;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedBytes;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cf.apkfile.res.AutoValue_ResourceConfiguration;
import org.cf.apkfile.res.SerializableResource;

public abstract class ResourceConfiguration
implements SerializableResource {
    private static final Map<Integer, String> DENSITY_DPI_VALUES = ImmutableMap.builder().put(0, "").put(120, "ldpi").put(160, "mdpi").put(213, "tvdpi").put(240, "hdpi").put(320, "xhdpi").put(480, "xxhdpi").put(640, "xxxhdpi").put(65534, "anydpi").put(65535, "nodpi").build();
    private static final Map<Integer, String> KEYBOARD_VALUES = ImmutableMap.of(1, "nokeys", 2, "qwerty", 3, "12key");
    private static final Map<Integer, String> KEYBOARDHIDDEN_VALUES = ImmutableMap.of(1, "keysexposed", 2, "keyshidden", 3, "keyssoft");
    private static final Map<Integer, String> NAVIGATION_VALUES = ImmutableMap.of(1, "nonav", 2, "dpad", 3, "trackball", 4, "wheel");
    private static final Map<Integer, String> NAVIGATIONHIDDEN_VALUES = ImmutableMap.of(4, "navexposed", 8, "navhidden");
    private static final Map<Integer, String> ORIENTATION_VALUES = ImmutableMap.of(1, "port", 2, "land");
    private static final Map<Integer, String> SCREENLAYOUT_LAYOUTDIR_VALUES = ImmutableMap.of(64, "ldltr", 128, "ldrtl");
    private static final Map<Integer, String> SCREENLAYOUT_LONG_VALUES = ImmutableMap.of(16, "notlong", 32, "long");
    private static final Map<Integer, String> SCREENLAYOUT_ROUND_VALUES = ImmutableMap.of(256, "notround", 512, "round");
    private static final Map<Integer, String> SCREENLAYOUT_SIZE_VALUES = ImmutableMap.of(1, "small", 2, "normal", 3, "large", 4, "xlarge");
    private static final Map<Integer, String> TOUCHSCREEN_VALUES = ImmutableMap.of(1, "notouch", 3, "finger");
    private static final Map<Integer, String> UI_MODE_NIGHT_VALUES = ImmutableMap.of(16, "notnight", 32, "night");
    private static final Map<Integer, String> UI_MODE_TYPE_VALUES = ImmutableMap.of(2, "desk", 3, "car", 4, "television", 5, "appliance", 6, "watch");

    static ResourceConfiguration create(ByteBuffer buffer) {
        int startPosition = buffer.position();
        int size = buffer.getInt();
        int mcc = buffer.getShort() & 0xFFFF;
        int mnc = buffer.getShort() & 0xFFFF;
        byte[] language = new byte[2];
        buffer.get(language);
        byte[] region = new byte[2];
        buffer.get(region);
        int orientation = UnsignedBytes.toInt(buffer.get());
        int touchscreen = UnsignedBytes.toInt(buffer.get());
        int density = buffer.getShort() & 0xFFFF;
        int keyboard = UnsignedBytes.toInt(buffer.get());
        int navigation = UnsignedBytes.toInt(buffer.get());
        int inputFlags = UnsignedBytes.toInt(buffer.get());
        buffer.get();
        int screenWidth = buffer.getShort() & 0xFFFF;
        int screenHeight = buffer.getShort() & 0xFFFF;
        int sdkVersion = buffer.getShort() & 0xFFFF;
        int minorVersion = buffer.getShort() & 0xFFFF;
        int screenLayout = 0;
        int uiMode = 0;
        int smallestScreenWidthDp = 0;
        int screenWidthDp = 0;
        int screenHeightDp = 0;
        byte[] localeScript = new byte[4];
        byte[] localeVariant = new byte[8];
        int screenLayout2 = 0;
        if (size >= 32) {
            screenLayout = UnsignedBytes.toInt(buffer.get());
            uiMode = UnsignedBytes.toInt(buffer.get());
            smallestScreenWidthDp = buffer.getShort() & 0xFFFF;
        }
        if (size >= 36) {
            screenWidthDp = buffer.getShort() & 0xFFFF;
            screenHeightDp = buffer.getShort() & 0xFFFF;
        }
        if (size >= 48) {
            buffer.get(localeScript);
            buffer.get(localeVariant);
        }
        if (size >= 52) {
            screenLayout2 = UnsignedBytes.toInt(buffer.get());
            buffer.get();
            buffer.getShort();
        }
        int bytesRead = buffer.position() - startPosition;
        byte[] unknown = new byte[size - bytesRead];
        buffer.get(unknown);
        return new AutoValue_ResourceConfiguration(size, mcc, mnc, language, region, orientation, touchscreen, density, keyboard, navigation, inputFlags, screenWidth, screenHeight, sdkVersion, minorVersion, screenLayout, uiMode, smallestScreenWidthDp, screenWidthDp, screenHeightDp, localeScript, localeVariant, screenLayout2, unknown);
    }

    public abstract int size();

    public abstract int mcc();

    public abstract int mnc();

    public abstract byte[] language();

    public final String languageString() {
        return this.unpackLanguage();
    }

    public abstract byte[] region();

    public final String regionString() {
        return this.unpackRegion();
    }

    public abstract int orientation();

    public abstract int touchscreen();

    public abstract int density();

    public abstract int keyboard();

    public abstract int navigation();

    public abstract int inputFlags();

    public final int keyboardHidden() {
        return this.inputFlags() & 3;
    }

    public final int navigationHidden() {
        return this.inputFlags() & 0xC;
    }

    public abstract int screenWidth();

    public abstract int screenHeight();

    public abstract int sdkVersion();

    public final ResourceConfiguration withSdkVersion(int sdkVersion) {
        if (sdkVersion == this.sdkVersion()) {
            return this;
        }
        return new AutoValue_ResourceConfiguration(this.size(), this.mcc(), this.mnc(), this.language(), this.region(), this.orientation(), this.touchscreen(), this.density(), this.keyboard(), this.navigation(), this.inputFlags(), this.screenWidth(), this.screenHeight(), sdkVersion, this.minorVersion(), this.screenLayout(), this.uiMode(), this.smallestScreenWidthDp(), this.screenWidthDp(), this.screenHeightDp(), this.localeScript(), this.localeVariant(), this.screenLayout2(), this.unknown());
    }

    public abstract int minorVersion();

    public abstract int screenLayout();

    public final int screenLayoutDirection() {
        return this.screenLayout() & 0xC0;
    }

    public final int screenLayoutSize() {
        return this.screenLayout() & 0xF;
    }

    public final int screenLayoutLong() {
        return this.screenLayout() & 0x30;
    }

    public final int screenLayoutRound() {
        return this.screenLayout() & 0x300;
    }

    public abstract int uiMode();

    public final int uiModeType() {
        return this.uiMode() & 0xF;
    }

    public final int uiModeNight() {
        return this.uiMode() & 0x30;
    }

    public abstract int smallestScreenWidthDp();

    public abstract int screenWidthDp();

    public abstract int screenHeightDp();

    public abstract byte[] localeScript();

    public abstract byte[] localeVariant();

    public abstract int screenLayout2();

    public abstract byte[] unknown();

    private String unpackLanguage() {
        return this.unpackLanguageOrRegion(this.language(), 97);
    }

    private String unpackRegion() {
        return this.unpackLanguageOrRegion(this.region(), 48);
    }

    private String unpackLanguageOrRegion(byte[] value, int base) {
        Preconditions.checkState(value.length == 2, "Language or region value must be 2 bytes.");
        if (value[0] == 0 && value[1] == 0) {
            return "";
        }
        if ((UnsignedBytes.toInt(value[0]) & 0x80) != 0) {
            byte[] result = new byte[]{(byte)(base + (value[1] & 0x1F)), (byte)(base + ((value[1] & 0xE0) >>> 5) + ((value[0] & 3) << 3)), (byte)(base + ((value[0] & 0x7C) >>> 2))};
            return new String(result, StandardCharsets.US_ASCII);
        }
        return new String(value, StandardCharsets.US_ASCII);
    }

    public final boolean isDefault() {
        return this.mcc() == 0 && this.mnc() == 0 && Arrays.equals(this.language(), new byte[2]) && Arrays.equals(this.region(), new byte[2]) && this.orientation() == 0 && this.touchscreen() == 0 && this.density() == 0 && this.keyboard() == 0 && this.navigation() == 0 && this.inputFlags() == 0 && this.screenWidth() == 0 && this.screenHeight() == 0 && this.sdkVersion() == 0 && this.minorVersion() == 0 && this.screenLayout() == 0 && this.uiMode() == 0 && this.smallestScreenWidthDp() == 0 && this.screenWidthDp() == 0 && this.screenHeightDp() == 0 && Arrays.equals(this.localeScript(), new byte[4]) && Arrays.equals(this.localeVariant(), new byte[8]) && this.screenLayout2() == 0;
    }

    @Override
    public final byte[] toByteArray() {
        return this.toByteArray(false);
    }

    @Override
    public final byte[] toByteArray(boolean shrink) {
        ByteBuffer buffer = ByteBuffer.allocate(this.size()).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(this.size());
        buffer.putShort((short)this.mcc());
        buffer.putShort((short)this.mnc());
        buffer.put(this.language());
        buffer.put(this.region());
        buffer.put((byte)this.orientation());
        buffer.put((byte)this.touchscreen());
        buffer.putShort((short)this.density());
        buffer.put((byte)this.keyboard());
        buffer.put((byte)this.navigation());
        buffer.put((byte)this.inputFlags());
        buffer.put((byte)0);
        buffer.putShort((short)this.screenWidth());
        buffer.putShort((short)this.screenHeight());
        buffer.putShort((short)this.sdkVersion());
        buffer.putShort((short)this.minorVersion());
        if (this.size() >= 32) {
            buffer.put((byte)this.screenLayout());
            buffer.put((byte)this.uiMode());
            buffer.putShort((short)this.smallestScreenWidthDp());
        }
        if (this.size() >= 36) {
            buffer.putShort((short)this.screenWidthDp());
            buffer.putShort((short)this.screenHeightDp());
        }
        if (this.size() >= 48) {
            buffer.put(this.localeScript());
            buffer.put(this.localeVariant());
        }
        if (this.size() >= 52) {
            buffer.putInt(this.screenLayout2());
        }
        buffer.put(this.unknown());
        return buffer.array();
    }

    public final String toString() {
        if (this.isDefault()) {
            return "default";
        }
        Collection<String> parts = this.toStringParts().values();
        parts.removeAll(Collections.singleton(""));
        return Joiner.on('-').join(parts);
    }

    public final Map<Type, String> toStringParts() {
        LinkedHashMap<Type, String> result = new LinkedHashMap<Type, String>();
        result.put(Type.MCC, this.mcc() != 0 ? "mcc" + this.mcc() : "");
        result.put(Type.MNC, this.mnc() != 0 ? "mnc" + this.mnc() : "");
        result.put(Type.LANGUAGE_STRING, !this.languageString().isEmpty() ? "" + this.languageString() : "");
        result.put(Type.REGION_STRING, !this.regionString().isEmpty() ? "r" + this.regionString() : "");
        result.put(Type.SCREEN_LAYOUT_DIRECTION, this.getOrDefault(SCREENLAYOUT_LAYOUTDIR_VALUES, this.screenLayoutDirection(), ""));
        result.put(Type.SMALLEST_SCREEN_WIDTH_DP, this.smallestScreenWidthDp() != 0 ? "sw" + this.smallestScreenWidthDp() + "dp" : "");
        result.put(Type.SCREEN_WIDTH_DP, this.screenWidthDp() != 0 ? "w" + this.screenWidthDp() + "dp" : "");
        result.put(Type.SCREEN_HEIGHT_DP, this.screenHeightDp() != 0 ? "h" + this.screenHeightDp() + "dp" : "");
        result.put(Type.SCREEN_LAYOUT_SIZE, this.getOrDefault(SCREENLAYOUT_SIZE_VALUES, this.screenLayoutSize(), ""));
        result.put(Type.SCREEN_LAYOUT_LONG, this.getOrDefault(SCREENLAYOUT_LONG_VALUES, this.screenLayoutLong(), ""));
        result.put(Type.SCREEN_LAYOUT_ROUND, this.getOrDefault(SCREENLAYOUT_ROUND_VALUES, this.screenLayoutRound(), ""));
        result.put(Type.ORIENTATION, this.getOrDefault(ORIENTATION_VALUES, this.orientation(), ""));
        result.put(Type.UI_MODE_TYPE, this.getOrDefault(UI_MODE_TYPE_VALUES, this.uiModeType(), ""));
        result.put(Type.UI_MODE_NIGHT, this.getOrDefault(UI_MODE_NIGHT_VALUES, this.uiModeNight(), ""));
        result.put(Type.DENSITY_DPI, this.getOrDefault(DENSITY_DPI_VALUES, this.density(), this.density() + "dpi"));
        result.put(Type.TOUCHSCREEN, this.getOrDefault(TOUCHSCREEN_VALUES, this.touchscreen(), ""));
        result.put(Type.KEYBOARD_HIDDEN, this.getOrDefault(KEYBOARDHIDDEN_VALUES, this.keyboardHidden(), ""));
        result.put(Type.KEYBOARD, this.getOrDefault(KEYBOARD_VALUES, this.keyboard(), ""));
        result.put(Type.NAVIGATION_HIDDEN, this.getOrDefault(NAVIGATIONHIDDEN_VALUES, this.navigationHidden(), ""));
        result.put(Type.NAVIGATION, this.getOrDefault(NAVIGATION_VALUES, this.navigation(), ""));
        result.put(Type.SDK_VERSION, this.sdkVersion() != 0 ? "v" + this.sdkVersion() : "");
        return result;
    }

    private <K, V> V getOrDefault(Map<K, V> map, K key, V defaultValue) {
        V value = map.get(key);
        return value != null ? value : defaultValue;
    }

    public static enum Type {
        MCC,
        MNC,
        LANGUAGE_STRING,
        REGION_STRING,
        SCREEN_LAYOUT_DIRECTION,
        SMALLEST_SCREEN_WIDTH_DP,
        SCREEN_WIDTH_DP,
        SCREEN_HEIGHT_DP,
        SCREEN_LAYOUT_SIZE,
        SCREEN_LAYOUT_LONG,
        SCREEN_LAYOUT_ROUND,
        ORIENTATION,
        UI_MODE_TYPE,
        UI_MODE_NIGHT,
        DENSITY_DPI,
        TOUCHSCREEN,
        KEYBOARD_HIDDEN,
        KEYBOARD,
        NAVIGATION_HIDDEN,
        NAVIGATION,
        SDK_VERSION;

    }
}

