/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.res;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.UnsignedBytes;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class ResourceString {
    private ResourceString() {
    }

    public static String decodeString(ByteBuffer buffer, int offset, Type type) {
        int length;
        int characterCount = ResourceString.decodeLength(buffer, offset, type);
        offset += ResourceString.computeLengthOffset(characterCount, type);
        if (type == Type.UTF8) {
            length = ResourceString.decodeLength(buffer, offset, type);
            offset += ResourceString.computeLengthOffset(length, type);
        } else {
            length = characterCount * 2;
        }
        return new String(buffer.array(), offset, length, type.charset());
    }

    public static byte[] encodeString(String str, Type type) {
        byte[] bytes = str.getBytes(type.charset());
        ByteArrayDataOutput output = ByteStreams.newDataOutput(bytes.length + 5);
        ResourceString.encodeLength(output, str.length(), type);
        if (type == Type.UTF8) {
            ResourceString.encodeLength(output, bytes.length, type);
        }
        output.write(bytes);
        if (type == Type.UTF8) {
            output.write(0);
        } else {
            output.writeShort(0);
        }
        return output.toByteArray();
    }

    private static void encodeLength(ByteArrayDataOutput output, int length, Type type) {
        if (length < 0) {
            output.write(0);
            return;
        }
        if (type == Type.UTF8) {
            if (length > 127) {
                output.write((length & 0x7F00) >> 8 | 0x80);
            }
            output.write(length & 0xFF);
        } else {
            if (length > Short.MAX_VALUE) {
                int highBytes = (length & 0x7FFF0000) >> 16 | 0x8000;
                output.write(highBytes & 0xFF);
                output.write((highBytes & 0xFF00) >> 8);
            }
            int lowBytes = length & 0xFFFF;
            output.write(lowBytes & 0xFF);
            output.write((lowBytes & 0xFF00) >> 8);
        }
    }

    private static int computeLengthOffset(int length, Type type) {
        return (type == Type.UTF8 ? 1 : 2) * (length >= (type == Type.UTF8 ? 128 : 32768) ? 2 : 1);
    }

    private static int decodeLength(ByteBuffer buffer, int offset, Type type) {
        return type == Type.UTF8 ? ResourceString.decodeLengthUTF8(buffer, offset) : ResourceString.decodeLengthUTF16(buffer, offset);
    }

    private static int decodeLengthUTF8(ByteBuffer buffer, int offset) {
        int length = UnsignedBytes.toInt(buffer.get(offset));
        if ((length & 0x80) != 0) {
            length = (length & 0x7F) << 8 | UnsignedBytes.toInt(buffer.get(offset + 1));
        }
        return length;
    }

    private static int decodeLengthUTF16(ByteBuffer buffer, int offset) {
        int length = buffer.getShort(offset) & 0xFFFF;
        if ((length & 0x8000) != 0) {
            length = (length & Short.MAX_VALUE) << 16 | buffer.getShort(offset + 2) & 0xFFFF;
        }
        return length;
    }

    public static enum Type {
        UTF8(StandardCharsets.UTF_8),
        UTF16(StandardCharsets.UTF_16LE);

        private final Charset charset;

        private Type(Charset charset) {
            this.charset = charset;
        }

        public Charset charset() {
            return this.charset;
        }
    }
}

