/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.res;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.cf.apkfile.res.Chunk;
import org.cf.apkfile.res.ChunkWithChunks;
import org.cf.apkfile.res.PackageChunk;
import org.cf.apkfile.res.StringPoolChunk;
import org.cf.apkfile.res.TypeChunk;

public final class ResourceTableChunk
extends ChunkWithChunks {
    private final Map<String, PackageChunk> packages = new HashMap<String, PackageChunk>();
    private StringPoolChunk stringPool;

    protected ResourceTableChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        Preconditions.checkState(buffer.getInt() >= 1, "ResourceTableChunk package count was < 1.");
    }

    @Override
    protected void init(ByteBuffer buffer) {
        super.init(buffer);
        this.packages.clear();
        for (Chunk chunk : this.getChunks().values()) {
            if (chunk instanceof PackageChunk) {
                PackageChunk packageChunk = (PackageChunk)chunk;
                this.packages.put(packageChunk.getPackageName(), packageChunk);
                continue;
            }
            if (!(chunk instanceof StringPoolChunk)) continue;
            this.stringPool = (StringPoolChunk)chunk;
        }
        Preconditions.checkNotNull(this.stringPool, "ResourceTableChunk must have a string pool.");
    }

    public StringPoolChunk getStringPool() {
        return this.stringPool;
    }

    @Nullable
    public PackageChunk getPackage(String packageName) {
        return this.packages.get(packageName);
    }

    @Nullable
    public PackageChunk getPackage(int packageId) {
        for (PackageChunk packageChunk : this.packages.values()) {
            if (packageChunk.getId() != packageId) continue;
            return packageChunk;
        }
        return null;
    }

    public Collection<PackageChunk> getPackages() {
        return Collections.unmodifiableCollection(this.packages.values());
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.TABLE;
    }

    private static int getEntryIndex(int id) {
        return id & 0xFFFF;
    }

    public int getPackageCount() {
        return this.packages.size();
    }

    private static int getPackageId(int entryId) {
        return entryId >> 24 & 0xFF;
    }

    private static int getTypeId(int entryId) {
        return entryId >> 16 & 0xFF;
    }

    private Collection<TypeChunk> getResourceTypes(int entryId) {
        int packageId = ResourceTableChunk.getPackageId(entryId);
        PackageChunk packageChunk = this.getPackage(packageId);
        if (packageChunk == null) {
            return null;
        }
        int typeId = ResourceTableChunk.getTypeId(entryId);
        return packageChunk.getTypeChunks(typeId);
    }

    @Nullable
    String resolve(int id) {
        int entryIndex = ResourceTableChunk.getEntryIndex(id);
        Collection<TypeChunk> typeChunks = this.getResourceTypes(id);
        if (typeChunks == null) {
            return null;
        }
        for (TypeChunk typeChunk : typeChunks) {
            TypeChunk.Entry entry = typeChunk.getEntries().get(entryIndex);
            if (entry == null) continue;
            if (entry.value() == null) {
                String valueType;
                int packageId = ResourceTableChunk.getPackageId(id);
                PackageChunk packageChunk = this.getPackage(packageId);
                if (packageChunk == null) {
                    valueType = "unknown";
                } else {
                    int typeIndex = ResourceTableChunk.getTypeId(id) - 1;
                    valueType = packageChunk.getTypeStringPool().getString(typeIndex);
                }
                return "@" + valueType + "/" + entry.key();
            }
            return entry.value().getString(this.getStringPool(), this);
        }
        return null;
    }

    @Override
    protected void writeHeader(ByteBuffer output) {
        super.writeHeader(output);
        output.putInt(this.packages.size());
    }
}

