/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.res;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedBytes;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import javax.annotation.Nullable;
import org.cf.apkfile.res.AutoValue_ResourceValue;
import org.cf.apkfile.res.ResourceTableChunk;
import org.cf.apkfile.res.SerializableResource;
import org.cf.apkfile.res.StringPoolChunk;

public abstract class ResourceValue
implements SerializableResource {
    private static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.0517578E-5f, 1.1920929E-7f, 4.656613E-10f};
    private static final String[] DIMENSION_UNIT_STRS = new String[]{"px", "dip", "sp", "pt", "in", "mm"};
    private static final String[] FRACTION_UNIT_STRS = new String[]{"%", "%p"};
    public static final int SIZE = 8;

    public static ResourceValue create(ByteBuffer buffer) {
        int size = buffer.getShort() & 0xFFFF;
        buffer.get();
        Type type = Type.fromCode(buffer.get());
        int data = buffer.getInt();
        return new AutoValue_ResourceValue(size, type, data);
    }

    public abstract int size();

    public abstract Type type();

    public abstract int data();

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(false);
    }

    @Override
    public byte[] toByteArray(boolean shrink) {
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putShort((short)this.size());
        buffer.put((byte)0);
        buffer.put(this.type().code());
        buffer.putInt(this.data());
        return buffer.array();
    }

    private static float complexToFloat(int complex) {
        return (float)(complex & 0xFFFFFF00) * RADIX_MULTS[complex >> 4 & 3];
    }

    protected String getString(StringPoolChunk stringPool, @Nullable ResourceTableChunk resourceTable) {
        switch (this.type()) {
            case INT_BOOLEAN: {
                return this.data() != 0 ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
            }
            case REFERENCE: {
                String value;
                if (resourceTable != null && (value = resourceTable.resolve(this.data())) != null) {
                    return value;
                }
                return "U[" + this.data() + "]";
            }
            case STRING: {
                return stringPool.getString(this.data());
            }
            case INT_HEX: 
            case INT_DEC: {
                return Integer.toString(this.data());
            }
            case NULL: {
                return "";
            }
            case ATTRIBUTE: {
                return "A[" + this.data() + "]";
            }
            case FLOAT: {
                return Float.toString(Float.intBitsToFloat(this.data()));
            }
            case DIMENSION: {
                return Float.toString(ResourceValue.complexToFloat(this.data())) + DIMENSION_UNIT_STRS[this.data() & 0xF];
            }
            case FRACTION: {
                return Float.toString(ResourceValue.complexToFloat(this.data())) + DIMENSION_UNIT_STRS[this.data() & 0xF];
            }
        }
        if (this.type().code >= Type.INT_COLOR_ARGB8.code && this.type().code <= Type.INT_COLOR_RGB4.code) {
            String res = String.format("%08x", this.data());
            char[] vals = res.toCharArray();
            switch (this.type()) {
                default: {
                    break;
                }
                case INT_COLOR_RGB8: {
                    res = res.substring(2);
                    break;
                }
                case INT_COLOR_ARGB4: {
                    res = String.valueOf(vals[0]) + vals[2] + vals[4] + vals[6];
                    break;
                }
                case INT_COLOR_RGB4: {
                    res = String.valueOf(vals[2]) + vals[4] + vals[6];
                }
            }
            return "#" + res;
        }
        if (this.type().code >= Type.INT_DEC.code && this.type().code <= Type.INT_COLOR_RGB4.code) {
            return Integer.toString(this.data());
        }
        return "";
    }

    public static enum Type {
        NULL(0),
        REFERENCE(1),
        ATTRIBUTE(2),
        STRING(3),
        FLOAT(4),
        DIMENSION(5),
        FRACTION(6),
        DYNAMIC_ATTRIBUTE(8),
        DYNAMIC_REFERENCE(7),
        INT_DEC(16),
        INT_HEX(17),
        INT_BOOLEAN(18),
        INT_COLOR_ARGB8(28),
        INT_COLOR_RGB8(29),
        INT_COLOR_ARGB4(30),
        INT_COLOR_RGB4(31);

        private static final Map<Byte, Type> FROM_BYTE;
        private final byte code;

        private Type(int code) {
            this.code = UnsignedBytes.checkedCast(code);
        }

        public static Type fromCode(byte code) {
            return Preconditions.checkNotNull(FROM_BYTE.get(code), "Unknown resource type: %s", code);
        }

        public byte code() {
            return this.code;
        }

        static {
            ImmutableMap.Builder<Byte, Type> builder = ImmutableMap.builder();
            for (Type type : Type.values()) {
                builder.put(type.code(), type);
            }
            FROM_BYTE = builder.build();
        }
    }
}

