/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.res;

import com.google.common.primitives.UnsignedBytes;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.cf.apkfile.res.Chunk;

public final class TypeSpecChunk
extends Chunk {
    private final int id;
    private final int[] resources;

    protected TypeSpecChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        this.id = UnsignedBytes.toInt(buffer.get());
        buffer.position(buffer.position() + 3);
        int resourceCount = buffer.getInt();
        this.resources = new int[resourceCount];
        for (int i = 0; i < resourceCount; ++i) {
            this.resources[i] = buffer.getInt();
        }
    }

    public int getId() {
        return this.id;
    }

    public int getResourceCount() {
        return this.resources.length;
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.TABLE_TYPE_SPEC;
    }

    @Override
    protected void writeHeader(ByteBuffer output) {
        super.writeHeader(output);
        output.putInt(this.id);
        output.putInt(this.resources.length);
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, boolean shrink) throws IOException {
        for (int resource : this.resources) {
            output.writeInt(resource);
        }
    }
}

