/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.res;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.cf.apkfile.res.Chunk;
import org.pmw.tinylog.Logger;

public final class UnknownChunk
extends Chunk {
    private final byte[] header;
    private final byte[] payload;
    private final int dummyChunkSize;

    protected UnknownChunk(ByteBuffer buffer, @Nullable Chunk parent) throws IllegalArgumentException {
        super(buffer, parent);
        if (this.headerSize > this.chunkSize) {
            Logger.warn("Header size (" + this.headerSize + ") > chunk size (" + this.chunkSize + ")");
            this.header = new byte[0];
            this.payload = new byte[0];
            this.dummyChunkSize = Math.min(this.headerSize + this.chunkSize, buffer.remaining() + 8);
            return;
        }
        if (this.headerSize + this.chunkSize > buffer.remaining()) {
            Logger.warn("Chunk size (" + (this.headerSize + this.chunkSize) + ") greater than remaining buffer (" + buffer.remaining() + ")");
            this.header = new byte[0];
            this.payload = new byte[0];
            this.dummyChunkSize = Math.max(buffer.remaining(), 8);
            return;
        }
        if (this.headerSize == 0) {
            Logger.warn("Header size is 0, which is wrong");
            this.header = new byte[0];
            this.payload = new byte[0];
            this.dummyChunkSize = 8;
            return;
        }
        this.header = new byte[this.headerSize - 8];
        this.payload = new byte[this.chunkSize - this.headerSize];
        this.dummyChunkSize = this.chunkSize;
        buffer.get(this.header);
        buffer.get(this.payload);
    }

    @Override
    protected void writeHeader(ByteBuffer output) {
        output.put(this.header);
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, boolean shrink) throws IOException {
        output.write(this.payload);
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.UNKNOWN;
    }

    @Override
    public int getOriginalChunkSize() {
        return this.dummyChunkSize;
    }
}

