/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.res;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.cf.apkfile.res.AutoValue_XmlAttribute;
import org.cf.apkfile.res.ResourceValue;
import org.cf.apkfile.res.SerializableResource;
import org.cf.apkfile.res.XmlNodeChunk;

public abstract class XmlAttribute
implements SerializableResource {
    public static final int SIZE = 20;

    public static XmlAttribute create(ByteBuffer buffer, XmlNodeChunk parent) {
        int namespace = buffer.getInt();
        int name = buffer.getInt();
        int rawValue = buffer.getInt();
        ResourceValue typedValue = ResourceValue.create(buffer);
        return new AutoValue_XmlAttribute(namespace, name, rawValue, typedValue, parent);
    }

    public abstract int namespaceIndex();

    public abstract int nameIndex();

    public abstract int rawValueIndex();

    public abstract ResourceValue typedValue();

    public abstract XmlNodeChunk parent();

    public final String namespace() {
        return this.getString(this.namespaceIndex());
    }

    public final String name() {
        return this.getString(this.nameIndex());
    }

    public final String rawValue() {
        return this.getString(this.rawValueIndex());
    }

    private String getString(int index) {
        return this.parent().getString(index);
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(false);
    }

    @Override
    public byte[] toByteArray(boolean shrink) {
        ByteBuffer buffer = ByteBuffer.allocate(20).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(this.namespaceIndex());
        buffer.putInt(this.nameIndex());
        buffer.putInt(this.rawValueIndex());
        buffer.put(this.typedValue().toByteArray(shrink));
        return buffer.array();
    }

    public String toString() {
        return String.format("XmlAttribute{namespace=%s, name=%s, value=%s}", this.namespace(), this.name(), this.rawValue());
    }
}

