/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.res;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.cf.apkfile.res.AttributeId;
import org.cf.apkfile.res.Chunk;
import org.cf.apkfile.res.ChunkWithChunks;
import org.cf.apkfile.res.StringPoolChunk;
import org.cf.apkfile.res.XmlEndElementChunk;
import org.cf.apkfile.res.XmlResourceMapChunk;
import org.cf.apkfile.res.XmlStartElementChunk;

public final class XmlChunk
extends ChunkWithChunks {
    protected XmlChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.XML;
    }

    public String getString(int index) {
        for (Chunk chunk : this.getChunks().values()) {
            if (!(chunk instanceof StringPoolChunk)) continue;
            return ((StringPoolChunk)chunk).getString(index);
        }
        throw new IllegalStateException("XmlChunk did not contain a string pool.");
    }

    @Nullable
    Integer getResourceIndex(AttributeId attributeId) {
        for (Chunk chunk : this.getChunks().values()) {
            if (!(chunk instanceof XmlResourceMapChunk)) continue;
            XmlResourceMapChunk resourceMap = (XmlResourceMapChunk)chunk;
            return resourceMap.getResourceIndex(attributeId);
        }
        throw new IllegalStateException("XmlChunk did not contain a resource map.");
    }

    public List<Chunk> getChunksWithin(XmlStartElementChunk startChunk) {
        String startName = startChunk.getName();
        LinkedList<Chunk> chunksWithin = new LinkedList<Chunk>();
        int depth = 0;
        for (Chunk chunk : this.getChunks().values()) {
            String name;
            if (depth == 0) {
                if (chunk != startChunk) continue;
                ++depth;
                continue;
            }
            chunksWithin.add(chunk);
            if (chunk instanceof XmlStartElementChunk) {
                name = ((XmlStartElementChunk)chunk).getName();
                if (!startName.equals(name)) continue;
                ++depth;
                continue;
            }
            if (!(chunk instanceof XmlEndElementChunk)) continue;
            name = ((XmlEndElementChunk)chunk).getName();
            if (startName.equals(name)) {
                --depth;
            }
            if (depth != 0) continue;
            chunksWithin.remove(chunksWithin.size() - 1);
            return chunksWithin;
        }
        return chunksWithin;
    }
}

