/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.res;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.cf.apkfile.res.Chunk;
import org.cf.apkfile.res.StringPoolChunk;
import org.cf.apkfile.res.XmlChunk;

public abstract class XmlNodeChunk
extends Chunk {
    private final int lineNumber;
    private final int comment;

    protected XmlNodeChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        this.lineNumber = buffer.getInt();
        this.comment = buffer.getInt();
    }

    public boolean hasComment() {
        return this.comment != -1;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getComment() {
        return this.getString(this.comment);
    }

    protected StringPoolChunk getStringPool() {
        Chunk chunk = this;
        while (!(chunk instanceof XmlChunk)) {
            chunk = this.getParent();
        }
        for (Chunk c : ((XmlChunk)chunk).getChunks().values()) {
            if (!(c instanceof StringPoolChunk)) continue;
            return (StringPoolChunk)c;
        }
        throw new IllegalStateException("XmlNodeChunk did not have XmlChunk parent with string pool.");
    }

    protected String getString(int index) {
        if (index == -1) {
            return "";
        }
        for (Chunk parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof XmlChunk)) continue;
            return ((XmlChunk)parent).getString(index);
        }
        throw new IllegalStateException("XmlNodeChunk did not have an XmlChunk parent.");
    }

    @Override
    protected final void writeHeader(ByteBuffer output) {
        super.writeHeader(output);
        output.putInt(this.lineNumber);
        output.putInt(this.comment);
    }

    public String toString() {
        return String.format("XmlNodeChunk{line=%d, comment=%s}", this.getLineNumber(), this.getComment());
    }
}

