/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.res;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.cf.apkfile.res.AttributeId;
import org.cf.apkfile.res.Chunk;

public class XmlResourceMapChunk
extends Chunk {
    private final List<Integer> resources = new ArrayList<Integer>();
    private final Map<AttributeId, Integer> attributeIdToResourceIndex = new HashMap<AttributeId, Integer>();

    protected XmlResourceMapChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
    }

    @Override
    protected void init(ByteBuffer buffer) {
        super.init(buffer);
        this.resources.addAll(this.enumerateResources(buffer));
        block0: for (int index = 0; index < this.resources.size(); ++index) {
            Integer attributeIdValue = this.resources.get(index);
            for (AttributeId attributeId : AttributeId.values()) {
                if (attributeId.value() != attributeIdValue.intValue()) continue;
                this.attributeIdToResourceIndex.put(attributeId, index);
                continue block0;
            }
        }
    }

    private List<Integer> enumerateResources(ByteBuffer buffer) {
        int resourceCount = (this.getOriginalChunkSize() - this.getHeaderSize()) / 4;
        ArrayList<Integer> result = new ArrayList<Integer>(resourceCount);
        int offset = this.offset + this.getHeaderSize();
        buffer.mark();
        buffer.position(offset);
        for (int i = 0; i < resourceCount; ++i) {
            result.add(buffer.getInt());
        }
        buffer.reset();
        return result;
    }

    public Integer getResourceIndex(AttributeId attributeId) {
        return this.attributeIdToResourceIndex.get((Object)attributeId);
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.XML_RESOURCE_MAP;
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, boolean shrink) throws IOException {
        super.writePayload(output, header, shrink);
        for (Integer resource : this.resources) {
            output.writeInt(resource);
        }
    }
}

