/*
 * Decompiled with CFR 0.152.
 */
package org.cf.apkfile.res;

import com.google.common.base.Preconditions;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.cf.apkfile.res.AttributeId;
import org.cf.apkfile.res.Chunk;
import org.cf.apkfile.res.ResourceTableChunk;
import org.cf.apkfile.res.XmlAttribute;
import org.cf.apkfile.res.XmlChunk;
import org.cf.apkfile.res.XmlNodeChunk;
import org.pmw.tinylog.Logger;

public final class XmlStartElementChunk
extends XmlNodeChunk {
    private final int namespace;
    private final int name;
    private final int attributeStart;
    private final int attributeCount;
    private final int idIndex;
    private final int classIndex;
    private final int styleIndex;
    private final Map<Integer, XmlAttribute> nameIndexToAttribute = new HashMap<Integer, XmlAttribute>();

    protected XmlStartElementChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        this.namespace = buffer.getInt();
        this.name = buffer.getInt();
        this.attributeStart = buffer.getShort() & 0xFFFF;
        int attributeSize = buffer.getShort() & 0xFFFF;
        Preconditions.checkState(attributeSize == 20, "attributeSize is wrong size. Got %s, want %s", attributeSize, 20);
        this.attributeCount = buffer.getShort() & 0xFFFF;
        this.idIndex = (buffer.getShort() & 0xFFFF) - 1;
        this.classIndex = (buffer.getShort() & 0xFFFF) - 1;
        this.styleIndex = (buffer.getShort() & 0xFFFF) - 1;
    }

    @Override
    protected void init(ByteBuffer buffer) {
        super.init(buffer);
        this.parseAttributes(buffer);
    }

    private void parseAttributes(ByteBuffer buffer) {
        int offset;
        int endOffset = offset + 20 * this.attributeCount;
        buffer.mark();
        buffer.position(offset);
        for (offset = this.offset + this.getHeaderSize() + this.attributeStart; offset < endOffset; offset += 20) {
            XmlAttribute attribute = XmlAttribute.create(buffer, this);
            this.nameIndexToAttribute.put(attribute.nameIndex(), attribute);
        }
        buffer.reset();
    }

    public String getNamespace() {
        return this.getString(this.namespace);
    }

    public String getName() {
        return this.getString(this.name);
    }

    public Collection<XmlAttribute> getAttributes() {
        return Collections.unmodifiableCollection(this.nameIndexToAttribute.values());
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.XML_START_ELEMENT;
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, boolean shrink) throws IOException {
        super.writePayload(output, header, shrink);
        output.writeInt(this.namespace);
        output.writeInt(this.name);
        output.writeShort(20);
        output.writeShort(20);
        output.writeShort((short)this.getAttributes().size());
        output.writeShort((short)(this.idIndex + 1));
        output.writeShort((short)(this.classIndex + 1));
        output.writeShort((short)(this.styleIndex + 1));
        for (XmlAttribute attribute : this.getAttributes()) {
            output.write(attribute.toByteArray(shrink));
        }
    }

    @Nullable
    public String getAttribute(String name) {
        for (XmlAttribute attribute : this.getAttributes()) {
            if (!name.equals(attribute.name())) continue;
            ResourceTableChunk resourceTable = this.getResourceTable();
            return attribute.typedValue().getString(this.getStringPool(), resourceTable);
        }
        return "";
    }

    @Nullable
    private Integer getResourceIndex(AttributeId attributeId) {
        for (Chunk parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof XmlChunk)) continue;
            return ((XmlChunk)parent).getResourceIndex(attributeId);
        }
        throw new IllegalStateException("XmlNodeChunk did not have an XmlChunk parent.");
    }

    public String getAttribute(AttributeId attributeId) {
        Integer resourceIndex = this.getResourceIndex(attributeId);
        if (resourceIndex == null) {
            return "";
        }
        XmlAttribute attribute = this.nameIndexToAttribute.get(resourceIndex);
        if (attribute != null) {
            ResourceTableChunk resourceTable = this.getResourceTable();
            return attribute.typedValue().getString(this.getStringPool(), resourceTable);
        }
        return "";
    }

    public boolean getAttribute(AttributeId attributeId, boolean defaultValue) {
        String value = this.getAttribute(attributeId);
        return this.convertValueToBoolean(value, defaultValue);
    }

    public int getAttribute(AttributeId attributeId, int defaultValue) {
        String value = this.getAttribute(attributeId);
        return this.convertValueToInteger(value, defaultValue);
    }

    private int convertValueToInteger(String value, int defaultValue) {
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            Logger.warn(e);
            return defaultValue;
        }
    }

    private boolean convertValueToBoolean(String value, boolean defaultValue) {
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return value.equals(Boolean.TRUE.toString());
    }

    public int getAttribute(String name, int defaultValue) {
        String value = this.getAttribute(name);
        return this.convertValueToInteger(value, defaultValue);
    }

    public boolean getAttribute(String name, boolean defaultValue) {
        String value = this.getAttribute(name);
        return this.convertValueToBoolean(value, defaultValue);
    }

    @Override
    public String toString() {
        return String.format("XmlStartElementChunk{line=%d, comment=%s, namespace=%s, name=%s, attributes=%s}", this.getLineNumber(), this.getComment(), this.getNamespace(), this.getName(), this.getAttributes().toString());
    }
}

