/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.io.ByteStreams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.BaseDexBuffer;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.MultiDexContainer;
import org.jf.util.AbstractForwardSequentialList;

public class OatFile
extends BaseDexBuffer
implements MultiDexContainer<OatDexFile> {
    private static final byte[] ELF_MAGIC = new byte[]{127, 69, 76, 70};
    private static final byte[] OAT_MAGIC = new byte[]{111, 97, 116, 10};
    public static final int UNSUPPORTED = 0;
    public static final int SUPPORTED = 1;
    public static final int UNKNOWN = 2;
    private final boolean is64bit;
    @Nonnull
    private final OatHeader oatHeader;
    @Nonnull
    private final Opcodes opcodes;
    @Nullable
    private final VdexProvider vdexProvider;

    public OatFile(@Nonnull byte[] buf) {
        this(buf, null);
    }

    public OatFile(@Nonnull byte[] buf, @Nullable VdexProvider vdexProvider) {
        super(buf);
        if (buf.length < 52) {
            throw new NotAnOatFileException();
        }
        OatFile.verifyMagic(buf);
        if (buf[4] == 1) {
            this.is64bit = false;
        } else if (buf[4] == 2) {
            this.is64bit = true;
        } else {
            throw new InvalidOatFileException(String.format("Invalid word-size value: %x", buf[5]));
        }
        OatHeader oatHeader = null;
        SymbolTable symbolTable = this.getSymbolTable();
        for (SymbolTable.Symbol symbol : symbolTable.getSymbols()) {
            if (!symbol.getName().equals("oatdata")) continue;
            oatHeader = new OatHeader(symbol.getFileOffset());
            break;
        }
        if (oatHeader == null) {
            throw new InvalidOatFileException("Oat file has no oatdata symbol");
        }
        this.oatHeader = oatHeader;
        if (!oatHeader.isValid()) {
            throw new InvalidOatFileException("Invalid oat magic value");
        }
        this.opcodes = Opcodes.forArtVersion(oatHeader.getVersion());
        this.vdexProvider = vdexProvider;
    }

    private static void verifyMagic(byte[] buf) {
        for (int i = 0; i < ELF_MAGIC.length; ++i) {
            if (buf[i] == ELF_MAGIC[i]) continue;
            throw new NotAnOatFileException();
        }
    }

    public static OatFile fromInputStream(@Nonnull InputStream is) throws IOException {
        return OatFile.fromInputStream(is, null);
    }

    public static OatFile fromInputStream(@Nonnull InputStream is, @Nullable VdexProvider vdexProvider) throws IOException {
        if (!is.markSupported()) {
            throw new IllegalArgumentException("InputStream must support mark");
        }
        is.mark(4);
        byte[] partialHeader = new byte[4];
        try {
            ByteStreams.readFully(is, partialHeader);
        }
        catch (EOFException ex) {
            throw new NotAnOatFileException();
        }
        finally {
            is.reset();
        }
        OatFile.verifyMagic(partialHeader);
        is.reset();
        byte[] buf = ByteStreams.toByteArray(is);
        return new OatFile(buf, vdexProvider);
    }

    public int getOatVersion() {
        return this.oatHeader.getVersion();
    }

    public int isSupportedVersion() {
        int version = this.getOatVersion();
        if (version < 56) {
            return 0;
        }
        if (version <= 86) {
            return 1;
        }
        return 2;
    }

    @Nonnull
    public List<String> getBootClassPath() {
        if (this.getOatVersion() < 75) {
            return ImmutableList.of();
        }
        String bcp = this.oatHeader.getKeyValue("bootclasspath");
        if (bcp == null) {
            return ImmutableList.of();
        }
        return Arrays.asList(bcp.split(":"));
    }

    @Override
    @Nonnull
    public Opcodes getOpcodes() {
        return this.opcodes;
    }

    @Nonnull
    public List<OatDexFile> getDexFiles() {
        return new AbstractForwardSequentialList<OatDexFile>(){

            @Override
            public int size() {
                return OatFile.this.oatHeader.getDexFileCount();
            }

            @Override
            @Nonnull
            public Iterator<OatDexFile> iterator() {
                return Iterators.transform(new DexEntryIterator(), new Function<DexEntry, OatDexFile>(){

                    @Override
                    @Nullable
                    public OatDexFile apply(DexEntry dexEntry) {
                        return dexEntry.getDexFile();
                    }
                });
            }
        };
    }

    @Override
    @Nonnull
    public List<String> getDexEntryNames() throws IOException {
        return new AbstractForwardSequentialList<String>(){

            @Override
            public int size() {
                return OatFile.this.oatHeader.getDexFileCount();
            }

            @Override
            @Nonnull
            public Iterator<String> iterator() {
                return Iterators.transform(new DexEntryIterator(), new Function<DexEntry, String>(){

                    @Override
                    @Nullable
                    public String apply(DexEntry dexEntry) {
                        return dexEntry.entryName;
                    }
                });
            }
        };
    }

    @Override
    @Nullable
    public OatDexFile getEntry(@Nonnull String entryName) throws IOException {
        DexEntryIterator iterator = new DexEntryIterator();
        while (iterator.hasNext()) {
            DexEntry entry = iterator.next();
            if (!entry.entryName.equals(entryName)) continue;
            return entry.getDexFile();
        }
        return null;
    }

    @Nonnull
    private List<SectionHeader> getSections() {
        int entryCount;
        int entrySize;
        int offset;
        if (this.is64bit) {
            offset = this.readLongAsSmallUint(40);
            entrySize = this.readUshort(58);
            entryCount = this.readUshort(60);
        } else {
            offset = this.readSmallUint(32);
            entrySize = this.readUshort(46);
            entryCount = this.readUshort(48);
        }
        if (offset + entrySize * entryCount > this.buf.length) {
            throw new InvalidOatFileException("The ELF section headers extend past the end of the file");
        }
        return new AbstractList<SectionHeader>(){

            @Override
            public SectionHeader get(int index) {
                if (index < 0 || index >= entryCount) {
                    throw new IndexOutOfBoundsException();
                }
                if (OatFile.this.is64bit) {
                    return new SectionHeader64Bit(offset + index * entrySize);
                }
                return new SectionHeader32Bit(offset + index * entrySize);
            }

            @Override
            public int size() {
                return entryCount;
            }
        };
    }

    @Nonnull
    private SymbolTable getSymbolTable() {
        for (SectionHeader header : this.getSections()) {
            if (header.getType() != 11) continue;
            return new SymbolTable(header);
        }
        throw new InvalidOatFileException("Oat file has no symbol table");
    }

    public static interface VdexProvider {
        @Nullable
        public byte[] getVdex();
    }

    public static class NotAnOatFileException
    extends RuntimeException {
    }

    public static class InvalidOatFileException
    extends RuntimeException {
        public InvalidOatFileException(String message) {
            super(message);
        }
    }

    private class DexEntryIterator
    implements Iterator<DexEntry> {
        int index = 0;
        int offset = OatFile.access$000(OatFile.this).getDexListStart();

        private DexEntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < OatFile.this.oatHeader.getDexFileCount();
        }

        @Override
        public DexEntry next() {
            byte[] buf;
            int filenameLength = OatFile.this.readSmallUint(this.offset);
            this.offset += 4;
            String filename = new String(OatFile.this.buf, this.offset, filenameLength, Charset.forName("US-ASCII"));
            this.offset += filenameLength;
            this.offset += 4;
            int dexOffset = OatFile.this.readSmallUint(this.offset);
            this.offset += 4;
            if (OatFile.this.getOatVersion() >= 87 && OatFile.this.vdexProvider != null && OatFile.this.vdexProvider.getVdex() != null) {
                buf = OatFile.this.vdexProvider.getVdex();
            } else {
                buf = OatFile.this.buf;
                dexOffset += OatFile.this.oatHeader.headerOffset;
            }
            if (OatFile.this.getOatVersion() >= 75) {
                this.offset += 4;
            }
            if (OatFile.this.getOatVersion() >= 73) {
                this.offset += 4;
            }
            if (OatFile.this.getOatVersion() < 75) {
                int classCount = OatFile.this.readSmallUint(dexOffset + 96);
                this.offset += 4 * classCount;
            }
            ++this.index;
            return new DexEntry(filename, buf, dexOffset);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class DexEntry {
        public final String entryName;
        public final byte[] buf;
        public final int dexOffset;

        public DexEntry(String entryName, byte[] buf, int dexOffset) {
            this.entryName = entryName;
            this.buf = buf;
            this.dexOffset = dexOffset;
        }

        public OatDexFile getDexFile() {
            return new OatDexFile(this.buf, this.dexOffset, this.entryName);
        }
    }

    private class StringTable {
        private final int offset;
        private final int size;

        public StringTable(@Nonnull SectionHeader header) {
            this.offset = header.getOffset();
            this.size = header.getSize();
            if (this.offset + this.size > OatFile.this.buf.length) {
                throw new InvalidOatFileException("String table extends past end of file");
            }
        }

        @Nonnull
        public String getString(int index) {
            int start;
            if (index >= this.size) {
                throw new InvalidOatFileException("String index is out of bounds");
            }
            int end = start = this.offset + index;
            while (OatFile.this.buf[end] != 0) {
                if (++end < this.offset + this.size) continue;
                throw new InvalidOatFileException("String extends past end of string table");
            }
            return new String(OatFile.this.buf, start, end - start, Charset.forName("US-ASCII"));
        }
    }

    class SymbolTable {
        @Nonnull
        private final StringTable stringTable;
        private final int offset;
        private final int entryCount;
        private final int entrySize;

        public SymbolTable(@Nonnull SectionHeader header) {
            try {
                this.stringTable = new StringTable((SectionHeader)OatFile.this.getSections().get(header.getLink()));
            }
            catch (IndexOutOfBoundsException ex) {
                throw new InvalidOatFileException("String table section index is invalid");
            }
            this.offset = header.getOffset();
            this.entrySize = header.getEntrySize();
            this.entryCount = header.getSize() / this.entrySize;
            if (this.offset + this.entryCount * this.entrySize > OatFile.this.buf.length) {
                throw new InvalidOatFileException("Symbol table extends past end of file");
            }
        }

        @Nonnull
        public List<Symbol> getSymbols() {
            return new AbstractList<Symbol>(){

                @Override
                public Symbol get(int index) {
                    if (index < 0 || index >= SymbolTable.this.entryCount) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (OatFile.this.is64bit) {
                        return new Symbol64(SymbolTable.this.offset + index * SymbolTable.this.entrySize);
                    }
                    return new Symbol32(SymbolTable.this.offset + index * SymbolTable.this.entrySize);
                }

                @Override
                public int size() {
                    return SymbolTable.this.entryCount;
                }
            };
        }

        public class Symbol64
        extends Symbol {
            public Symbol64(int offset) {
                super(offset);
            }

            @Override
            @Nonnull
            public String getName() {
                return SymbolTable.this.stringTable.getString(OatFile.this.readSmallUint(this.offset));
            }

            @Override
            public long getValue() {
                return OatFile.this.readLong(this.offset + 8);
            }

            @Override
            public int getSize() {
                return OatFile.this.readLongAsSmallUint(this.offset + 16);
            }

            @Override
            public int getSectionIndex() {
                return OatFile.this.readUshort(this.offset + 6);
            }
        }

        public class Symbol32
        extends Symbol {
            public Symbol32(int offset) {
                super(offset);
            }

            @Override
            @Nonnull
            public String getName() {
                return SymbolTable.this.stringTable.getString(OatFile.this.readSmallUint(this.offset));
            }

            @Override
            public long getValue() {
                return OatFile.this.readSmallUint(this.offset + 4);
            }

            @Override
            public int getSize() {
                return OatFile.this.readSmallUint(this.offset + 8);
            }

            @Override
            public int getSectionIndex() {
                return OatFile.this.readUshort(this.offset + 14);
            }
        }

        public abstract class Symbol {
            protected final int offset;

            public Symbol(int offset) {
                this.offset = offset;
            }

            @Nonnull
            public abstract String getName();

            public abstract long getValue();

            public abstract int getSize();

            public abstract int getSectionIndex();

            public int getFileOffset() {
                SectionHeader sectionHeader;
                try {
                    sectionHeader = (SectionHeader)OatFile.this.getSections().get(this.getSectionIndex());
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new InvalidOatFileException("Section index for symbol is out of bounds");
                }
                long sectionAddress = sectionHeader.getAddress();
                int sectionOffset = sectionHeader.getOffset();
                int sectionSize = sectionHeader.getSize();
                long symbolAddress = this.getValue();
                if (symbolAddress < sectionAddress || symbolAddress >= sectionAddress + (long)sectionSize) {
                    throw new InvalidOatFileException("symbol address lies outside it's associated section");
                }
                long fileOffset = (long)sectionOffset + (this.getValue() - sectionAddress);
                assert (fileOffset <= Integer.MAX_VALUE);
                return (int)fileOffset;
            }
        }
    }

    private class SectionHeader64Bit
    extends SectionHeader {
        public SectionHeader64Bit(int offset) {
            super(offset);
        }

        @Override
        public long getAddress() {
            return OatFile.this.readLong(this.offset + 16);
        }

        @Override
        public int getOffset() {
            return OatFile.this.readLongAsSmallUint(this.offset + 24);
        }

        @Override
        public int getSize() {
            return OatFile.this.readLongAsSmallUint(this.offset + 32);
        }

        @Override
        public int getLink() {
            return OatFile.this.readSmallUint(this.offset + 40);
        }

        @Override
        public int getEntrySize() {
            return OatFile.this.readLongAsSmallUint(this.offset + 56);
        }
    }

    private class SectionHeader32Bit
    extends SectionHeader {
        public SectionHeader32Bit(int offset) {
            super(offset);
        }

        @Override
        public long getAddress() {
            return (long)OatFile.this.readInt(this.offset + 12) & 0xFFFFFFFFL;
        }

        @Override
        public int getOffset() {
            return OatFile.this.readSmallUint(this.offset + 16);
        }

        @Override
        public int getSize() {
            return OatFile.this.readSmallUint(this.offset + 20);
        }

        @Override
        public int getLink() {
            return OatFile.this.readSmallUint(this.offset + 24);
        }

        @Override
        public int getEntrySize() {
            return OatFile.this.readSmallUint(this.offset + 36);
        }
    }

    private abstract class SectionHeader {
        protected final int offset;

        public SectionHeader(int offset) {
            this.offset = offset;
        }

        public int getType() {
            return OatFile.this.readInt(this.offset + 4);
        }

        public abstract long getAddress();

        public abstract int getOffset();

        public abstract int getSize();

        public abstract int getLink();

        public abstract int getEntrySize();
    }

    private class OatHeader {
        private final int headerOffset;

        public OatHeader(int offset) {
            this.headerOffset = offset;
        }

        public boolean isValid() {
            int i;
            for (i = 0; i < OAT_MAGIC.length; ++i) {
                if (OatFile.this.buf[this.headerOffset + i] == OAT_MAGIC[i]) continue;
                return false;
            }
            for (i = 4; i < 7; ++i) {
                if (OatFile.this.buf[this.headerOffset + i] >= 48 && OatFile.this.buf[this.headerOffset + i] <= 57) continue;
                return false;
            }
            return OatFile.this.buf[this.headerOffset + 7] == 0;
        }

        public int getVersion() {
            return Integer.valueOf(new String(OatFile.this.buf, this.headerOffset + 4, 3));
        }

        public int getDexFileCount() {
            return OatFile.this.readSmallUint(this.headerOffset + 20);
        }

        public int getKeyValueStoreSize() {
            if (this.getVersion() < 56) {
                throw new IllegalStateException("Unsupported oat version");
            }
            int fieldOffset = 68;
            return OatFile.this.readSmallUint(this.headerOffset + fieldOffset);
        }

        public int getHeaderSize() {
            if (this.getVersion() < 56) {
                throw new IllegalStateException("Unsupported oat version");
            }
            return 72 + this.getKeyValueStoreSize();
        }

        @Nullable
        public String getKeyValue(@Nonnull String key) {
            int offset;
            int size = this.getKeyValueStoreSize();
            int endOffset = offset + size;
            for (offset = this.headerOffset + 72; offset < endOffset; ++offset) {
                int keyEndOffset;
                String k;
                int keyStartOffset = offset;
                while (offset < endOffset && OatFile.this.buf[offset] != 0) {
                    ++offset;
                }
                if (offset >= endOffset) {
                    throw new InvalidOatFileException("Oat file contains truncated key value store");
                }
                if (!(k = new String(OatFile.this.buf, keyStartOffset, (keyEndOffset = offset++) - keyStartOffset)).equals(key)) continue;
                int valueStartOffset = offset;
                while (offset < endOffset && OatFile.this.buf[offset] != 0) {
                    ++offset;
                }
                if (offset >= endOffset) {
                    throw new InvalidOatFileException("Oat file contains truncated key value store");
                }
                int valueEndOffset = offset;
                return new String(OatFile.this.buf, valueStartOffset, valueEndOffset - valueStartOffset);
            }
            return null;
        }

        public int getDexListStart() {
            return this.headerOffset + this.getHeaderSize();
        }
    }

    public class OatDexFile
    extends DexBackedDexFile
    implements MultiDexContainer.MultiDexFile {
        @Nonnull
        public final String filename;

        public OatDexFile(byte[] buf, int offset, @Nonnull String filename) {
            super(OatFile.this.opcodes, buf, offset);
            this.filename = filename;
        }

        @Override
        @Nonnull
        public String getEntryName() {
            return this.filename;
        }

        @Nonnull
        public OatFile getContainer() {
            return OatFile.this;
        }

        @Override
        public boolean hasOdexOpcodes() {
            return true;
        }
    }
}

