/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.MultiDexContainer;
import org.jf.dexlib2.util.DexUtil;

public class ZipDexContainer
implements MultiDexContainer<ZipDexFile> {
    private final File zipFilePath;
    private final Opcodes opcodes;

    public ZipDexContainer(@Nonnull File zipFilePath, @Nonnull Opcodes opcodes) {
        this.zipFilePath = zipFilePath;
        this.opcodes = opcodes;
    }

    @Override
    @Nonnull
    public Opcodes getOpcodes() {
        return this.opcodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public List<String> getDexEntryNames() throws IOException {
        ArrayList<String> entryNames = Lists.newArrayList();
        ZipFile zipFile = this.getZipFile();
        try {
            Enumeration<? extends ZipEntry> entriesEnumeration = zipFile.entries();
            while (entriesEnumeration.hasMoreElements()) {
                ZipEntry entry = entriesEnumeration.nextElement();
                if (!this.isDex(zipFile, entry)) continue;
                entryNames.add(entry.getName());
            }
            ArrayList<String> arrayList = entryNames;
            return arrayList;
        }
        finally {
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ZipDexFile getEntry(@Nonnull String entryName) throws IOException {
        ZipFile zipFile = this.getZipFile();
        try {
            ZipEntry entry = zipFile.getEntry(entryName);
            if (entry == null) {
                ZipDexFile zipDexFile = null;
                return zipDexFile;
            }
            ZipDexFile zipDexFile = this.loadEntry(zipFile, entry);
            return zipDexFile;
        }
        finally {
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isZipFile() {
        ZipFile zipFile = null;
        try {
            zipFile = this.getZipFile();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        catch (NotAZipFileException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isDex(@Nonnull ZipFile zipFile, @Nonnull ZipEntry zipEntry) throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
        try {
            DexUtil.verifyDexHeader(inputStream);
        }
        catch (DexBackedDexFile.NotADexFile ex) {
            boolean bl = false;
            return bl;
        }
        catch (DexUtil.InvalidFile ex) {
            boolean bl = false;
            return bl;
        }
        catch (DexUtil.UnsupportedFile ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            ((InputStream)inputStream).close();
        }
        return true;
    }

    protected ZipFile getZipFile() throws IOException {
        try {
            return new ZipFile(this.zipFilePath);
        }
        catch (IOException ex) {
            throw new NotAZipFileException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected ZipDexFile loadEntry(@Nonnull ZipFile zipFile, @Nonnull ZipEntry zipEntry) throws IOException {
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        try {
            byte[] buf = ByteStreams.toByteArray(inputStream);
            ZipDexFile zipDexFile = new ZipDexFile(this.opcodes, buf, zipEntry.getName());
            return zipDexFile;
        }
        finally {
            inputStream.close();
        }
    }

    public static class NotAZipFileException
    extends RuntimeException {
    }

    public class ZipDexFile
    extends DexBackedDexFile
    implements MultiDexContainer.MultiDexFile {
        private final String entryName;

        protected ZipDexFile(@Nonnull Opcodes opcodes, @Nonnull byte[] buf, @Nonnull String entryName) {
            super(opcodes, buf, 0);
            this.entryName = entryName;
        }

        @Override
        @Nonnull
        public String getEntryName() {
            return this.entryName;
        }

        @Nonnull
        public MultiDexContainer getContainer() {
            return ZipDexContainer.this;
        }
    }
}

