/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.instruction;

import java.util.List;
import javax.annotation.Nonnull;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction;
import org.jf.dexlib2.dexbacked.util.FixedSizeList;
import org.jf.dexlib2.iface.instruction.formats.ArrayPayload;
import org.jf.util.ExceptionWithContext;

public class DexBackedArrayPayload
extends DexBackedInstruction
implements ArrayPayload {
    public static final Opcode OPCODE = Opcode.ARRAY_PAYLOAD;
    public final int elementWidth;
    public final int elementCount;

    public DexBackedArrayPayload(@Nonnull DexBackedDexFile dexFile, int instructionStart) {
        super(dexFile, OPCODE, instructionStart);
        this.elementWidth = dexFile.readUshort(instructionStart + 2);
        this.elementCount = dexFile.readSmallUint(instructionStart + 4);
        if ((long)this.elementWidth * (long)this.elementCount > Integer.MAX_VALUE) {
            throw new ExceptionWithContext("Invalid array-payload instruction: element width*count overflows", new Object[0]);
        }
    }

    @Override
    public int getElementWidth() {
        return this.elementWidth;
    }

    @Override
    @Nonnull
    public List<Number> getArrayElements() {
        final int elementsStart = this.instructionStart + 8;
        switch (this.elementWidth) {
            abstract class ReturnedList
            extends FixedSizeList<Number> {
                ReturnedList() {
                }

                @Override
                public int size() {
                    return DexBackedArrayPayload.this.elementCount;
                }
            }
            case 1: {
                return new ReturnedList(){
                    {
                    }

                    @Override
                    @Nonnull
                    public Number readItem(int index) {
                        return DexBackedArrayPayload.this.dexFile.readByte(elementsStart + index);
                    }
                };
            }
            case 2: {
                return new ReturnedList(){
                    {
                    }

                    @Override
                    @Nonnull
                    public Number readItem(int index) {
                        return DexBackedArrayPayload.this.dexFile.readShort(elementsStart + index * 2);
                    }
                };
            }
            case 4: {
                return new ReturnedList(){
                    {
                    }

                    @Override
                    @Nonnull
                    public Number readItem(int index) {
                        return DexBackedArrayPayload.this.dexFile.readInt(elementsStart + index * 4);
                    }
                };
            }
            case 8: {
                return new ReturnedList(){
                    {
                    }

                    @Override
                    @Nonnull
                    public Number readItem(int index) {
                        return DexBackedArrayPayload.this.dexFile.readLong(elementsStart + index * 8);
                    }
                };
            }
        }
        throw new ExceptionWithContext("Invalid element width: %d", this.elementWidth);
    }

    @Override
    public int getCodeUnits() {
        return 4 + (this.elementWidth * this.elementCount + 1) / 2;
    }
}

