/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.rewriter;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.base.reference.BaseTypeReference;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.rewriter.Rewriter;
import org.jf.dexlib2.rewriter.RewriterUtils;
import org.jf.dexlib2.rewriter.Rewriters;

public class ClassDefRewriter
implements Rewriter<ClassDef> {
    @Nonnull
    protected final Rewriters rewriters;

    public ClassDefRewriter(@Nonnull Rewriters rewriters) {
        this.rewriters = rewriters;
    }

    @Override
    @Nonnull
    public ClassDef rewrite(@Nonnull ClassDef classDef) {
        return new RewrittenClassDef(classDef);
    }

    protected class RewrittenClassDef
    extends BaseTypeReference
    implements ClassDef {
        @Nonnull
        protected ClassDef classDef;

        public RewrittenClassDef(@Nonnull ClassDef classdef) {
            this.classDef = classdef;
        }

        @Override
        @Nonnull
        public String getType() {
            return ClassDefRewriter.this.rewriters.getTypeRewriter().rewrite(this.classDef.getType());
        }

        @Override
        public int getAccessFlags() {
            return this.classDef.getAccessFlags();
        }

        @Override
        @Nullable
        public String getSuperclass() {
            return RewriterUtils.rewriteNullable(ClassDefRewriter.this.rewriters.getTypeRewriter(), this.classDef.getSuperclass());
        }

        @Override
        @Nonnull
        public List<String> getInterfaces() {
            return RewriterUtils.rewriteList(ClassDefRewriter.this.rewriters.getTypeRewriter(), this.classDef.getInterfaces());
        }

        @Override
        @Nullable
        public String getSourceFile() {
            return this.classDef.getSourceFile();
        }

        @Override
        @Nonnull
        public Set<? extends Annotation> getAnnotations() {
            return RewriterUtils.rewriteSet(ClassDefRewriter.this.rewriters.getAnnotationRewriter(), this.classDef.getAnnotations());
        }

        @Override
        @Nonnull
        public Iterable<? extends Field> getStaticFields() {
            return RewriterUtils.rewriteIterable(ClassDefRewriter.this.rewriters.getFieldRewriter(), this.classDef.getStaticFields());
        }

        @Override
        @Nonnull
        public Iterable<? extends Field> getInstanceFields() {
            return RewriterUtils.rewriteIterable(ClassDefRewriter.this.rewriters.getFieldRewriter(), this.classDef.getInstanceFields());
        }

        @Override
        @Nonnull
        public Iterable<? extends Field> getFields() {
            return new Iterable<Field>(){

                @Override
                @Nonnull
                public Iterator<Field> iterator() {
                    return Iterators.concat(RewrittenClassDef.this.getStaticFields().iterator(), RewrittenClassDef.this.getInstanceFields().iterator());
                }
            };
        }

        @Override
        @Nonnull
        public Iterable<? extends Method> getDirectMethods() {
            return RewriterUtils.rewriteIterable(ClassDefRewriter.this.rewriters.getMethodRewriter(), this.classDef.getDirectMethods());
        }

        @Override
        @Nonnull
        public Iterable<? extends Method> getVirtualMethods() {
            return RewriterUtils.rewriteIterable(ClassDefRewriter.this.rewriters.getMethodRewriter(), this.classDef.getVirtualMethods());
        }

        @Override
        @Nonnull
        public Iterable<? extends Method> getMethods() {
            return new Iterable<Method>(){

                @Override
                @Nonnull
                public Iterator<Method> iterator() {
                    return Iterators.concat(RewrittenClassDef.this.getDirectMethods().iterator(), RewrittenClassDef.this.getVirtualMethods().iterator());
                }
            };
        }
    }
}

