/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.rewriter;

import javax.annotation.Nonnull;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction20bc;
import org.jf.dexlib2.iface.instruction.formats.Instruction21c;
import org.jf.dexlib2.iface.instruction.formats.Instruction22c;
import org.jf.dexlib2.iface.instruction.formats.Instruction31c;
import org.jf.dexlib2.iface.instruction.formats.Instruction35c;
import org.jf.dexlib2.iface.instruction.formats.Instruction3rc;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.rewriter.Rewriter;
import org.jf.dexlib2.rewriter.RewriterUtils;
import org.jf.dexlib2.rewriter.Rewriters;

public class InstructionRewriter
implements Rewriter<Instruction> {
    @Nonnull
    protected final Rewriters rewriters;

    public InstructionRewriter(@Nonnull Rewriters rewriters) {
        this.rewriters = rewriters;
    }

    @Override
    @Nonnull
    public Instruction rewrite(@Nonnull Instruction instruction) {
        if (instruction instanceof ReferenceInstruction) {
            switch (instruction.getOpcode().format) {
                case Format20bc: {
                    return new RewrittenInstruction20bc((Instruction20bc)instruction);
                }
                case Format21c: {
                    return new RewrittenInstruction21c((Instruction21c)instruction);
                }
                case Format22c: {
                    return new RewrittenInstruction22c((Instruction22c)instruction);
                }
                case Format31c: {
                    return new RewrittenInstruction31c((Instruction31c)instruction);
                }
                case Format35c: {
                    return new RewrittenInstruction35c((Instruction35c)instruction);
                }
                case Format3rc: {
                    return new RewrittenInstruction3rc((Instruction3rc)instruction);
                }
            }
            throw new IllegalArgumentException();
        }
        return instruction;
    }

    protected class RewrittenInstruction3rc
    extends BaseRewrittenReferenceInstruction<Instruction3rc>
    implements Instruction3rc {
        public RewrittenInstruction3rc(@Nonnull Instruction3rc instruction) {
            super(InstructionRewriter.this, (ReferenceInstruction)instruction);
        }

        @Override
        public int getStartRegister() {
            return ((Instruction3rc)this.instruction).getStartRegister();
        }

        @Override
        public int getRegisterCount() {
            return ((Instruction3rc)this.instruction).getRegisterCount();
        }
    }

    protected class RewrittenInstruction35c
    extends BaseRewrittenReferenceInstruction<Instruction35c>
    implements Instruction35c {
        public RewrittenInstruction35c(@Nonnull Instruction35c instruction) {
            super(InstructionRewriter.this, (ReferenceInstruction)instruction);
        }

        @Override
        public int getRegisterC() {
            return ((Instruction35c)this.instruction).getRegisterC();
        }

        @Override
        public int getRegisterE() {
            return ((Instruction35c)this.instruction).getRegisterE();
        }

        @Override
        public int getRegisterG() {
            return ((Instruction35c)this.instruction).getRegisterG();
        }

        @Override
        public int getRegisterCount() {
            return ((Instruction35c)this.instruction).getRegisterCount();
        }

        @Override
        public int getRegisterD() {
            return ((Instruction35c)this.instruction).getRegisterD();
        }

        @Override
        public int getRegisterF() {
            return ((Instruction35c)this.instruction).getRegisterF();
        }
    }

    protected class RewrittenInstruction31c
    extends BaseRewrittenReferenceInstruction<Instruction31c>
    implements Instruction31c {
        public RewrittenInstruction31c(@Nonnull Instruction31c instruction) {
            super(InstructionRewriter.this, (ReferenceInstruction)instruction);
        }

        @Override
        public int getRegisterA() {
            return ((Instruction31c)this.instruction).getRegisterA();
        }
    }

    protected class RewrittenInstruction22c
    extends BaseRewrittenReferenceInstruction<Instruction22c>
    implements Instruction22c {
        public RewrittenInstruction22c(@Nonnull Instruction22c instruction) {
            super(InstructionRewriter.this, (ReferenceInstruction)instruction);
        }

        @Override
        public int getRegisterA() {
            return ((Instruction22c)this.instruction).getRegisterA();
        }

        @Override
        public int getRegisterB() {
            return ((Instruction22c)this.instruction).getRegisterB();
        }
    }

    protected class RewrittenInstruction21c
    extends BaseRewrittenReferenceInstruction<Instruction21c>
    implements Instruction21c {
        public RewrittenInstruction21c(@Nonnull Instruction21c instruction) {
            super(InstructionRewriter.this, (ReferenceInstruction)instruction);
        }

        @Override
        public int getRegisterA() {
            return ((Instruction21c)this.instruction).getRegisterA();
        }
    }

    protected class RewrittenInstruction20bc
    extends BaseRewrittenReferenceInstruction<Instruction20bc>
    implements Instruction20bc {
        public RewrittenInstruction20bc(@Nonnull Instruction20bc instruction) {
            super(InstructionRewriter.this, (ReferenceInstruction)instruction);
        }

        @Override
        public int getVerificationError() {
            return ((Instruction20bc)this.instruction).getVerificationError();
        }
    }

    protected static class BaseRewrittenReferenceInstruction<T extends ReferenceInstruction>
    implements ReferenceInstruction {
        @Nonnull
        protected T instruction;
        final /* synthetic */ InstructionRewriter this$0;

        protected BaseRewrittenReferenceInstruction(@Nonnull T instruction) {
            this.this$0 = this$0;
            this.instruction = instruction;
        }

        @Override
        @Nonnull
        public Reference getReference() {
            switch (this.getReferenceType()) {
                case 1: {
                    return RewriterUtils.rewriteTypeReference(this.this$0.rewriters.getTypeRewriter(), (TypeReference)this.instruction.getReference());
                }
                case 2: {
                    return this.this$0.rewriters.getFieldReferenceRewriter().rewrite((FieldReference)this.instruction.getReference());
                }
                case 3: {
                    return this.this$0.rewriters.getMethodReferenceRewriter().rewrite((MethodReference)this.instruction.getReference());
                }
                case 0: {
                    return this.instruction.getReference();
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public int getReferenceType() {
            return this.instruction.getReferenceType();
        }

        @Override
        public Opcode getOpcode() {
            return this.instruction.getOpcode();
        }

        @Override
        public int getCodeUnits() {
            return this.instruction.getCodeUnits();
        }
    }
}

