/*
 * Decompiled with CFR 0.152.
 */
package org.pmw.tinylog;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.pmw.tinylog.Configuration;
import org.pmw.tinylog.Configurator;
import org.pmw.tinylog.InternalLogger;
import org.pmw.tinylog.PropertiesLoader;
import org.pmw.tinylog.WritingThread;
import org.pmw.tinylog.writers.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ConfigurationObserver
extends Thread {
    private static final Configuration DEFAULT_CONFIGURATION = Configurator.defaultConfig().create();
    private static final Object mutex = new Object();
    private static ConfigurationObserver activeObserver;
    private final Configurator basisConfigurator;
    private final Properties basisProperties;
    private final String file;
    private volatile boolean shutdown;

    private ConfigurationObserver(Configurator configurator, Properties properties, String string) {
        this.basisConfigurator = configurator;
        this.basisProperties = properties;
        this.file = string;
        this.shutdown = false;
        this.setName("tinylog-ConfigurationObserver");
        this.setPriority(3);
        this.setDaemon(true);
    }

    static ConfigurationObserver createFileConfigurationObserver(Configurator configurator, Properties properties, final String string) {
        return new ConfigurationObserver(configurator, properties, string){

            protected InputStream openInputStream() {
                try {
                    return new FileInputStream(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
        };
    }

    static ConfigurationObserver createResourceConfigurationObserver(Configurator configurator, Properties properties, final String string) {
        return new ConfigurationObserver(configurator, properties, string){

            protected InputStream openInputStream() {
                return ConfigurationObserver.class.getClassLoader().getResourceAsStream(string);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationObserver getActiveObserver() {
        Object object = mutex;
        synchronized (object) {
            return activeObserver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = mutex;
        synchronized (object) {
            Configurator.shutdownConfigurationObserver(true);
            super.start();
            activeObserver = this;
        }
    }

    @Override
    public final void run() {
        Properties properties = this.basisProperties;
        Object object = this.basisConfigurator;
        while (!this.shutdown) {
            Object object2;
            Properties properties2 = this.readProperties();
            if (properties2 != null) {
                object2 = (Properties)System.getProperties().clone();
                for (Object object3 : ((Properties)object2).keySet()) {
                    String string = (String)object3;
                    if (!string.startsWith("tinylog.")) continue;
                    properties2.put(object3, ((Properties)object2).getProperty(string));
                }
            }
            if (this.changed(properties2, properties)) {
                object2 = ((Configurator)object).copy();
                if (properties2 != null) {
                    Object object4;
                    if (this.levelHasChanged(properties2, properties)) {
                        ((Configurator)object2).level(null).resetCustomLevels();
                        PropertiesLoader.readLevel((Configurator)object2, properties2);
                    }
                    if (this.formatPaternHasChanged(properties2, properties)) {
                        ((Configurator)object2).formatPattern(DEFAULT_CONFIGURATION.getFormatPattern());
                        PropertiesLoader.readFormatPattern((Configurator)object2, properties2);
                    }
                    if (this.localeHasChanged(properties2, properties)) {
                        ((Configurator)object2).locale(DEFAULT_CONFIGURATION.getLocale());
                        PropertiesLoader.readLocale((Configurator)object2, properties2);
                    }
                    if (this.maxStackTraceElementsHasChanged(properties2, properties)) {
                        ((Configurator)object2).maxStackTraceElements(DEFAULT_CONFIGURATION.getMaxStackTraceElements());
                        PropertiesLoader.readMaxStackTraceElements((Configurator)object2, properties2);
                    }
                    if (this.writerHasChanged(properties2, properties)) {
                        object4 = DEFAULT_CONFIGURATION.getWriters().iterator();
                        ((Configurator)object2).writer(object4.hasNext() ? (Writer)object4.next() : null);
                        while (object4.hasNext()) {
                            ((Configurator)object2).addWriter((Writer)object4.next());
                        }
                        PropertiesLoader.readWriters((Configurator)object2, properties2);
                    }
                    if (this.writingThreadHasChanged(properties2, properties)) {
                        object4 = DEFAULT_CONFIGURATION.getWritingThread();
                        if (object4 == null) {
                            ((Configurator)object2).writingThread(false);
                        } else {
                            ((Configurator)object2).writingThread(((WritingThread)object4).getNameOfThreadToObserve(), ((Thread)object4).getPriority());
                        }
                        PropertiesLoader.readWritingThread((Configurator)object2, properties2);
                    }
                }
                ((Configurator)object2).activate();
                object = object2;
            }
            properties = properties2;
            try {
                ConfigurationObserver.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        this.interrupt();
        Object object = mutex;
        synchronized (object) {
            if (activeObserver == this) {
                activeObserver = null;
            }
        }
    }

    protected abstract InputStream openInputStream();

    private boolean changed(Properties properties, Properties properties2) {
        if (properties2 == null) {
            return properties != null;
        }
        if (properties == null) {
            return true;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.addAll(properties.keySet());
        hashSet.addAll(properties2.keySet());
        for (Object e : hashSet) {
            Object object = properties.get(e);
            Object object2 = properties2.get(e);
            if ((object != null || object2 == null) && (object == null || object.equals(object2))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readProperties() {
        Properties properties;
        InputStream inputStream = null;
        try {
            inputStream = this.openInputStream();
            if (inputStream == null) {
                InternalLogger.error("Failed to open \"{}\"", this.file);
                Properties properties2 = null;
                return properties2;
            }
            Properties properties3 = new Properties();
            properties3.load(inputStream);
            properties = properties3;
        }
        catch (IOException iOException) {
            InternalLogger.error(iOException, "Failed to read properties file");
            Properties properties4 = null;
            return properties4;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    private boolean levelHasChanged(Properties properties, Properties properties2) {
        return this.compare(properties, properties2, Collections.singletonList("tinylog.level"), Collections.singletonList("tinylog.level@"));
    }

    private boolean formatPaternHasChanged(Properties properties, Properties properties2) {
        return this.compare(properties, properties2, Collections.singletonList("tinylog.format"), Collections.<String>emptyList());
    }

    private boolean localeHasChanged(Properties properties, Properties properties2) {
        return this.compare(properties, properties2, Collections.singletonList("tinylog.locale"), Collections.<String>emptyList());
    }

    private boolean maxStackTraceElementsHasChanged(Properties properties, Properties properties2) {
        return this.compare(properties, properties2, Collections.singletonList("tinylog.stacktrace"), Collections.<String>emptyList());
    }

    private boolean writerHasChanged(Properties properties, Properties properties2) {
        return this.compare(properties, properties2, Collections.<String>emptyList(), Collections.singletonList("tinylog.writer"));
    }

    private boolean writingThreadHasChanged(Properties properties, Properties properties2) {
        return this.compare(properties, properties2, Arrays.asList("tinylog.writingthread", "tinylog.writingthread.observe", "tinylog.writingthread.priority"), Collections.<String>emptyList());
    }

    private boolean compare(Properties properties, Properties properties2, List<String> list, List<String> list2) {
        Properties properties3;
        Properties properties4 = this.extract(properties, list, list2);
        return !properties4.equals(properties3 = this.extract(properties2, list, list2));
    }

    private Properties extract(Properties properties, List<String> list, List<String> list2) {
        Properties properties2 = new Properties();
        for (String string : list) {
            if (!properties.containsKey(string)) continue;
            properties2.put(string, properties.get(string));
        }
        for (String string : list2) {
            for (Object object : properties.keySet()) {
                String string2 = (String)object;
                if (!string2.startsWith(string)) continue;
                properties2.put(string2, properties.get(string2));
            }
        }
        return properties2;
    }
}

