/*
 * Decompiled with CFR 0.152.
 */
package org.pmw.tinylog;

import java.io.File;
import org.pmw.tinylog.runtime.AndroidRuntime;
import org.pmw.tinylog.runtime.JavaRuntime;
import org.pmw.tinylog.runtime.RuntimeDialect;

public final class EnvironmentHelper {
    private static final RuntimeDialect DIALECT = EnvironmentHelper.isAndroid() ? new AndroidRuntime() : new JavaRuntime();
    private static final String NEW_LINE = System.getProperty("line.separator");

    private EnvironmentHelper() {
    }

    public static boolean isAndroid() {
        return System.getProperty("java.runtime.name").equalsIgnoreCase("Android Runtime");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static RuntimeDialect getRuntimeDialect() {
        return DIALECT;
    }

    public static String getNewLine() {
        return NEW_LINE;
    }

    public static void makeDirectories(File file) {
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
    }
}

