/*
 * Decompiled with CFR 0.152.
 */
package org.pmw.tinylog.labelers;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.pmw.tinylog.Configuration;
import org.pmw.tinylog.EnvironmentHelper;
import org.pmw.tinylog.InternalLogger;
import org.pmw.tinylog.labelers.Labeler;
import org.pmw.tinylog.labelers.LogFileComparator;
import org.pmw.tinylog.labelers.LogFileFilter;
import org.pmw.tinylog.labelers.PropertiesSupport;

@PropertiesSupport(name="pid")
public final class ProcessIdLabeler
implements Labeler {
    private final String pid = EnvironmentHelper.getRuntimeDialect().getProcessId();
    private LogFileFilter logFileFilter;

    public String getProcessId() {
        return this.pid;
    }

    public void init(Configuration configuration) {
    }

    public File getLogFile(File file) {
        String string = file.getAbsoluteFile().getParent();
        String string2 = file.getName();
        int n = string2.indexOf(46, 1);
        if (n > 0) {
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n);
            this.logFileFilter = new LogFileFilter(string3, string4);
            return new File(string, string3 + "." + this.pid + string4);
        }
        this.logFileFilter = new LogFileFilter(string2, "");
        return new File(string, string2 + "." + this.pid);
    }

    public File roll(File file, int n) throws IOException {
        File[] fileArray;
        if (file.exists() && !file.delete()) {
            InternalLogger.warn("Failed to delete \"{}\"", file);
        }
        if ((fileArray = file.getAbsoluteFile().getParentFile().listFiles(this.logFileFilter)) != null && fileArray.length > n) {
            Arrays.sort(fileArray, LogFileComparator.getInstance());
            for (int i = n; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.delete()) continue;
                InternalLogger.warn("Failed to delete \"{}\"", file2);
            }
        }
        return file;
    }
}

