/*
 * Decompiled with CFR 0.152.
 */
package org.pmw.tinylog.policies;

import java.io.File;
import java.util.Calendar;
import org.pmw.tinylog.Configuration;
import org.pmw.tinylog.policies.Policy;

public abstract class AbstractTimeBasedPolicy
implements Policy {
    private final Calendar calendar;
    private final int field;
    private int multiplier;
    private long nextTime;

    public AbstractTimeBasedPolicy(Calendar calendar, int n) {
        AbstractTimeBasedPolicy.normalize(calendar, n);
        this.calendar = calendar;
        this.field = n;
        this.multiplier = 1;
        this.nextTime = calendar.getTimeInMillis();
    }

    public void init(Configuration configuration) {
    }

    public final boolean check(File file) {
        if (file.exists()) {
            Calendar calendar = (Calendar)this.calendar.clone();
            calendar.add(this.field, -1);
            return calendar.getTimeInMillis() < file.lastModified();
        }
        return true;
    }

    public final boolean check(String string) {
        return System.currentTimeMillis() < this.nextTime;
    }

    public final void reset() {
        Calendar calendar = (Calendar)this.calendar.clone();
        do {
            calendar.add(this.field, this.multiplier);
            ++this.multiplier;
        } while (calendar.getTimeInMillis() <= System.currentTimeMillis());
        this.nextTime = calendar.getTimeInMillis();
    }

    protected static void normalize(Calendar calendar, int n) {
        while (calendar.getTimeInMillis() <= System.currentTimeMillis()) {
            calendar.add(n, 1);
        }
    }
}

