/*
 * Decompiled with CFR 0.152.
 */
package org.pmw.tinylog.policies;

import java.util.Calendar;
import org.pmw.tinylog.policies.AbstractTimeBasedPolicy;
import org.pmw.tinylog.policies.PropertiesSupport;

@PropertiesSupport(name="daily")
public final class DailyPolicy
extends AbstractTimeBasedPolicy {
    public DailyPolicy() {
        super(DailyPolicy.createCalendar(0, 0), 5);
    }

    public DailyPolicy(int n, int n2) throws IllegalArgumentException {
        super(DailyPolicy.createCalendar(n % 24, n2), 5);
    }

    private static Calendar createCalendar(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("hour must be between 0..23");
        }
        if (n2 < 0 || n2 >= 60) {
            throw new IllegalArgumentException("minute must be between 0..59");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, 0);
        calendar.set(14, 0);
        DailyPolicy.normalize(calendar, 5);
        return calendar;
    }
}

