/*
 * Decompiled with CFR 0.152.
 */
package org.pmw.tinylog.policies;

import java.io.File;
import org.pmw.tinylog.Configuration;
import org.pmw.tinylog.policies.Policy;
import org.pmw.tinylog.policies.PropertiesSupport;

@PropertiesSupport(name="size")
public final class SizePolicy
implements Policy {
    private final long maxSize;
    private long size;

    public SizePolicy(long l) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException("maxSize must be > 0");
        }
        this.maxSize = l;
        this.size = 0L;
    }

    public void init(Configuration configuration) {
    }

    public boolean check(File file) {
        if (file.exists()) {
            this.size = file.length();
            return this.size <= this.maxSize;
        }
        return true;
    }

    public boolean check(String string) {
        this.size += (long)string.getBytes().length;
        return this.size <= this.maxSize;
    }

    public void reset() {
        this.size = 0L;
    }
}

