/*
 * Decompiled with CFR 0.152.
 */
package org.pmw.tinylog.policies;

import java.util.Calendar;
import java.util.regex.Pattern;
import org.pmw.tinylog.policies.AbstractTimeBasedPolicy;
import org.pmw.tinylog.policies.PropertiesSupport;

@PropertiesSupport(name="weekly")
public final class WeeklyPolicy
extends AbstractTimeBasedPolicy {
    private static final Pattern DAY_OF_WEEK_PATTERN = Pattern.compile("[1234567]");

    public WeeklyPolicy() {
        super(WeeklyPolicy.createCalendar(1), 3);
    }

    public WeeklyPolicy(int n) throws IllegalArgumentException {
        super(WeeklyPolicy.createCalendar(n), 3);
    }

    private static Calendar createCalendar(int n) {
        if (n < 1 || n > 7) {
            throw new IllegalArgumentException("dayOfWeek must be between 1..7");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(7, WeeklyPolicy.convert(calendar, n));
        WeeklyPolicy.normalize(calendar, 3);
        return calendar;
    }

    private static int convert(Calendar calendar, int n) {
        return (calendar.getFirstDayOfWeek() - 1 + n - 1) % 7 + 1;
    }
}

